/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.rest;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.rest.RestConnection;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.rest.RestMeta;
import org.apache.hop.pipeline.transforms.rest.fields.HeaderField;
import org.apache.hop.pipeline.transforms.rest.fields.MatrixParameterField;
import org.apache.hop.pipeline.transforms.rest.fields.ParameterField;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RestDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = RestMeta.class;
    public static final String CONST_ERROR = "Error";
    private ComboVar wApplicationType;
    private Label wlMethod;
    private ComboVar wMethod;
    private Label wlUrl;
    private TextVar wUrl;
    private TextVar wResult;
    private TextVar wResultCode;
    private TableView wFields;
    private Button wUrlInField;
    private Label wlUrlField;
    private ComboVar wUrlField;
    private Button wMethodInField;
    private Button wPreemptive;
    private Label wlMethodField;
    private ComboVar wMethodField;
    private final RestMeta input;
    private final List<String> inputFields = new ArrayList<String>();
    private Label wlBody;
    private ComboVar wBody;
    private ColumnInfo[] colinf;
    private ColumnInfo[] colinfoparams;
    private TextVar wConnectionTimeout;
    private TextVar wReadTimeout;
    private TextVar wHttpLogin;
    private TextVar wHttpPassword;
    private TextVar wProxyHost;
    private TextVar wProxyPort;
    private Label wlParameters;
    private Label wlMatrixParameters;
    private TableView wParameters;
    private TableView wMatrixParameters;
    private TextVar wResponseTime;
    private TextVar wResponseHeader;
    private TextVar wTrustStorePassword;
    private TextVar wTrustStoreFile;
    private Button wbTrustStoreFile;
    private Button wIgnoreSsl;
    private Button wMatrixGet;
    private MetaSelectionLine wSelectionLine;

    public RestDialog(Shell parent, IVariables variables, RestMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"RestDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.setupButtons(margin);
        this.setupTransformName(lsMod, middle, margin);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"RestDialog.GeneralTab.Title", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)fileLayout);
        Group gSettings = this.setupSettingGroup(wGeneralComp);
        this.setupRestConnectionLine(lsMod, middle, margin, wGeneralComp, gSettings);
        this.setupUrlLine(lsMod, middle, margin, wGeneralComp, gSettings);
        this.setupUrlInFieldLine(middle, margin, gSettings);
        this.setupUrlFieldNameLine(lsMod, middle, margin, gSettings);
        this.setupHttpMethodLine(lsMod, middle, margin, gSettings);
        this.setupMethodInFieldLine(middle, margin, gSettings);
        this.setupMethodNameLine(lsMod, middle, margin, gSettings);
        this.setupBodyLine(lsMod, middle, margin, gSettings);
        this.setupAppTypeLine(lsMod, middle, margin, gSettings);
        this.setupConnectionTimeoutLine(lsMod, gSettings);
        this.setupReadTimeoutLine(lsMod, gSettings);
        FormData fdSettings = new FormData();
        fdSettings.left = new FormAttachment(0, 0);
        fdSettings.right = new FormAttachment(100, 0);
        fdSettings.top = new FormAttachment((Control)this.wTransformName, margin);
        gSettings.setLayoutData((Object)fdSettings);
        Group gOutputFields = this.setupOutputFieldGroup(wGeneralComp);
        this.setupResultLine(lsMod, middle, margin, gSettings, gOutputFields);
        this.setupStatusCodeLine(lsMod, middle, margin, gOutputFields);
        this.setupResponseTimeLine(lsMod, middle, margin, gOutputFields);
        this.setupResponseHeaderLine(lsMod, middle, margin, gSettings, gOutputFields);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment((Control)this.wTransformName, margin);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        CTabItem wAuthTab = new CTabItem(wTabFolder, 0);
        wAuthTab.setFont(GuiResource.getInstance().getFontDefault());
        wAuthTab.setText(BaseMessages.getString(PKG, (String)"RestDialog.Auth.Title", (String[])new String[0]));
        FormLayout alayout = new FormLayout();
        alayout.marginWidth = PropsUi.getFormMargin();
        alayout.marginHeight = PropsUi.getFormMargin();
        Composite wAuthComp = new Composite((Composite)wTabFolder, 0);
        wAuthComp.setLayout((Layout)alayout);
        PropsUi.setLook((Widget)wAuthComp);
        Group gHttpAuth = this.setupAuthGroup(wAuthComp);
        this.setupLoginLine(lsMod, middle, margin, gHttpAuth);
        this.setupPasswordLine(lsMod, middle, margin, gHttpAuth);
        this.setupPreemptiveLine(middle, margin, gHttpAuth);
        FormData fdHttpAuth = new FormData();
        fdHttpAuth.left = new FormAttachment(0, 0);
        fdHttpAuth.right = new FormAttachment(100, 0);
        fdHttpAuth.top = new FormAttachment((Control)gOutputFields, margin);
        gHttpAuth.setLayoutData((Object)fdHttpAuth);
        Group gProxy = this.setupProxyGroup(wAuthComp);
        this.setupProxyHostLine(lsMod, middle, margin, gProxy);
        this.setupProxyPortLine(lsMod, middle, margin, gProxy);
        FormData fdProxy = new FormData();
        fdProxy.left = new FormAttachment(0, 0);
        fdProxy.right = new FormAttachment(100, 0);
        fdProxy.top = new FormAttachment((Control)gHttpAuth, margin);
        gProxy.setLayoutData((Object)fdProxy);
        FormData fdAuthComp = new FormData();
        fdAuthComp.left = new FormAttachment(0, 0);
        fdAuthComp.top = new FormAttachment((Control)this.wTransformName, margin);
        fdAuthComp.right = new FormAttachment(100, 0);
        fdAuthComp.bottom = new FormAttachment(100, 0);
        wAuthComp.setLayoutData((Object)fdAuthComp);
        wAuthComp.layout();
        wAuthTab.setControl((Control)wAuthComp);
        CTabItem wSSLTab = new CTabItem(wTabFolder, 0);
        wSSLTab.setFont(GuiResource.getInstance().getFontDefault());
        wSSLTab.setText(BaseMessages.getString(PKG, (String)"RestDialog.SSL.Title", (String[])new String[0]));
        FormLayout ssll = new FormLayout();
        ssll.marginWidth = PropsUi.getFormMargin();
        ssll.marginHeight = PropsUi.getFormMargin();
        Composite wSSLComp = new Composite((Composite)wTabFolder, 0);
        wSSLComp.setLayout((Layout)ssll);
        PropsUi.setLook((Widget)wSSLComp);
        Group gSSLTrustStore = this.setupTrustoreGroup(wSSLComp);
        Button wbTrustStoreFile = this.setupTrustoreFileLine(lsMod, middle, margin, gSSLTrustStore);
        this.setupTrustorePwdLine(lsMod, middle, margin, gSSLTrustStore, wbTrustStoreFile);
        this.setupIgnoreSslLine(middle, margin, gSSLTrustStore);
        FormData fdSSLTrustStore = new FormData();
        fdSSLTrustStore.left = new FormAttachment(0, 0);
        fdSSLTrustStore.right = new FormAttachment(100, 0);
        fdSSLTrustStore.top = new FormAttachment((Control)gHttpAuth, margin);
        gSSLTrustStore.setLayoutData((Object)fdSSLTrustStore);
        FormData fdSSLComp = new FormData();
        fdSSLComp.left = new FormAttachment(0, 0);
        fdSSLComp.top = new FormAttachment((Control)this.wTransformName, margin);
        fdSSLComp.right = new FormAttachment(100, 0);
        fdSSLComp.bottom = new FormAttachment(100, 0);
        wSSLComp.setLayoutData((Object)fdSSLComp);
        wSSLComp.layout();
        wSSLTab.setControl((Control)wSSLComp);
        CTabItem wAdditionalTab = new CTabItem(wTabFolder, 0);
        wAdditionalTab.setFont(GuiResource.getInstance().getFontDefault());
        wAdditionalTab.setText(BaseMessages.getString(PKG, (String)"RestDialog.Headers.Title", (String[])new String[0]));
        FormLayout addLayout = new FormLayout();
        addLayout.marginWidth = PropsUi.getFormMargin();
        addLayout.marginHeight = PropsUi.getFormMargin();
        Composite wAdditionalComp = new Composite((Composite)wTabFolder, 0);
        wAdditionalComp.setLayout((Layout)addLayout);
        PropsUi.setLook((Widget)wAdditionalComp);
        this.setupHeaderTabContent(lsMod, margin, wAdditionalComp);
        FormData fdAdditionalComp = new FormData();
        fdAdditionalComp.left = new FormAttachment(0, 0);
        fdAdditionalComp.top = new FormAttachment((Control)this.wTransformName, margin);
        fdAdditionalComp.right = new FormAttachment(100, -margin);
        fdAdditionalComp.bottom = new FormAttachment(100, 0);
        wAdditionalComp.setLayoutData((Object)fdAdditionalComp);
        wAdditionalComp.layout();
        wAdditionalTab.setControl((Control)wAdditionalComp);
        CTabItem wParametersTab = new CTabItem(wTabFolder, 0);
        wParametersTab.setFont(GuiResource.getInstance().getFontDefault());
        wParametersTab.setText(BaseMessages.getString(PKG, (String)"RestDialog.Parameters.Title", (String[])new String[0]));
        FormLayout playout = new FormLayout();
        playout.marginWidth = PropsUi.getFormMargin();
        playout.marginHeight = PropsUi.getFormMargin();
        Composite wParametersComp = new Composite((Composite)wTabFolder, 0);
        wParametersComp.setLayout((Layout)playout);
        PropsUi.setLook((Widget)wParametersComp);
        this.setupParameterTabContent(lsMod, margin, wParametersTab, wParametersComp);
        FormData fdParametersComp = new FormData();
        fdParametersComp.left = new FormAttachment(0, 0);
        fdParametersComp.top = new FormAttachment((Control)this.wTransformName, margin);
        fdParametersComp.right = new FormAttachment(100, 0);
        fdParametersComp.bottom = new FormAttachment(100, 0);
        wParametersComp.setLayoutData((Object)fdParametersComp);
        wParametersComp.layout();
        wParametersTab.setControl((Control)wParametersComp);
        CTabItem wMatrixParametersTab = new CTabItem(wTabFolder, 0);
        wMatrixParametersTab.setFont(GuiResource.getInstance().getFontDefault());
        wMatrixParametersTab.setText(BaseMessages.getString(PKG, (String)"RestDialog.MatrixParameters.Title", (String[])new String[0]));
        FormLayout pl = new FormLayout();
        pl.marginWidth = PropsUi.getFormMargin();
        pl.marginHeight = PropsUi.getFormMargin();
        Composite wMatrixParametersComp = new Composite((Composite)wTabFolder, 0);
        wMatrixParametersComp.setLayout((Layout)pl);
        PropsUi.setLook((Widget)wMatrixParametersComp);
        this.setupMatrixParamTabContent(lsMod, margin, wMatrixParametersTab, wMatrixParametersComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.lsResize = event -> {
            Point size = this.shell.getSize();
            this.wFields.setSize(size.x - 10, size.y - 50);
            this.wFields.table.setSize(size.x - 10, size.y - 50);
            this.wFields.redraw();
        };
        this.shell.addListener(11, this.lsResize);
        wTabFolder.setSelection(0);
        this.setComboBoxes();
        this.getData();
        this.activateUrlInfield();
        this.activateMethodInfield();
        this.activateTrustoreFields();
        this.setMethod();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setupMatrixParamTabContent(ModifyListener lsMod, int margin, CTabItem wMatrixParametersTab, Composite wMatrixParametersComp) {
        this.wlMatrixParameters = new Label(wMatrixParametersComp, 0);
        this.wlMatrixParameters.setText(BaseMessages.getString(PKG, (String)"RestDialog.Parameters.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlMatrixParameters);
        FormData fdlMatrixParameters = new FormData();
        fdlMatrixParameters.left = new FormAttachment(0, 0);
        fdlMatrixParameters.top = new FormAttachment((Control)this.wTransformName, margin);
        this.wlMatrixParameters.setLayoutData((Object)fdlMatrixParameters);
        this.wMatrixGet = new Button(wMatrixParametersComp, 8);
        this.wMatrixGet.setText(BaseMessages.getString(PKG, (String)"RestDialog.GetParameters.Button", (String[])new String[0]));
        FormData fdMatrixGet = new FormData();
        fdMatrixGet.top = new FormAttachment((Control)this.wlMatrixParameters, margin);
        fdMatrixGet.right = new FormAttachment(100, 0);
        this.wMatrixGet.setLayoutData((Object)fdMatrixGet);
        int matrixParametersRows = this.input.getMatrixParameterFields().size();
        this.colinfoparams = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"RestDialog.ColumnInfo.ParameterField", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RestDialog.ColumnInfo.ParameterName", (String[])new String[0]), 1, false)};
        this.wMatrixParameters = new TableView(this.variables, wMatrixParametersComp, 67586, this.colinfoparams, matrixParametersRows, lsMod, this.props);
        FormData fdMatrixParameters = new FormData();
        fdMatrixParameters.left = new FormAttachment(0, 0);
        fdMatrixParameters.top = new FormAttachment((Control)this.wlMatrixParameters, margin);
        fdMatrixParameters.right = new FormAttachment((Control)this.wMatrixGet, -margin);
        fdMatrixParameters.bottom = new FormAttachment(100, -margin);
        this.wMatrixParameters.setLayoutData((Object)fdMatrixParameters);
        FormData fdMatrixParametersComp = new FormData();
        fdMatrixParametersComp.left = new FormAttachment(0, 0);
        fdMatrixParametersComp.top = new FormAttachment((Control)this.wTransformName, margin);
        fdMatrixParametersComp.right = new FormAttachment(100, 0);
        fdMatrixParametersComp.bottom = new FormAttachment(100, 0);
        wMatrixParametersComp.setLayoutData((Object)fdMatrixParametersComp);
        wMatrixParametersComp.layout();
        wMatrixParametersTab.setControl((Control)wMatrixParametersComp);
        this.wMatrixGet.addListener(13, e -> this.getParametersFields(this.wMatrixParameters));
    }

    private void setupParameterTabContent(ModifyListener lsMod, int margin, CTabItem wParametersTab, Composite wParametersComp) {
        this.wlParameters = new Label(wParametersComp, 0);
        this.wlParameters.setText(BaseMessages.getString(PKG, (String)"RestDialog.Parameters.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlParameters);
        FormData fdlParameters = new FormData();
        fdlParameters.left = new FormAttachment(0, 0);
        fdlParameters.top = new FormAttachment((Control)this.wTransformName, margin);
        this.wlParameters.setLayoutData((Object)fdlParameters);
        this.wGet = new Button(wParametersComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"RestDialog.GetParameters.Button", (String[])new String[0]));
        FormData fdGet = new FormData();
        fdGet.top = new FormAttachment((Control)this.wlParameters, margin);
        fdGet.right = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)fdGet);
        int ParametersRows = this.input.getParameterFields().size();
        this.colinfoparams = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"RestDialog.ColumnInfo.ParameterField", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RestDialog.ColumnInfo.ParameterName", (String[])new String[0]), 1, false)};
        this.wParameters = new TableView(this.variables, wParametersComp, 67586, this.colinfoparams, ParametersRows, lsMod, this.props);
        FormData fdParameters = new FormData();
        fdParameters.left = new FormAttachment(0, 0);
        fdParameters.top = new FormAttachment((Control)this.wlParameters, margin);
        fdParameters.right = new FormAttachment((Control)this.wGet, -margin);
        fdParameters.bottom = new FormAttachment(100, -margin);
        this.wParameters.setLayoutData((Object)fdParameters);
        wParametersComp.layout();
        wParametersTab.setControl((Control)wParametersComp);
        this.wGet.addListener(13, e -> this.getParametersFields(this.wParameters));
    }

    private Button setupHeaderTabContent(ModifyListener lsMod, int margin, Composite wAdditionalComp) {
        Label wlFields = new Label(wAdditionalComp, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"RestDialog.Headers.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wTransformName, margin);
        wlFields.setLayoutData((Object)fdlFields);
        Button wGetHeaders = new Button(wAdditionalComp, 8);
        wGetHeaders.setText(BaseMessages.getString(PKG, (String)"RestDialog.GetHeaders.Button", (String[])new String[0]));
        FormData fdGetHeaders = new FormData();
        fdGetHeaders.top = new FormAttachment((Control)wlFields, margin);
        fdGetHeaders.right = new FormAttachment(100, 0);
        wGetHeaders.setLayoutData((Object)fdGetHeaders);
        int FieldsRows = this.input.getHeaderFields().size();
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"RestDialog.ColumnInfo.Field", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"RestDialog.ColumnInfo.Name", (String[])new String[0]), 1, false)};
        this.colinf[1].setUsingVariables(true);
        this.wFields = new TableView(this.variables, wAdditionalComp, 67586, this.colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment((Control)wGetHeaders, -margin);
        fdFields.bottom = new FormAttachment(100, -margin);
        this.wFields.setLayoutData((Object)fdFields);
        wGetHeaders.addListener(13, e -> this.getHeaders());
        return wGetHeaders;
    }

    private void setupIgnoreSslLine(int middle, int margin, Group gSSLTrustStore) {
        Label wlIgnoreSsl = new Label((Composite)gSSLTrustStore, 131072);
        wlIgnoreSsl.setText(BaseMessages.getString(PKG, (String)"RestDialog.IgnoreSsl.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIgnoreSsl);
        FormData fdLabel = new FormData();
        fdLabel.left = new FormAttachment(0, 0);
        fdLabel.top = new FormAttachment((Control)this.wTrustStorePassword, margin);
        fdLabel.right = new FormAttachment(middle, -margin);
        wlIgnoreSsl.setLayoutData((Object)fdLabel);
        this.wIgnoreSsl = new Button((Composite)gSSLTrustStore, 32);
        PropsUi.setLook((Widget)this.wIgnoreSsl);
        FormData fdButton = new FormData();
        fdButton.left = new FormAttachment(middle, 0);
        fdButton.top = new FormAttachment((Control)wlIgnoreSsl, 0, 0x1000000);
        fdButton.right = new FormAttachment(100, 0);
        this.wIgnoreSsl.setLayoutData((Object)fdButton);
        this.wIgnoreSsl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestDialog.this.input.setChanged();
                RestDialog.this.activateTrustoreFields();
            }
        });
    }

    private void activateTrustoreFields() {
        this.wTrustStoreFile.setEnabled(!this.wIgnoreSsl.getSelection());
        this.wbTrustStoreFile.setEnabled(!this.wIgnoreSsl.getSelection());
        this.wTrustStorePassword.setEnabled(!this.wIgnoreSsl.getSelection());
    }

    private void setupTrustorePwdLine(ModifyListener lsMod, int middle, int margin, Group gSSLTrustStore, Button wbTrustStoreFile) {
        Label wlTrustStorePassword = new Label((Composite)gSSLTrustStore, 131072);
        wlTrustStorePassword.setText(BaseMessages.getString(PKG, (String)"RestDialog.TrustStorePassword.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTrustStorePassword);
        FormData fdlTrustStorePassword = new FormData();
        fdlTrustStorePassword.left = new FormAttachment(0, 0);
        fdlTrustStorePassword.top = new FormAttachment((Control)wbTrustStoreFile, margin);
        fdlTrustStorePassword.right = new FormAttachment(middle, -margin);
        wlTrustStorePassword.setLayoutData((Object)fdlTrustStorePassword);
        this.wTrustStorePassword = new PasswordTextVar(this.variables, (Composite)gSSLTrustStore, 18436);
        PropsUi.setLook((Widget)this.wTrustStorePassword);
        this.wTrustStorePassword.addModifyListener(lsMod);
        FormData fdTrustStorePassword = new FormData();
        fdTrustStorePassword.left = new FormAttachment(middle, 0);
        fdTrustStorePassword.top = new FormAttachment((Control)wbTrustStoreFile, margin);
        fdTrustStorePassword.right = new FormAttachment(100, 0);
        this.wTrustStorePassword.setLayoutData((Object)fdTrustStorePassword);
    }

    private Button setupTrustoreFileLine(ModifyListener lsMod, int middle, int margin, Group gSSLTrustStore) {
        Label wlTrustStoreFile = new Label((Composite)gSSLTrustStore, 131072);
        wlTrustStoreFile.setText(BaseMessages.getString(PKG, (String)"RestDialog.TrustStoreFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTrustStoreFile);
        FormData fdlTrustStoreFile = new FormData();
        fdlTrustStoreFile.left = new FormAttachment(0, 0);
        fdlTrustStoreFile.top = new FormAttachment(0, margin);
        fdlTrustStoreFile.right = new FormAttachment(middle, -margin);
        wlTrustStoreFile.setLayoutData((Object)fdlTrustStoreFile);
        this.wbTrustStoreFile = new Button((Composite)gSSLTrustStore, 0x1000008);
        PropsUi.setLook((Widget)this.wbTrustStoreFile);
        this.wbTrustStoreFile.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbTrustStoreFile = new FormData();
        fdbTrustStoreFile.right = new FormAttachment(100, 0);
        fdbTrustStoreFile.top = new FormAttachment(0, 0);
        this.wbTrustStoreFile.setLayoutData((Object)fdbTrustStoreFile);
        this.wbTrustStoreFile.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wTrustStoreFile, (IVariables)this.variables, (String[])new String[]{"*.)"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true));
        this.wTrustStoreFile = new TextVar(this.variables, (Composite)gSSLTrustStore, 18436);
        PropsUi.setLook((Widget)this.wTrustStoreFile);
        this.wTrustStoreFile.addModifyListener(lsMod);
        FormData fdTrustStoreFile = new FormData();
        fdTrustStoreFile.left = new FormAttachment(middle, 0);
        fdTrustStoreFile.top = new FormAttachment(0, margin);
        fdTrustStoreFile.right = new FormAttachment((Control)this.wbTrustStoreFile, -margin);
        this.wTrustStoreFile.setLayoutData((Object)fdTrustStoreFile);
        return this.wbTrustStoreFile;
    }

    private Group setupTrustoreGroup(Composite wSSLComp) {
        Group gSSLTrustStore = new Group(wSSLComp, 16);
        gSSLTrustStore.setText(BaseMessages.getString(PKG, (String)"RestDialog.SSLTrustStoreGroup.Label", (String[])new String[0]));
        FormLayout sslTrustStoreLayout = new FormLayout();
        sslTrustStoreLayout.marginWidth = 3;
        sslTrustStoreLayout.marginHeight = 3;
        gSSLTrustStore.setLayout((Layout)sslTrustStoreLayout);
        PropsUi.setLook((Widget)gSSLTrustStore);
        return gSSLTrustStore;
    }

    private void setupConnectionTimeoutLine(ModifyListener lsMod, Group gSettings) {
        int margin = PropsUi.getMargin();
        int middle = this.props.getMiddlePct();
        Label wlConnectionTimeout = new Label((Composite)gSettings, 131072);
        wlConnectionTimeout.setText(BaseMessages.getString(PKG, (String)"RestDialog.ConnectionTimeout.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlConnectionTimeout);
        FormData fdlConnectionTimeout = new FormData();
        fdlConnectionTimeout.top = new FormAttachment((Control)this.wApplicationType, margin);
        fdlConnectionTimeout.left = new FormAttachment(0, 0);
        fdlConnectionTimeout.right = new FormAttachment(middle, -margin);
        wlConnectionTimeout.setLayoutData((Object)fdlConnectionTimeout);
        this.wConnectionTimeout = new TextVar(this.variables, (Composite)gSettings, 18436);
        this.wConnectionTimeout.addModifyListener(lsMod);
        this.wConnectionTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"RestDialog.ConnectionTimeout.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wConnectionTimeout);
        FormData fdConnectionTimeOut = new FormData();
        fdConnectionTimeOut.top = new FormAttachment((Control)this.wApplicationType, margin);
        fdConnectionTimeOut.left = new FormAttachment(middle, 0);
        fdConnectionTimeOut.right = new FormAttachment(100, 0);
        this.wConnectionTimeout.setLayoutData((Object)fdConnectionTimeOut);
    }

    private void setupReadTimeoutLine(ModifyListener lsMod, Group gSettings) {
        int margin = PropsUi.getMargin();
        int middle = this.props.getMiddlePct();
        Label wlReadTimeout = new Label((Composite)gSettings, 131072);
        wlReadTimeout.setText(BaseMessages.getString(PKG, (String)"RestDialog.ReadTimeout.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlReadTimeout);
        FormData fdlReadTimeout = new FormData();
        fdlReadTimeout.top = new FormAttachment((Control)this.wConnectionTimeout, margin);
        fdlReadTimeout.left = new FormAttachment(0, 0);
        fdlReadTimeout.right = new FormAttachment(middle, -margin);
        wlReadTimeout.setLayoutData((Object)fdlReadTimeout);
        this.wReadTimeout = new TextVar(this.variables, (Composite)gSettings, 18436);
        this.wReadTimeout.addModifyListener(lsMod);
        this.wReadTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"RestDialog.ReadTimeout.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wReadTimeout);
        FormData fdReadTimeout = new FormData();
        fdReadTimeout.top = new FormAttachment((Control)this.wConnectionTimeout, margin);
        fdReadTimeout.left = new FormAttachment(middle, 0);
        fdReadTimeout.right = new FormAttachment(100, 0);
        this.wReadTimeout.setLayoutData((Object)fdReadTimeout);
    }

    private void setupProxyPortLine(ModifyListener lsMod, int middle, int margin, Group gProxy) {
        Label wlProxyPort = new Label((Composite)gProxy, 131072);
        wlProxyPort.setText(BaseMessages.getString(PKG, (String)"RestDialog.ProxyPort.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlProxyPort);
        FormData fdlProxyPort = new FormData();
        fdlProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        fdlProxyPort.left = new FormAttachment(0, 0);
        fdlProxyPort.right = new FormAttachment(middle, -margin);
        wlProxyPort.setLayoutData((Object)fdlProxyPort);
        this.wProxyPort = new TextVar(this.variables, (Composite)gProxy, 18436);
        this.wProxyPort.addModifyListener(lsMod);
        this.wProxyPort.setToolTipText(BaseMessages.getString(PKG, (String)"RestDialog.ProxyPort.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wProxyPort);
        FormData fdProxyPort = new FormData();
        fdProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        fdProxyPort.left = new FormAttachment(middle, 0);
        fdProxyPort.right = new FormAttachment(100, 0);
        this.wProxyPort.setLayoutData((Object)fdProxyPort);
    }

    private void setupProxyHostLine(ModifyListener lsMod, int middle, int margin, Group gProxy) {
        Label wlProxyHost = new Label((Composite)gProxy, 131072);
        wlProxyHost.setText(BaseMessages.getString(PKG, (String)"RestDialog.ProxyHost.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlProxyHost);
        FormData fdlProxyHost = new FormData();
        fdlProxyHost.top = new FormAttachment(0, margin);
        fdlProxyHost.left = new FormAttachment(0, 0);
        fdlProxyHost.right = new FormAttachment(middle, -margin);
        wlProxyHost.setLayoutData((Object)fdlProxyHost);
        this.wProxyHost = new TextVar(this.variables, (Composite)gProxy, 18436);
        this.wProxyHost.addModifyListener(lsMod);
        this.wProxyHost.setToolTipText(BaseMessages.getString(PKG, (String)"RestDialog.ProxyHost.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wProxyHost);
        FormData fdProxyHost = new FormData();
        fdProxyHost.top = new FormAttachment(0, margin);
        fdProxyHost.left = new FormAttachment(middle, 0);
        fdProxyHost.right = new FormAttachment(100, 0);
        this.wProxyHost.setLayoutData((Object)fdProxyHost);
    }

    private Group setupProxyGroup(Composite wAuthComp) {
        Group gProxy = new Group(wAuthComp, 16);
        gProxy.setText(BaseMessages.getString(PKG, (String)"RestDialog.ProxyGroup.Label", (String[])new String[0]));
        FormLayout proxyLayout = new FormLayout();
        proxyLayout.marginWidth = 3;
        proxyLayout.marginHeight = 3;
        gProxy.setLayout((Layout)proxyLayout);
        PropsUi.setLook((Widget)gProxy);
        return gProxy;
    }

    private void setupPreemptiveLine(int middle, int margin, Group gHttpAuth) {
        Label wlPreemptive = new Label((Composite)gHttpAuth, 131072);
        wlPreemptive.setText(BaseMessages.getString(PKG, (String)"RestDialog.Preemptive.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPreemptive);
        FormData fdlPreemptive = new FormData();
        fdlPreemptive.left = new FormAttachment(0, 0);
        fdlPreemptive.top = new FormAttachment((Control)this.wHttpPassword, margin);
        fdlPreemptive.right = new FormAttachment(middle, -margin);
        wlPreemptive.setLayoutData((Object)fdlPreemptive);
        this.wPreemptive = new Button((Composite)gHttpAuth, 32);
        PropsUi.setLook((Widget)this.wPreemptive);
        FormData fdPreemptive = new FormData();
        fdPreemptive.left = new FormAttachment(middle, 0);
        fdPreemptive.top = new FormAttachment((Control)wlPreemptive, 0, 0x1000000);
        fdPreemptive.right = new FormAttachment(100, 0);
        this.wPreemptive.setLayoutData((Object)fdPreemptive);
        this.wPreemptive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestDialog.this.input.setChanged();
            }
        });
    }

    private void setupPasswordLine(ModifyListener lsMod, int middle, int margin, Group gHttpAuth) {
        Label wlHttpPassword = new Label((Composite)gHttpAuth, 131072);
        wlHttpPassword.setText(BaseMessages.getString(PKG, (String)"RestDialog.HttpPassword.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlHttpPassword);
        FormData fdlHttpPassword = new FormData();
        fdlHttpPassword.top = new FormAttachment((Control)this.wHttpLogin, margin);
        fdlHttpPassword.left = new FormAttachment(0, 0);
        fdlHttpPassword.right = new FormAttachment(middle, -margin);
        wlHttpPassword.setLayoutData((Object)fdlHttpPassword);
        this.wHttpPassword = new PasswordTextVar(this.variables, (Composite)gHttpAuth, 18436);
        this.wHttpPassword.addModifyListener(lsMod);
        this.wHttpPassword.setToolTipText(BaseMessages.getString(PKG, (String)"RestDialog.HttpPassword.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wHttpPassword);
        FormData fdHttpPassword = new FormData();
        fdHttpPassword.top = new FormAttachment((Control)this.wHttpLogin, margin);
        fdHttpPassword.left = new FormAttachment(middle, 0);
        fdHttpPassword.right = new FormAttachment(100, 0);
        this.wHttpPassword.setLayoutData((Object)fdHttpPassword);
    }

    private void setupLoginLine(ModifyListener lsMod, int middle, int margin, Group gHttpAuth) {
        Label wlHttpLogin = new Label((Composite)gHttpAuth, 131072);
        wlHttpLogin.setText(BaseMessages.getString(PKG, (String)"RestDialog.HttpLogin.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlHttpLogin);
        FormData fdlHttpLogin = new FormData();
        fdlHttpLogin.top = new FormAttachment(0, margin);
        fdlHttpLogin.left = new FormAttachment(0, 0);
        fdlHttpLogin.right = new FormAttachment(middle, -margin);
        wlHttpLogin.setLayoutData((Object)fdlHttpLogin);
        this.wHttpLogin = new TextVar(this.variables, (Composite)gHttpAuth, 18436);
        this.wHttpLogin.addModifyListener(lsMod);
        this.wHttpLogin.setToolTipText(BaseMessages.getString(PKG, (String)"RestDialog.HttpLogin.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wHttpLogin);
        FormData fdHttpLogin = new FormData();
        fdHttpLogin.top = new FormAttachment(0, margin);
        fdHttpLogin.left = new FormAttachment(middle, 0);
        fdHttpLogin.right = new FormAttachment(100, 0);
        this.wHttpLogin.setLayoutData((Object)fdHttpLogin);
    }

    private Group setupAuthGroup(Composite wAuthComp) {
        Group gHttpAuth = new Group(wAuthComp, 16);
        gHttpAuth.setText(BaseMessages.getString(PKG, (String)"RestDialog.HttpAuthGroup.Label", (String[])new String[0]));
        FormLayout httpAuthLayout = new FormLayout();
        httpAuthLayout.marginWidth = 3;
        httpAuthLayout.marginHeight = 3;
        gHttpAuth.setLayout((Layout)httpAuthLayout);
        PropsUi.setLook((Widget)gHttpAuth);
        return gHttpAuth;
    }

    private void setupResponseHeaderLine(ModifyListener lsMod, int middle, int margin, Group gSettings, Group gOutputFields) {
        Label wlResponseHeader = new Label((Composite)gOutputFields, 131072);
        wlResponseHeader.setText(BaseMessages.getString(PKG, (String)"RestDialog.ResponseHeader.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResponseHeader);
        FormData fdlResponseHeader = new FormData();
        fdlResponseHeader.left = new FormAttachment(0, 0);
        fdlResponseHeader.right = new FormAttachment(middle, -margin);
        fdlResponseHeader.top = new FormAttachment((Control)this.wResponseTime, margin);
        wlResponseHeader.setLayoutData((Object)fdlResponseHeader);
        this.wResponseHeader = new TextVar(this.variables, (Composite)gOutputFields, 18436);
        PropsUi.setLook((Widget)this.wResponseHeader);
        this.wResponseHeader.addModifyListener(lsMod);
        FormData fdResponseHeader = new FormData();
        fdResponseHeader.left = new FormAttachment(middle, 0);
        fdResponseHeader.top = new FormAttachment((Control)this.wResponseTime, margin);
        fdResponseHeader.right = new FormAttachment(100, 0);
        this.wResponseHeader.setLayoutData((Object)fdResponseHeader);
        FormData fdOutputFields = new FormData();
        fdOutputFields.left = new FormAttachment(0, 0);
        fdOutputFields.right = new FormAttachment(100, 0);
        fdOutputFields.top = new FormAttachment((Control)gSettings, margin);
        gOutputFields.setLayoutData((Object)fdOutputFields);
    }

    private void setupResponseTimeLine(ModifyListener lsMod, int middle, int margin, Group gOutputFields) {
        Label wlResponseTime = new Label((Composite)gOutputFields, 131072);
        wlResponseTime.setText(BaseMessages.getString(PKG, (String)"RestDialog.ResponseTime.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResponseTime);
        FormData fdlResponseTime = new FormData();
        fdlResponseTime.left = new FormAttachment(0, 0);
        fdlResponseTime.right = new FormAttachment(middle, -margin);
        fdlResponseTime.top = new FormAttachment((Control)this.wResultCode, margin);
        wlResponseTime.setLayoutData((Object)fdlResponseTime);
        this.wResponseTime = new TextVar(this.variables, (Composite)gOutputFields, 18436);
        PropsUi.setLook((Widget)this.wResponseTime);
        this.wResponseTime.addModifyListener(lsMod);
        FormData fdResponseTime = new FormData();
        fdResponseTime.left = new FormAttachment(middle, 0);
        fdResponseTime.top = new FormAttachment((Control)this.wResultCode, margin);
        fdResponseTime.right = new FormAttachment(100, 0);
        this.wResponseTime.setLayoutData((Object)fdResponseTime);
    }

    private void setupStatusCodeLine(ModifyListener lsMod, int middle, int margin, Group gOutputFields) {
        Label wlResultCode = new Label((Composite)gOutputFields, 131072);
        wlResultCode.setText(BaseMessages.getString(PKG, (String)"RestDialog.ResultCode.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResultCode);
        FormData fdlResultCode = new FormData();
        fdlResultCode.left = new FormAttachment(0, 0);
        fdlResultCode.right = new FormAttachment(middle, -margin);
        fdlResultCode.top = new FormAttachment((Control)this.wResult, margin);
        wlResultCode.setLayoutData((Object)fdlResultCode);
        this.wResultCode = new TextVar(this.variables, (Composite)gOutputFields, 18436);
        PropsUi.setLook((Widget)this.wResultCode);
        this.wResultCode.addModifyListener(lsMod);
        FormData fdResultCode = new FormData();
        fdResultCode.left = new FormAttachment(middle, 0);
        fdResultCode.top = new FormAttachment((Control)this.wResult, margin);
        fdResultCode.right = new FormAttachment(100, -margin);
        this.wResultCode.setLayoutData((Object)fdResultCode);
    }

    private void setupResultLine(ModifyListener lsMod, int middle, int margin, Group gSettings, Group gOutputFields) {
        Label wlResult = new Label((Composite)gOutputFields, 131072);
        wlResult.setText(BaseMessages.getString(PKG, (String)"RestDialog.Result.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResult);
        FormData fdlResult = new FormData();
        fdlResult.left = new FormAttachment(0, 0);
        fdlResult.right = new FormAttachment(middle, -margin);
        fdlResult.top = new FormAttachment((Control)gSettings, margin);
        wlResult.setLayoutData((Object)fdlResult);
        this.wResult = new TextVar(this.variables, (Composite)gOutputFields, 18436);
        PropsUi.setLook((Widget)this.wResult);
        this.wResult.addModifyListener(lsMod);
        FormData fdResult = new FormData();
        fdResult.left = new FormAttachment(middle, 0);
        fdResult.top = new FormAttachment((Control)gSettings, margin * 2);
        fdResult.right = new FormAttachment(100, -margin);
        this.wResult.setLayoutData((Object)fdResult);
    }

    private Group setupOutputFieldGroup(Composite wGeneralComp) {
        Group gOutputFields = new Group(wGeneralComp, 16);
        gOutputFields.setText(BaseMessages.getString(PKG, (String)"RestDialog.OutputFieldsGroup.Label", (String[])new String[0]));
        FormLayout outputFieldsLayout = new FormLayout();
        outputFieldsLayout.marginWidth = 3;
        outputFieldsLayout.marginHeight = 3;
        gOutputFields.setLayout((Layout)outputFieldsLayout);
        PropsUi.setLook((Widget)gOutputFields);
        return gOutputFields;
    }

    private void setupAppTypeLine(ModifyListener lsMod, int middle, int margin, Group gSettings) {
        Label wlApplicationType = new Label((Composite)gSettings, 131072);
        wlApplicationType.setText(BaseMessages.getString(PKG, (String)"RestDialog.ApplicationType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlApplicationType);
        FormData fdlApplicationType = new FormData();
        fdlApplicationType.left = new FormAttachment(0, 0);
        fdlApplicationType.right = new FormAttachment(middle, -margin);
        fdlApplicationType.top = new FormAttachment((Control)this.wBody, 2 * margin);
        wlApplicationType.setLayoutData((Object)fdlApplicationType);
        this.wApplicationType = new ComboVar(this.variables, (Composite)gSettings, 2056);
        this.wApplicationType.setEditable(true);
        PropsUi.setLook((Widget)this.wApplicationType);
        this.wApplicationType.addModifyListener(lsMod);
        FormData fdApplicationType = new FormData();
        fdApplicationType.left = new FormAttachment(middle, 0);
        fdApplicationType.top = new FormAttachment((Control)this.wBody, 2 * margin);
        fdApplicationType.right = new FormAttachment(100, -margin);
        this.wApplicationType.setLayoutData((Object)fdApplicationType);
        this.wApplicationType.setItems(RestMeta.APPLICATION_TYPES);
        this.wApplicationType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestDialog.this.input.setChanged();
            }
        });
    }

    private void setupBodyLine(ModifyListener lsMod, int middle, int margin, Group gSettings) {
        this.wlBody = new Label((Composite)gSettings, 131072);
        this.wlBody.setText(BaseMessages.getString(PKG, (String)"RestDialog.Body.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlBody);
        FormData fdlBody = new FormData();
        fdlBody.left = new FormAttachment(0, 0);
        fdlBody.right = new FormAttachment(middle, -margin);
        fdlBody.top = new FormAttachment((Control)this.wMethodField, 2 * margin);
        this.wlBody.setLayoutData((Object)fdlBody);
        this.wBody = new ComboVar(this.variables, (Composite)gSettings, 2056);
        this.wBody.setEditable(true);
        PropsUi.setLook((Widget)this.wBody);
        this.wBody.addModifyListener(lsMod);
        FormData fdBody = new FormData();
        fdBody.left = new FormAttachment(middle, 0);
        fdBody.top = new FormAttachment((Control)this.wMethodField, 2 * margin);
        fdBody.right = new FormAttachment(100, -margin);
        this.wBody.setLayoutData((Object)fdBody);
    }

    private void setupMethodNameLine(ModifyListener lsMod, int middle, int margin, Group gSettings) {
        this.wlMethodField = new Label((Composite)gSettings, 131072);
        this.wlMethodField.setText(BaseMessages.getString(PKG, (String)"RestDialog.MethodField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlMethodField);
        FormData fdlMethodField = new FormData();
        fdlMethodField.left = new FormAttachment(0, 0);
        fdlMethodField.right = new FormAttachment(middle, -margin);
        fdlMethodField.top = new FormAttachment((Control)this.wMethodInField, margin);
        this.wlMethodField.setLayoutData((Object)fdlMethodField);
        this.wMethodField = new ComboVar(this.variables, (Composite)gSettings, 2056);
        this.wMethodField.setEditable(true);
        PropsUi.setLook((Widget)this.wMethodField);
        this.wMethodField.addModifyListener(lsMod);
        FormData fdMethodField = new FormData();
        fdMethodField.left = new FormAttachment(middle, 0);
        fdMethodField.top = new FormAttachment((Control)this.wMethodInField, margin);
        fdMethodField.right = new FormAttachment(100, -margin);
        this.wMethodField.setLayoutData((Object)fdMethodField);
    }

    private void setupMethodInFieldLine(int middle, int margin, Group gSettings) {
        Label wlMethodInField = new Label((Composite)gSettings, 131072);
        wlMethodInField.setText(BaseMessages.getString(PKG, (String)"RestDialog.MethodInField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMethodInField);
        FormData fdlMethodInField = new FormData();
        fdlMethodInField.left = new FormAttachment(0, 0);
        fdlMethodInField.top = new FormAttachment((Control)this.wMethod, margin);
        fdlMethodInField.right = new FormAttachment(middle, -margin);
        wlMethodInField.setLayoutData((Object)fdlMethodInField);
        this.wMethodInField = new Button((Composite)gSettings, 32);
        PropsUi.setLook((Widget)this.wMethodInField);
        FormData fdMethodInField = new FormData();
        fdMethodInField.left = new FormAttachment(middle, 0);
        fdMethodInField.top = new FormAttachment((Control)wlMethodInField, 0, 0x1000000);
        fdMethodInField.right = new FormAttachment(100, 0);
        this.wMethodInField.setLayoutData((Object)fdMethodInField);
        this.wMethodInField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestDialog.this.input.setChanged();
                RestDialog.this.activateMethodInfield();
            }
        });
    }

    private void setupHttpMethodLine(ModifyListener lsMod, int middle, int margin, Group gSettings) {
        this.wlMethod = new Label((Composite)gSettings, 131072);
        this.wlMethod.setText(BaseMessages.getString(PKG, (String)"RestDialog.Method.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlMethod);
        FormData fdlMethod = new FormData();
        fdlMethod.left = new FormAttachment(0, 0);
        fdlMethod.right = new FormAttachment(middle, -margin);
        fdlMethod.top = new FormAttachment((Control)this.wUrlField, 2 * margin);
        this.wlMethod.setLayoutData((Object)fdlMethod);
        this.wMethod = new ComboVar(this.variables, (Composite)gSettings, 2056);
        this.wMethod.setEditable(true);
        PropsUi.setLook((Widget)this.wMethod);
        this.wMethod.addModifyListener(lsMod);
        FormData fdMethod = new FormData();
        fdMethod.left = new FormAttachment(middle, 0);
        fdMethod.top = new FormAttachment((Control)this.wUrlField, 2 * margin);
        fdMethod.right = new FormAttachment(100, -margin);
        this.wMethod.setLayoutData((Object)fdMethod);
        this.wMethod.setItems(RestMeta.HTTP_METHODS);
        this.wMethod.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestDialog.this.setMethod();
            }
        });
    }

    private void setupUrlFieldNameLine(ModifyListener lsMod, int middle, int margin, Group gSettings) {
        this.wlUrlField = new Label((Composite)gSettings, 131072);
        this.wlUrlField.setText(BaseMessages.getString(PKG, (String)"RestDialog.UrlField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlUrlField);
        FormData fdlUrlField = new FormData();
        fdlUrlField.left = new FormAttachment(0, 0);
        fdlUrlField.right = new FormAttachment(middle, -margin);
        fdlUrlField.top = new FormAttachment((Control)this.wUrlInField, margin);
        this.wlUrlField.setLayoutData((Object)fdlUrlField);
        this.wUrlField = new ComboVar(this.variables, (Composite)gSettings, 2056);
        this.wUrlField.setEditable(true);
        PropsUi.setLook((Widget)this.wUrlField);
        this.wUrlField.addModifyListener(lsMod);
        FormData fdUrlField = new FormData();
        fdUrlField.left = new FormAttachment(middle, 0);
        fdUrlField.top = new FormAttachment((Control)this.wUrlInField, margin);
        fdUrlField.right = new FormAttachment(100, -margin);
        this.wUrlField.setLayoutData((Object)fdUrlField);
    }

    private void setupUrlInFieldLine(int middle, int margin, Group gSettings) {
        Label wlUrlInField = new Label((Composite)gSettings, 131072);
        wlUrlInField.setText(BaseMessages.getString(PKG, (String)"RestDialog.UrlInField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUrlInField);
        FormData fdlUrlInField = new FormData();
        fdlUrlInField.left = new FormAttachment(0, 0);
        fdlUrlInField.top = new FormAttachment((Control)this.wUrl, margin);
        fdlUrlInField.right = new FormAttachment(middle, -margin);
        wlUrlInField.setLayoutData((Object)fdlUrlInField);
        this.wUrlInField = new Button((Composite)gSettings, 32);
        PropsUi.setLook((Widget)this.wUrlInField);
        FormData fdUrlInField = new FormData();
        fdUrlInField.left = new FormAttachment(middle, 0);
        fdUrlInField.top = new FormAttachment((Control)wlUrlInField, 0, 0x1000000);
        fdUrlInField.right = new FormAttachment(100, 0);
        this.wUrlInField.setLayoutData((Object)fdUrlInField);
        this.wUrlInField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestDialog.this.input.setChanged();
                RestDialog.this.activateUrlInfield();
            }
        });
    }

    private void setupRestConnectionLine(ModifyListener lsMod, int middle, int margin, Composite wGeneralComp, Group gSettings) {
        this.wSelectionLine = new MetaSelectionLine(this.variables, this.metadataProvider, RestConnection.class, (Composite)gSettings, 18436, "REST Connection", "The name of the REST connection to use.");
        PropsUi.setLook((Widget)this.wSelectionLine);
        FormData fdSelectionLine = new FormData();
        fdSelectionLine.left = new FormAttachment(0, 0);
        fdSelectionLine.top = new FormAttachment((Control)wGeneralComp, margin);
        fdSelectionLine.right = new FormAttachment(100, -margin);
        this.wSelectionLine.setLayoutData((Object)fdSelectionLine);
        this.wSelectionLine.addListener(13, e -> this.input.setChanged(true));
        try {
            this.wSelectionLine.fillItems();
        }
        catch (Exception e2) {
            new ErrorDialog(this.shell, CONST_ERROR, "Error getting list of REST connections", e2);
        }
    }

    private void setupUrlLine(ModifyListener lsMod, int middle, int margin, Composite wGeneralComp, Group gSettings) {
        this.wlUrl = new Label((Composite)gSettings, 131072);
        this.wlUrl.setText(BaseMessages.getString(PKG, (String)"RestDialog.URL.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlUrl);
        FormData fdlUrl = new FormData();
        fdlUrl.left = new FormAttachment(0, 0);
        fdlUrl.right = new FormAttachment(middle, -margin);
        fdlUrl.top = new FormAttachment((Control)this.wSelectionLine, margin * 2);
        this.wlUrl.setLayoutData((Object)fdlUrl);
        this.wUrl = new TextVar(this.variables, (Composite)gSettings, 18436);
        PropsUi.setLook((Widget)this.wUrl);
        this.wUrl.addModifyListener(lsMod);
        FormData fdUrl = new FormData();
        fdUrl.left = new FormAttachment(middle, 0);
        fdUrl.top = new FormAttachment((Control)this.wSelectionLine, margin * 2);
        fdUrl.right = new FormAttachment(100, 0);
        this.wUrl.setLayoutData((Object)fdUrl);
    }

    private Group setupSettingGroup(Composite wGeneralComp) {
        Group gSettings = new Group(wGeneralComp, 16);
        gSettings.setText(BaseMessages.getString(PKG, (String)"RestDialog.SettingsGroup.Label", (String[])new String[0]));
        FormLayout settingsLayout = new FormLayout();
        settingsLayout.marginWidth = 3;
        settingsLayout.marginHeight = 3;
        gSettings.setLayout((Layout)settingsLayout);
        PropsUi.setLook((Widget)gSettings);
        return gSettings;
    }

    private void setupTransformName(ModifyListener lsMod, int middle, int margin) {
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"RestDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
    }

    private void setupButtons(int margin) {
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
    }

    protected void setMethod() {
        boolean activateBody = RestMeta.isActiveBody(this.wMethod.getText());
        boolean activateParams = RestMeta.isActiveParameters(this.wMethod.getText());
        this.wlBody.setEnabled(activateBody);
        this.wBody.setEnabled(activateBody);
        this.wApplicationType.setEnabled(activateBody);
        this.wlParameters.setEnabled(activateParams);
        this.wParameters.setEnabled(activateParams);
        this.wGet.setEnabled(activateParams);
        this.wlMatrixParameters.setEnabled(activateParams);
        this.wMatrixParameters.setEnabled(activateParams);
        this.wMatrixGet.setEnabled(activateParams);
    }

    protected void setComboBoxes() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TransformMeta transformMeta = RestDialog.this.pipelineMeta.findTransform(RestDialog.this.transformName);
                if (transformMeta != null) {
                    try {
                        IRowMeta rowMeta = RestDialog.this.pipelineMeta.getPrevTransformFields(RestDialog.this.variables, transformMeta);
                        for (int i = 0; i < rowMeta.size(); ++i) {
                            RestDialog.this.inputFields.add(rowMeta.getValueMeta(i).getName());
                        }
                        String[] fieldNames = Const.sortStrings((String[])rowMeta.getFieldNames());
                        RestDialog.this.colinfoparams[0].setComboValues(fieldNames);
                        RestDialog.this.colinf[0].setComboValues(fieldNames);
                        RestDialog.this.wUrlField.setItems(fieldNames);
                        RestDialog.this.wBody.setItems(fieldNames);
                        RestDialog.this.wMethodField.setItems(fieldNames);
                    }
                    catch (HopException e) {
                        RestDialog.this.log.logError(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0])});
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(runnable);
    }

    private void activateUrlInfield() {
        this.wlUrlField.setEnabled(this.wUrlInField.getSelection());
        this.wUrlField.setEnabled(this.wUrlInField.getSelection());
        this.wlUrl.setEnabled(!this.wUrlInField.getSelection());
        this.wUrl.setEnabled(!this.wUrlInField.getSelection());
    }

    public void getData() {
        TableItem item;
        int i;
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"RestDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (!Utils.isEmpty((CharSequence)this.input.getConnectionName())) {
            this.wSelectionLine.setText(this.input.getConnectionName());
        }
        if (!this.input.getHeaderFields().isEmpty()) {
            for (i = 0; i < this.input.getHeaderFields().size(); ++i) {
                item = this.wFields.table.getItem(i);
                if (this.input.getHeaderFields().get(i) != null) {
                    item.setText(1, this.input.getHeaderFields().get(i).getHeaderField());
                }
                if (this.input.getHeaderFields().get(i) == null) continue;
                item.setText(2, this.input.getHeaderFields().get(i).getName());
            }
        }
        if (!this.input.getParameterFields().isEmpty()) {
            for (i = 0; i < this.input.getParameterFields().size(); ++i) {
                item = this.wParameters.table.getItem(i);
                if (this.input.getParameterFields().get(i) != null) {
                    item.setText(1, this.input.getParameterFields().get(i).getHeaderField());
                }
                if (this.input.getParameterFields().get(i) == null) continue;
                item.setText(2, this.input.getParameterFields().get(i).getName());
            }
        }
        if (!this.input.getMatrixParameterFields().isEmpty()) {
            for (i = 0; i < this.input.getMatrixParameterFields().size(); ++i) {
                item = this.wMatrixParameters.table.getItem(i);
                if (this.input.getMatrixParameterFields().get(i) != null) {
                    item.setText(1, this.input.getMatrixParameterFields().get(i).getHeaderField());
                }
                if (this.input.getMatrixParameterFields().get(i) == null) continue;
                item.setText(2, this.input.getMatrixParameterFields().get(i).getName());
            }
        }
        this.wMethod.setText(Const.NVL((String)this.input.getMethod(), (String)"GET"));
        this.wMethodInField.setSelection(this.input.isDynamicMethod());
        if (this.input.getBodyField() != null) {
            this.wBody.setText(this.input.getBodyField());
        }
        if (this.input.getMethodFieldName() != null) {
            this.wMethodField.setText(this.input.getMethodFieldName());
        }
        if (this.input.getUrl() != null) {
            this.wUrl.setText(this.input.getUrl());
        }
        this.wUrlInField.setSelection(this.input.isUrlInField());
        if (this.input.getUrlField() != null) {
            this.wUrlField.setText(this.input.getUrlField());
        }
        if (this.input.getResultField().getFieldName() != null) {
            this.wResult.setText(this.input.getResultField().getFieldName());
        }
        if (this.input.getResultField().getCode() != null) {
            this.wResultCode.setText(this.input.getResultField().getCode());
        }
        if (this.input.getResultField().getResponseTime() != null) {
            this.wResponseTime.setText(this.input.getResultField().getResponseTime());
        }
        if (this.input.getConnectionTimeout() != null) {
            this.wConnectionTimeout.setText(this.input.getConnectionTimeout());
        }
        if (this.input.getReadTimeout() != null) {
            this.wReadTimeout.setText(this.input.getReadTimeout());
        }
        if (this.input.getHttpLogin() != null) {
            this.wHttpLogin.setText(this.input.getHttpLogin());
        }
        if (this.input.getHttpPassword() != null) {
            this.wHttpPassword.setText(this.input.getHttpPassword());
        }
        if (this.input.getProxyHost() != null) {
            this.wProxyHost.setText(this.input.getProxyHost());
        }
        if (this.input.getProxyPort() != null) {
            this.wProxyPort.setText(this.input.getProxyPort());
        }
        this.wPreemptive.setSelection(this.input.isPreemptive());
        if (this.input.getTrustStoreFile() != null) {
            this.wTrustStoreFile.setText(this.input.getTrustStoreFile());
        }
        if (this.input.getTrustStorePassword() != null) {
            this.wTrustStorePassword.setText(this.input.getTrustStorePassword());
        }
        this.wIgnoreSsl.setSelection(this.input.isIgnoreSsl());
        if (this.input.getResultField().getResponseHeader() != null) {
            this.wResponseHeader.setText(this.input.getResultField().getResponseHeader());
        }
        this.wApplicationType.setText(Const.NVL((String)this.input.getApplicationType(), (String)""));
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        TableItem item;
        int i;
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        if (!Utils.isEmpty((CharSequence)this.wSelectionLine.getText())) {
            this.input.setConnectionName(this.wSelectionLine.getText());
        }
        this.input.getHeaderFields().clear();
        this.input.getParameterFields().clear();
        this.input.getMatrixParameterFields().clear();
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"RestDialog.Log.FoundArguments", (String[])new String[]{String.valueOf(this.wFields.nrNonEmpty())}));
        }
        for (i = 0; i < this.wFields.nrNonEmpty(); ++i) {
            item = this.wFields.getNonEmpty(i);
            HeaderField headerField = new HeaderField();
            headerField.setHeaderField(item.getText(1));
            headerField.setName(item.getText(2));
            this.input.getHeaderFields().add(headerField);
        }
        for (i = 0; i < this.wParameters.nrNonEmpty(); ++i) {
            item = this.wParameters.getNonEmpty(i);
            ParameterField parameterField = new ParameterField();
            parameterField.setHeaderField(item.getText(1));
            parameterField.setName(item.getText(2));
            this.input.getParameterFields().add(parameterField);
        }
        for (i = 0; i < this.wMatrixParameters.nrNonEmpty(); ++i) {
            item = this.wMatrixParameters.getNonEmpty(i);
            MatrixParameterField matrixParameterField = new MatrixParameterField();
            matrixParameterField.setHeaderField(item.getText(1));
            matrixParameterField.setName(item.getText(2));
            this.input.getMatrixParameterFields().add(matrixParameterField);
        }
        this.input.setDynamicMethod(this.wMethodInField.getSelection());
        this.input.setMethodFieldName(this.wMethodField.getText());
        this.input.setMethod(this.wMethod.getText());
        this.input.setUrl(this.wUrl.getText());
        this.input.setUrlField(this.wUrlField.getText());
        this.input.setUrlInField(this.wUrlInField.getSelection());
        this.input.setBodyField(this.wBody.getText());
        this.input.getResultField().setFieldName(this.wResult.getText());
        this.input.getResultField().setCode(this.wResultCode.getText());
        this.input.getResultField().setResponseTime(this.wResponseTime.getText());
        this.input.getResultField().setResponseHeader(this.wResponseHeader.getText());
        this.input.setConnectionTimeout(this.wConnectionTimeout.getText());
        this.input.setReadTimeout(this.wReadTimeout.getText());
        this.input.setHttpLogin(this.wHttpLogin.getText());
        this.input.setHttpPassword(this.wHttpPassword.getText());
        this.input.setProxyHost(this.wProxyHost.getText());
        this.input.setProxyPort(this.wProxyPort.getText());
        this.input.setPreemptive(this.wPreemptive.getSelection());
        this.input.setTrustStoreFile(this.wTrustStoreFile.getText());
        this.input.setTrustStorePassword(this.wTrustStorePassword.getText());
        this.input.setIgnoreSsl(this.wIgnoreSsl.getSelection());
        this.input.setApplicationType(this.wApplicationType.getText());
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void getParametersFields(TableView tView) {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)tView, (int)1, (int[])new int[]{1, 2}, (int[])new int[]{3}, (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RestDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RestDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getHeaders() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[]{3}, (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RestDialog.FailedToGetHeaders.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RestDialog.FailedToGetHeaders.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void activateMethodInfield() {
        this.wlMethod.setEnabled(!this.wMethodInField.getSelection());
        this.wMethod.setEnabled(!this.wMethodInField.getSelection());
        this.wlMethodField.setEnabled(this.wMethodInField.getSelection());
        this.wMethodField.setEnabled(this.wMethodInField.getSelection());
    }
}

