/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.switchcase;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.switchcase.SwitchCaseMeta;
import org.apache.hop.pipeline.transforms.switchcase.SwitchCaseTarget;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SwitchCaseDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = SwitchCaseMeta.class;
    private CCombo wFieldName;
    private CCombo wDataType;
    private Text wConversionMask;
    private Text wDecimalSymbol;
    private Text wGroupingSymbol;
    private TableView wValues;
    private CCombo wDefaultTarget;
    private Button wContains;
    private final SwitchCaseMeta input;

    public SwitchCaseDialog(Shell parent, IVariables variables, SwitchCaseMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        SelectionAdapter lsSel = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SwitchCaseDialog.this.input.setChanged();
            }
        };
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, margin);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlFieldName = new Label((Composite)this.shell, 131072);
        wlFieldName.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.FieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFieldName);
        FormData fdlFieldName = new FormData();
        fdlFieldName.left = new FormAttachment(0, 0);
        fdlFieldName.right = new FormAttachment(middle, 0);
        fdlFieldName.top = new FormAttachment((Control)this.wTransformName, margin);
        wlFieldName.setLayoutData((Object)fdlFieldName);
        this.wFieldName = new CCombo((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wFieldName);
        FormData fdFieldName = new FormData();
        fdFieldName.left = new FormAttachment(middle, margin);
        fdFieldName.right = new FormAttachment(100, 0);
        fdFieldName.top = new FormAttachment((Control)this.wTransformName, margin);
        this.wFieldName.setLayoutData((Object)fdFieldName);
        this.wFieldName.addModifyListener(lsMod);
        try {
            IRowMeta inputFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
            this.wFieldName.setItems(inputFields.getFieldNames());
        }
        catch (HopTransformException ex) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SwitchCaseDialog.Exception.CantGetFieldsFromPreviousTransforms.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SwitchCaseDialog.Exception.CantGetFieldsFromPreviousTransforms.Message", (String[])new String[0]), (Exception)((Object)ex));
        }
        Label wlContains = new Label((Composite)this.shell, 131072);
        wlContains.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.Contains.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlContains);
        FormData fdlContains = new FormData();
        fdlContains.left = new FormAttachment(0, 0);
        fdlContains.right = new FormAttachment(middle, 0);
        fdlContains.top = new FormAttachment((Control)this.wFieldName, margin * 2);
        wlContains.setLayoutData((Object)fdlContains);
        this.wContains = new Button((Composite)this.shell, 32);
        this.wContains.setToolTipText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.Contains.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wContains);
        FormData fdContains = new FormData();
        fdContains.left = new FormAttachment(middle, margin);
        fdContains.top = new FormAttachment((Control)wlContains, 0, 0x1000000);
        fdContains.right = new FormAttachment(100, 0);
        this.wContains.setLayoutData((Object)fdContains);
        this.wContains.addSelectionListener((SelectionListener)lsSel);
        Label wlDataType = new Label((Composite)this.shell, 131072);
        wlDataType.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.DataType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDataType);
        FormData fdlDataType = new FormData();
        fdlDataType.left = new FormAttachment(0, 0);
        fdlDataType.right = new FormAttachment(middle, 0);
        fdlDataType.top = new FormAttachment((Control)this.wContains, margin);
        wlDataType.setLayoutData((Object)fdlDataType);
        this.wDataType = new CCombo((Composite)this.shell, 18436);
        this.wDataType.setItems(ValueMetaBase.getTypes());
        PropsUi.setLook((Widget)this.wDataType);
        FormData fdDataType = new FormData();
        fdDataType.left = new FormAttachment(middle, margin);
        fdDataType.right = new FormAttachment(100, 0);
        fdDataType.top = new FormAttachment((Control)this.wContains, margin);
        this.wDataType.setLayoutData((Object)fdDataType);
        this.wDataType.addModifyListener(lsMod);
        Label wlConversionMask = new Label((Composite)this.shell, 131072);
        wlConversionMask.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.ConversionMask.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlConversionMask);
        FormData fdlConversionMask = new FormData();
        fdlConversionMask.left = new FormAttachment(0, 0);
        fdlConversionMask.right = new FormAttachment(middle, 0);
        fdlConversionMask.top = new FormAttachment((Control)this.wDataType, margin);
        wlConversionMask.setLayoutData((Object)fdlConversionMask);
        this.wConversionMask = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wConversionMask);
        FormData fdConversionMask = new FormData();
        fdConversionMask.left = new FormAttachment(middle, margin);
        fdConversionMask.right = new FormAttachment(100, 0);
        fdConversionMask.top = new FormAttachment((Control)this.wDataType, margin);
        this.wConversionMask.setLayoutData((Object)fdConversionMask);
        this.wConversionMask.addModifyListener(lsMod);
        Label wlDecimalSymbol = new Label((Composite)this.shell, 131072);
        wlDecimalSymbol.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.DecimalSymbol.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDecimalSymbol);
        FormData fdlDecimalSymbol = new FormData();
        fdlDecimalSymbol.left = new FormAttachment(0, 0);
        fdlDecimalSymbol.right = new FormAttachment(middle, 0);
        fdlDecimalSymbol.top = new FormAttachment((Control)this.wConversionMask, margin);
        wlDecimalSymbol.setLayoutData((Object)fdlDecimalSymbol);
        this.wDecimalSymbol = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wDecimalSymbol);
        FormData fdDecimalSymbol = new FormData();
        fdDecimalSymbol.left = new FormAttachment(middle, margin);
        fdDecimalSymbol.right = new FormAttachment(100, 0);
        fdDecimalSymbol.top = new FormAttachment((Control)this.wConversionMask, margin);
        this.wDecimalSymbol.setLayoutData((Object)fdDecimalSymbol);
        this.wDecimalSymbol.addModifyListener(lsMod);
        Label wlGroupingSymbol = new Label((Composite)this.shell, 131072);
        wlGroupingSymbol.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.GroupingSymbol.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlGroupingSymbol);
        FormData fdlGroupingSymbol = new FormData();
        fdlGroupingSymbol.left = new FormAttachment(0, 0);
        fdlGroupingSymbol.right = new FormAttachment(middle, 0);
        fdlGroupingSymbol.top = new FormAttachment((Control)this.wDecimalSymbol, margin);
        wlGroupingSymbol.setLayoutData((Object)fdlGroupingSymbol);
        this.wGroupingSymbol = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wGroupingSymbol);
        FormData fdGroupingSymbol = new FormData();
        fdGroupingSymbol.left = new FormAttachment(middle, margin);
        fdGroupingSymbol.right = new FormAttachment(100, 0);
        fdGroupingSymbol.top = new FormAttachment((Control)this.wDecimalSymbol, margin);
        this.wGroupingSymbol.setLayoutData((Object)fdGroupingSymbol);
        this.wGroupingSymbol.addModifyListener(lsMod);
        String[] nextTransformNames = this.pipelineMeta.getNextTransformNames(this.transformMeta);
        Label wlValues = new Label((Composite)this.shell, 131072);
        wlValues.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.ValueCases.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlValues);
        FormData fdlValues = new FormData();
        fdlValues.left = new FormAttachment(0, 0);
        fdlValues.top = new FormAttachment((Control)this.wGroupingSymbol, margin);
        fdlValues.right = new FormAttachment(middle, 0);
        wlValues.setLayoutData((Object)fdlValues);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.ColumnInfo.Value", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.ColumnInfo.TargetTransform", (String[])new String[0]), 2, nextTransformNames, false)};
        this.wValues = new TableView(this.variables, (Composite)this.shell, 67586, colinf, this.input.getCaseTargets().size(), lsMod, this.props);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        Label wlDefaultTarget = new Label((Composite)this.shell, 131072);
        wlDefaultTarget.setText(BaseMessages.getString(PKG, (String)"SwitchCaseDialog.DefaultTarget.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDefaultTarget);
        FormData fdlDefaultTarget = new FormData();
        fdlDefaultTarget.left = new FormAttachment(0, 0);
        fdlDefaultTarget.right = new FormAttachment(middle, 0);
        fdlDefaultTarget.bottom = new FormAttachment((Control)this.wOk, -margin * 2);
        wlDefaultTarget.setLayoutData((Object)fdlDefaultTarget);
        this.wDefaultTarget = new CCombo((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wDefaultTarget);
        FormData fdDefaultTarget = new FormData();
        fdDefaultTarget.left = new FormAttachment(middle, margin);
        fdDefaultTarget.right = new FormAttachment(100, 0);
        fdDefaultTarget.bottom = new FormAttachment((Control)this.wOk, -margin * 2);
        this.wDefaultTarget.setLayoutData((Object)fdDefaultTarget);
        this.wDefaultTarget.setItems(nextTransformNames);
        this.wDefaultTarget.addModifyListener(lsMod);
        FormData fdValues = new FormData();
        fdValues.left = new FormAttachment(middle, margin);
        fdValues.top = new FormAttachment((Control)this.wGroupingSymbol, margin);
        fdValues.right = new FormAttachment(100, 0);
        fdValues.bottom = new FormAttachment((Control)this.wDefaultTarget, -margin);
        this.wValues.setLayoutData((Object)fdValues);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.getData();
        this.input.setChanged(this.backupChanged);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wFieldName.setText(Const.NVL((String)this.input.getFieldName(), (String)""));
        this.wContains.setSelection(this.input.isUsingContains());
        this.wDataType.setText(Const.NVL((String)this.input.getCaseValueType(), (String)""));
        this.wDecimalSymbol.setText(Const.NVL((String)this.input.getCaseValueDecimal(), (String)""));
        this.wGroupingSymbol.setText(Const.NVL((String)this.input.getCaseValueGroup(), (String)""));
        this.wConversionMask.setText(Const.NVL((String)this.input.getCaseValueFormat(), (String)""));
        for (int i = 0; i < this.input.getCaseTargets().size(); ++i) {
            TableItem item = this.wValues.table.getItem(i);
            SwitchCaseTarget target = this.input.getCaseTargets().get(i);
            if (target == null) continue;
            item.setText(1, Const.NVL((String)target.getCaseValue(), (String)""));
            item.setText(2, Const.NVL((String)target.getCaseTargetTransformName(), (String)""));
        }
        this.wValues.removeEmptyRows();
        this.wValues.setRowNums();
        this.wValues.optWidth(true);
        this.wDefaultTarget.setText(Const.NVL((String)this.input.getDefaultTargetTransformName(), (String)""));
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setFieldName(this.wFieldName.getText());
        this.input.setUsingContains(this.wContains.getSelection());
        this.input.setCaseValueType(this.wDataType.getText());
        this.input.setCaseValueFormat(this.wConversionMask.getText());
        this.input.setCaseValueDecimal(this.wDecimalSymbol.getText());
        this.input.setCaseValueGroup(this.wGroupingSymbol.getText());
        int nrValues = this.wValues.nrNonEmpty();
        this.input.getCaseTargets().clear();
        for (int i = 0; i < nrValues; ++i) {
            TableItem item = this.wValues.getNonEmpty(i);
            SwitchCaseTarget target = new SwitchCaseTarget();
            target.setCaseValue(item.getText(1));
            target.setCaseTargetTransformName(item.getText(2));
            this.input.getCaseTargets().add(target);
        }
        this.input.setDefaultTargetTransformName(this.wDefaultTarget.getText());
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }
}

