/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.metrics.DefaultCounter;
import org.apache.iceberg.metrics.Histogram;
import org.apache.iceberg.metrics.Timer;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public interface MetricsContext
extends Serializable {
    default public void initialize(Map<String, String> properties) {
    }

    @Deprecated
    default public <T extends Number> Counter<T> counter(String name, Class<T> type, Unit unit) {
        throw new UnsupportedOperationException("Counter is not supported.");
    }

    default public org.apache.iceberg.metrics.Counter counter(String name, Unit unit) {
        throw new UnsupportedOperationException("Counter is not supported.");
    }

    default public org.apache.iceberg.metrics.Counter counter(String name) {
        return this.counter(name, Unit.COUNT);
    }

    default public Timer timer(String name, TimeUnit unit) {
        throw new UnsupportedOperationException("Timer is not supported.");
    }

    default public Histogram histogram(String name) {
        throw new UnsupportedOperationException("Histogram is not supported.");
    }

    public static MetricsContext nullMetrics() {
        return new MetricsContext(){

            @Override
            public Timer timer(String name, TimeUnit unit) {
                return Timer.NOOP;
            }

            @Override
            public <T extends Number> Counter<T> counter(String name, Class<T> type, Unit unit) {
                if (Integer.class.equals(type)) {
                    return ((DefaultCounter)DefaultCounter.NOOP).asIntCounter();
                }
                if (Long.class.equals(type)) {
                    return ((DefaultCounter)DefaultCounter.NOOP).asLongCounter();
                }
                throw new IllegalArgumentException(String.format("Counter for type %s is not supported", type.getName()));
            }

            @Override
            public org.apache.iceberg.metrics.Counter counter(String name, Unit unit) {
                return DefaultCounter.NOOP;
            }
        };
    }

    @Deprecated
    public static interface Counter<T extends Number> {
        public void increment();

        public void increment(T var1);

        @Deprecated
        default public Optional<T> count() {
            return Optional.empty();
        }

        default public T value() {
            throw new UnsupportedOperationException("Count is not supported.");
        }

        default public Unit unit() {
            return Unit.UNDEFINED;
        }
    }

    public static enum Unit {
        UNDEFINED("undefined"),
        BYTES("bytes"),
        COUNT("count");

        private final String displayName;

        private Unit(String displayName) {
            this.displayName = displayName;
        }

        public String displayName() {
            return this.displayName;
        }

        public static Unit fromDisplayName(String displayName) {
            Preconditions.checkArgument(null != displayName, "Invalid unit: null");
            try {
                return Unit.valueOf(displayName.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid unit: %s", displayName), e);
            }
        }
    }
}

