/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.read;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.io.parquet.FilterPredicateLeafBuilder;
import org.apache.hadoop.hive.ql.io.parquet.LeafFilterFactory;
import org.apache.hadoop.hive.ql.io.sarg.ExpressionTree;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetFilterPredicateConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetFilterPredicateConverter.class);

    public static FilterPredicate toFilterPredicate(SearchArgument sarg, MessageType schema, Map<String, TypeInfo> columnTypes) {
        HashMap<String, TypeInfo> columns = null;
        if (schema != null) {
            columns = new HashMap<String, TypeInfo>();
            for (Type field : schema.getFields()) {
                String columnName = field.getName();
                columns.put(columnName, columnTypes.get(columnName));
            }
        }
        try {
            return ParquetFilterPredicateConverter.translate(sarg.getExpression(), sarg.getLeaves(), columns, schema);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static FilterPredicate translate(ExpressionTree root, List<PredicateLeaf> leaves, Map<String, TypeInfo> columns, MessageType schema) throws Exception {
        FilterPredicate p = null;
        switch (root.getOperator()) {
            case OR: {
                for (ExpressionTree child : root.getChildren()) {
                    FilterPredicate childPredicate = ParquetFilterPredicateConverter.translate(child, leaves, columns, schema);
                    if (childPredicate == null) {
                        return null;
                    }
                    if (p == null) {
                        p = childPredicate;
                        continue;
                    }
                    p = FilterApi.or((FilterPredicate)p, (FilterPredicate)childPredicate);
                }
                return p;
            }
            case AND: {
                for (ExpressionTree child : root.getChildren()) {
                    if (p == null) {
                        p = ParquetFilterPredicateConverter.translate(child, leaves, columns, schema);
                        continue;
                    }
                    FilterPredicate right = ParquetFilterPredicateConverter.translate(child, leaves, columns, schema);
                    if (right == null) continue;
                    p = FilterApi.and((FilterPredicate)p, (FilterPredicate)right);
                }
                return p;
            }
            case NOT: {
                FilterPredicate op = ParquetFilterPredicateConverter.translate((ExpressionTree)root.getChildren().get(0), leaves, columns, schema);
                if (op != null) {
                    return FilterApi.not((FilterPredicate)op);
                }
                return null;
            }
            case LEAF: {
                PredicateLeaf leaf = leaves.get(root.getLeaf());
                if (columns.containsKey(leaf.getColumnName())) {
                    Type parquetType = schema.getType(leaf.getColumnName());
                    TypeInfo hiveType = columns.get(leaf.getColumnName());
                    return ParquetFilterPredicateConverter.buildFilterPredicateFromPredicateLeaf(leaf, parquetType, hiveType);
                }
                return null;
            }
            case CONSTANT: {
                return null;
            }
        }
        throw new IllegalStateException("Unknown operator: " + String.valueOf(root.getOperator()));
    }

    private static FilterPredicate buildFilterPredicateFromPredicateLeaf(PredicateLeaf leaf, Type parquetType, TypeInfo columnType) throws Exception {
        LeafFilterFactory leafFilterFactory = new LeafFilterFactory();
        try {
            FilterPredicateLeafBuilder builder = leafFilterFactory.getLeafFilterBuilderByType(leaf.getType(), parquetType);
            if (ParquetFilterPredicateConverter.isMultiLiteralsOperator(leaf.getOperator())) {
                return builder.buildPredicate(leaf.getOperator(), leaf.getLiteralList(), leaf.getColumnName(), columnType);
            }
            return builder.buildPredict(leaf.getOperator(), leaf.getLiteral(), leaf.getColumnName(), columnType);
        }
        catch (Exception e) {
            LOG.error("fail to build predicate filter leaf with errors" + String.valueOf(e), (Throwable)e);
            throw e;
        }
    }

    private static boolean isMultiLiteralsOperator(PredicateLeaf.Operator op) {
        return op == PredicateLeaf.Operator.IN || op == PredicateLeaf.Operator.BETWEEN;
    }
}

