/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.tracing;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CompleteableCommand;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.tracing.DefaultLettuceObservationConvention;
import io.lettuce.core.tracing.LettuceObservationContext;
import io.lettuce.core.tracing.LettuceObservationConvention;
import io.lettuce.core.tracing.RedisObservation;
import io.lettuce.core.tracing.SocketAddressEndpoint;
import io.lettuce.core.tracing.TraceContext;
import io.lettuce.core.tracing.TraceContextProvider;
import io.lettuce.core.tracing.Tracer;
import io.lettuce.core.tracing.TracerProvider;
import io.lettuce.core.tracing.Tracing;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public class MicrometerTracing
implements Tracing {
    private final ObservationRegistry observationRegistry;
    private final String serviceName;
    private final boolean includeCommandArgsInSpanTags;
    private final LettuceObservationConvention observationConvention;
    private final MicrometerTracer tracer;
    private final MicrometerTraceContextProvider contextProvider;

    public MicrometerTracing(ObservationRegistry observationRegistry, String serviceName) {
        this(observationRegistry, serviceName, false);
    }

    public MicrometerTracing(ObservationRegistry observationRegistry, String serviceName, boolean includeCommandArgsInSpanTags) {
        this(observationRegistry, serviceName, new DefaultLettuceObservationConvention(includeCommandArgsInSpanTags));
    }

    public MicrometerTracing(ObservationRegistry observationRegistry, String serviceName, LettuceObservationConvention convention) {
        LettuceAssert.notNull((Object)observationRegistry, "ObservationRegistry must not be null");
        LettuceAssert.notEmpty((CharSequence)serviceName, "Service name must not be empty");
        LettuceAssert.notNull((Object)convention, "LettuceObservationConvention must not be null");
        this.observationRegistry = observationRegistry;
        this.serviceName = serviceName;
        this.observationConvention = convention;
        this.includeCommandArgsInSpanTags = convention.includeCommandArgsInSpanTags();
        this.tracer = new MicrometerTracer(observationRegistry);
        this.contextProvider = new MicrometerTraceContextProvider(observationRegistry);
    }

    @Override
    public TracerProvider getTracerProvider() {
        return () -> this.tracer;
    }

    @Override
    public TraceContextProvider initialTraceContextProvider() {
        return this.contextProvider;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean includeCommandArgsInSpanTags() {
        return this.includeCommandArgsInSpanTags;
    }

    @Override
    public Tracing.Endpoint createEndpoint(SocketAddress socketAddress) {
        return new SocketAddressEndpoint(socketAddress);
    }

    static class MicrometerTraceContext
    implements TraceContext {
        private final Observation observation;

        public MicrometerTraceContext(Observation observation) {
            this.observation = observation;
        }

        public Observation getObservation() {
            return this.observation;
        }
    }

    static final class MicrometerTraceContextProvider
    implements TraceContextProvider {
        private final ObservationRegistry registry;

        MicrometerTraceContextProvider(ObservationRegistry registry) {
            this.registry = registry;
        }

        @Override
        public TraceContext getTraceContext() {
            Observation observation = this.registry.getCurrentObservation();
            if (observation == null) {
                return null;
            }
            return new MicrometerTraceContext(observation);
        }

        @Override
        public Mono<TraceContext> getTraceContextLater() {
            return Mono.deferContextual(Mono::justOrEmpty).filter(it -> it.hasKey(TraceContext.class) || it.hasKey(Observation.class) || it.hasKey((Object)"micrometer.observation")).map(it -> {
                if (it.hasKey(Observation.class)) {
                    return new MicrometerTraceContext((Observation)it.get(Observation.class));
                }
                if (it.hasKey(TraceContext.class)) {
                    return (TraceContext)it.get(TraceContext.class);
                }
                return new MicrometerTraceContext((Observation)it.get((Object)"micrometer.observation"));
            });
        }

        public ObservationRegistry getRegistry() {
            return this.registry;
        }
    }

    static class MicrometerSpan
    extends Tracer.Span {
        private final LettuceObservationContext context;
        private final Function<LettuceObservationContext, Observation> observationFactory;
        private Map<String, String> highCardinalityKeyValue;
        private Observation observation;

        public MicrometerSpan(String serviceName, Function<LettuceObservationContext, Observation> observationFactory) {
            this.context = new LettuceObservationContext(serviceName);
            this.observationFactory = observationFactory;
        }

        @Override
        public Tracer.Span start(RedisCommand<?, ?, ?> command) {
            this.context.setCommand(command);
            this.observation = this.observationFactory.apply(this.context);
            if (this.highCardinalityKeyValue != null) {
                this.highCardinalityKeyValue.forEach((arg_0, arg_1) -> ((Observation)this.observation).highCardinalityKeyValue(arg_0, arg_1));
            }
            if (!(command instanceof CompleteableCommand)) {
                throw new IllegalArgumentException("Command " + command + " must implement CompleteableCommand to attach Span completion to command completion");
            }
            CompleteableCommand completeableCommand = (CompleteableCommand)((Object)command);
            completeableCommand.onComplete((o, throwable) -> {
                if (command.getOutput() != null) {
                    String error = command.getOutput().getError();
                    if (error != null) {
                        this.observation.highCardinalityKeyValue(RedisObservation.HighCardinalityCommandKeyNames.ERROR.withValue(error));
                    } else if (throwable != null) {
                        this.error((Throwable)throwable);
                    }
                }
                this.finish();
            });
            this.observation.start();
            return this;
        }

        @Override
        public Tracer.Span name(String name) {
            return this;
        }

        @Override
        public Tracer.Span annotate(String annotation) {
            return this;
        }

        @Override
        public Tracer.Span tag(String key, String value) {
            if (this.highCardinalityKeyValue == null) {
                this.highCardinalityKeyValue = new HashMap<String, String>();
            }
            this.highCardinalityKeyValue.put(key, value);
            return this;
        }

        @Override
        public Tracer.Span error(Throwable throwable) {
            this.observation.error(throwable);
            return this;
        }

        @Override
        public Tracer.Span remoteEndpoint(Tracing.Endpoint endpoint) {
            this.context.setEndpoint(endpoint);
            return this;
        }

        @Override
        public void finish() {
            this.observation.stop();
        }
    }

    class MicrometerTracer
    extends Tracer {
        private final ObservationRegistry observationRegistry;

        public MicrometerTracer(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
        }

        @Override
        public Tracer.Span nextSpan() {
            return new MicrometerSpan(MicrometerTracing.this.serviceName, this::createObservation);
        }

        @Override
        public Tracer.Span nextSpan(TraceContext traceContext) {
            if (traceContext instanceof MicrometerTraceContext) {
                MicrometerTraceContext micrometerTraceContext = (MicrometerTraceContext)traceContext;
                if (micrometerTraceContext.getObservation() == null) {
                    return this.nextSpan();
                }
                return new MicrometerSpan(MicrometerTracing.this.serviceName, context -> this.createObservation((LettuceObservationContext)((Object)context)).parentObservation(micrometerTraceContext.getObservation()));
            }
            return this.nextSpan();
        }

        private Observation createObservation(LettuceObservationContext context) {
            return RedisObservation.REDIS_COMMAND_OBSERVATION.observation(this.observationRegistry, () -> context).observationConvention((ObservationConvention)MicrometerTracing.this.observationConvention);
        }
    }
}

