/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.constants;

public enum ThemeEnum {
    COMPACT("compact"),
    DEFAULT("default"),
    LIGHT("light"),
    DARK("dark");

    private final String value;

    public static String convert(String theme) {
        if (theme == null || theme.isEmpty() || COMPACT.getValue().equals(theme) || DEFAULT.getValue().equals(theme)) {
            return LIGHT.getValue();
        }
        return theme;
    }

    public String getValue() {
        return this.value;
    }

    private ThemeEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return "ThemeEnum." + this.name() + "(value=" + this.getValue() + ")";
    }
}

