/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.osgi;

import com.xugu.cloudjdbc.Driver;
import com.xugu.common.ReplaceEnum;
import com.xugu.osgi.DBDataSourceFactory;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;

public class DBBundleActivator
implements BundleActivator {
    private ServiceRegistration registration;

    public void start(BundleContext context) throws Exception {
        if (!Driver.isRegistered()) {
            Driver.register();
        }
        if (DBBundleActivator.dataSourceFactoryExists()) {
            this.registerDataSourceFactory(context);
        }
    }

    private static boolean dataSourceFactoryExists() {
        try {
            Class.forName("org.osgi.service.jdbc.DataSourceFactory");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private void registerDataSourceFactory(BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("osgi.jdbc.driver.class", ReplaceEnum.driverClassName.getReplaceStr());
        ((Dictionary)properties).put("osgi.jdbc.driver.name", ReplaceEnum.driverName.getReplaceStr());
        ((Dictionary)properties).put("osgi.jdbc.driver.version", ReplaceEnum.driverVersion.getReplaceStr());
        this.registration = context.registerService(DataSourceFactory.class, (Object)new DBDataSourceFactory(), properties);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        if (Driver.isRegistered()) {
            Driver.deregister();
        }
    }
}

