/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.xa.XAExceptionImp;
import java.sql.BatchUpdateException;
import java.sql.ClientInfoStatus;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.HashMap;
import javax.transaction.xa.XAException;

public class Error {
    static HashMap<Integer, Integer> xaErrorCodeMapping = new HashMap();

    public static SQLException createSQLException(String reason) {
        return new SQLException(reason);
    }

    public static SQLException createSQLException(String reason, String sqlState) {
        if (sqlState == null) {
            return new SQLException(reason);
        }
        return new SQLException(reason, sqlState);
    }

    public static SQLException createSQLException(String reason, String sqlState, int vendorCode) {
        if (vendorCode == -1) {
            if (sqlState == null) {
                return new SQLException(reason);
            }
            return new SQLException(reason, sqlState);
        }
        return new SQLException(reason, sqlState, vendorCode);
    }

    public static SQLException createSQLException(String reason, String sqlState, int vendorCode, String errType) {
        if (vendorCode == -1) {
            if (sqlState == null) {
                return new SQLException(reason);
            }
            return new SQLException(reason, sqlState);
        }
        if (errType == null) {
            return new SQLException(reason, sqlState, vendorCode);
        }
        return new SQLException(reason, sqlState, vendorCode, new Throwable(errType));
    }

    public static SQLClientInfoException createClientInfoException(String clientName, String val, ClientInfoStatus status) {
        String reason = "\u4e0d\u652f\u6301\u7684\u5ba2\u6237\u7aef\u5c5e\u6027\u6216\u5c5e\u6027\u503c";
        HashMap<String, ClientInfoStatus> clientException = new HashMap<String, ClientInfoStatus>();
        clientException.put(clientName + " " + val, status);
        return new SQLClientInfoException(reason, null, 50019, clientException);
    }

    public static SQLClientInfoException createClientInfoException(String errorReason, int errorCode) {
        HashMap<String, ClientInfoStatus> clientException = new HashMap<String, ClientInfoStatus>();
        return new SQLClientInfoException(errorReason, null, errorCode, clientException);
    }

    public static BatchUpdateException createBatchUpdateException(int[] updateCounts) {
        return new BatchUpdateException(updateCounts);
    }

    public static BatchUpdateException createBatchUpdateException(String reason, int[] updateCounts) {
        return new BatchUpdateException(reason, updateCounts);
    }

    public static BatchUpdateException createBatchUpdateException(String reason, String sqlState, int[] updateCounts) {
        if (sqlState == null) {
            return new BatchUpdateException(reason, updateCounts);
        }
        return new BatchUpdateException(reason, sqlState, updateCounts);
    }

    public static BatchUpdateException createBatchUpdateException(String reason, String sqlState, int vendorCode, int[] updateCounts) {
        if (vendorCode == -1) {
            if (sqlState == null) {
                return new BatchUpdateException(reason, updateCounts);
            }
            return new BatchUpdateException(reason, sqlState, updateCounts);
        }
        return new BatchUpdateException(reason, sqlState, vendorCode, updateCounts);
    }

    public static InterruptedException createInterruptedException(String reason) {
        return new InterruptedException(reason);
    }

    public static SQLClientInfoException createSQLClientInfoException(String reason, int vendorCode, String clientKey) {
        HashMap<String, ClientInfoStatus> errMap = new HashMap<String, ClientInfoStatus>(1);
        errMap.put(clientKey, ClientInfoStatus.REASON_VALUE_INVALID);
        return new SQLClientInfoException(reason, null, vendorCode, errMap);
    }

    public static XAException createXAException(String reason, int vendorCode) {
        Integer xaCode = xaErrorCodeMapping.get(vendorCode);
        if (xaCode == null) {
            xaCode = -7;
        }
        return new XAExceptionImp(xaCode, reason);
    }

    public static XAException createXAException(String reason) {
        Integer xaCode = -7;
        return new XAExceptionImp(xaCode, reason);
    }

    public static XAException createXAExceptionFromSQLException(SQLException sqlException) {
        Integer xaCode = xaErrorCodeMapping.get(sqlException.getErrorCode());
        if (xaCode == null) {
            xaCode = -7;
        }
        return new XAExceptionImp(xaCode, sqlException.getMessage());
    }

    static {
        xaErrorCodeMapping.put(53001, -4);
        xaErrorCodeMapping.put(53003, -5);
        xaErrorCodeMapping.put(1399, -7);
        xaErrorCodeMapping.put(1400, -9);
        xaErrorCodeMapping.put(1401, -3);
        xaErrorCodeMapping.put(1402, 100);
        xaErrorCodeMapping.put(1440, -8);
    }
}

