/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataConverter;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.SerializedObjectConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;

public class LobMetadata
extends MetadataConverter {
    public LobMetadata() {
        super("<lob>");
    }

    public LobMetadata(MetadataAnnotation lob, MetadataAccessor accessor) {
        super(lob, accessor);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        return super.equals(objectToCompare) && objectToCompare instanceof LobMetadata;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static boolean isValidBlobType(MetadataClass cls) {
        return cls.isClass(byte[].class) || cls.isClass(Byte[].class) || cls.isClass(Blob.class);
    }

    public static boolean isValidClobType(MetadataClass cls) {
        return cls.isClass(char[].class) || cls.isClass(String.class) || cls.isClass(Character[].class) || cls.isClass(Clob.class);
    }

    public static boolean isValidLobType(MetadataClass cls) {
        return LobMetadata.isValidClobType(cls) || LobMetadata.isValidBlobType(cls);
    }

    @Override
    public void process(DatabaseMapping mapping, MappingAccessor accessor, MetadataClass referenceClass, boolean isForMapKey) {
        if (LobMetadata.isValidClobType(referenceClass)) {
            this.setFieldClassification(mapping, Clob.class, isForMapKey);
            this.setConverter(mapping, (Converter)new TypeConversionConverter(mapping), isForMapKey);
        } else if (LobMetadata.isValidBlobType(referenceClass)) {
            this.setFieldClassification(mapping, Blob.class, isForMapKey);
            this.setConverter(mapping, (Converter)new TypeConversionConverter(mapping), isForMapKey);
        } else if (referenceClass.extendsInterface(Serializable.class)) {
            this.setFieldClassification(mapping, Blob.class, isForMapKey);
            this.setConverter(mapping, (Converter)new SerializedObjectConverter(mapping), isForMapKey);
        } else {
            throw ValidationException.invalidTypeForLOBAttribute((String)mapping.getAttributeName(), (Object)referenceClass, (Object)accessor.getJavaClass());
        }
    }
}

