/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.impl;

import com.huaweicloud.sdk.core.HttpListener;
import com.huaweicloud.sdk.core.exchange.ApiTimer;
import com.huaweicloud.sdk.core.exchange.SdkExchange;
import com.huaweicloud.sdk.core.exchange.SdkExchangeCache;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.core.impl.DefaultHttpUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;

public class DefaultHttpListener
implements Interceptor {
    private List<HttpListener> httpListeners;

    public DefaultHttpListener(HttpConfig httpConfig) {
        this.httpListeners = httpConfig.getHttpListeners();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        SdkExchange exchange = SdkExchangeCache.getExchange(request.header("SDK_EXCHANGE"));
        exchange = Objects.isNull(exchange) ? new SdkExchange() : exchange;
        request = request.newBuilder().removeHeader("SDK_EXCHANGE").build();
        exchange.withApiTimer(ApiTimer::start);
        if (Objects.nonNull(this.httpListeners)) {
            this.preRequest(request, exchange);
        }
        Response response = chain.proceed(request.newBuilder().removeHeader("SDK_EXCHANGE").build());
        exchange.withApiTimer(ApiTimer::end);
        if (Objects.nonNull(this.httpListeners)) {
            return this.postResponse(response, exchange);
        }
        return response;
    }

    public void preRequest(final Request request, final SdkExchange sdkExchange) throws IOException {
        String reqBody;
        if (Objects.nonNull(request.body()) && Objects.nonNull(request.body().contentType()) && (request.body().contentType().toString().startsWith("application/json") || request.body().contentType().toString().startsWith("text"))) {
            Buffer buffer = new Buffer();
            request.body().writeTo((BufferedSink)buffer);
            reqBody = buffer.readUtf8();
        } else {
            reqBody = Objects.nonNull(request.body()) && Objects.nonNull(request.body().contentType()) && request.body().contentType().toString().equals("application/octet-stream") ? (request.body().contentLength() > 0L || request.body().contentLength() == -1L ? "******" : null) : null;
        }
        final String finalReqBody = reqBody;
        HttpListener.RequestListener requestListener = new HttpListener.RequestListener(){

            @Override
            public String httpMethod() {
                return request.method();
            }

            @Override
            public String uri() {
                return request.url().toString();
            }

            @Override
            public Map<String, List<String>> headers() {
                return DefaultHttpUtils.headersToMap(request.headers());
            }

            @Override
            public Optional<String> body() {
                return Objects.isNull(finalReqBody) ? Optional.empty() : Optional.of(finalReqBody);
            }

            @Override
            public SdkExchange exchange() {
                return sdkExchange;
            }
        };
        this.httpListeners.forEach(httpListener -> httpListener.preRequest(requestListener));
    }

    public Response postResponse(final Response response, final SdkExchange sdkExchange) throws IOException {
        String respBody;
        final Request request = response.request();
        Response.Builder responseBuilder = response.newBuilder();
        if (Objects.nonNull(response.body()) && Objects.nonNull(response.body().contentType()) && (response.body().contentType().toString().startsWith("application/json") || response.body().contentType().toString().startsWith("text"))) {
            respBody = response.body().string();
            responseBuilder.body(ResponseBody.create((MediaType)response.body().contentType(), (String)respBody));
        } else {
            respBody = Objects.nonNull(response.body()) && Objects.nonNull(response.body().contentType()) && response.body().contentType().toString().equals("application/octet-stream") ? (response.body().contentLength() > 0L || response.body().contentLength() == -1L ? "******" : null) : null;
        }
        final String finalRespBody = respBody;
        HttpListener.ResponseListener responseListener = new HttpListener.ResponseListener(){

            @Override
            public String httpMethod() {
                return request.method();
            }

            @Override
            public String uri() {
                return request.url().toString();
            }

            @Override
            public Map<String, List<String>> headers() {
                return DefaultHttpUtils.headersToMap(response.headers());
            }

            @Override
            public Optional<String> body() {
                return Objects.isNull(finalRespBody) ? Optional.empty() : Optional.of(finalRespBody);
            }

            @Override
            public int statusCode() {
                return response.code();
            }

            @Override
            public SdkExchange exchange() {
                return sdkExchange;
            }
        };
        this.httpListeners.forEach(httpListener -> httpListener.postResponse(responseListener));
        return responseBuilder.build();
    }
}

