/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.constraint;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.api.rebalancer.constraint.AbstractRebalanceSoftConstraint;
import org.apache.helix.api.rebalancer.constraint.dataprovider.CapacityProvider;
import org.apache.helix.api.rebalancer.constraint.dataprovider.PartitionWeightProvider;
import org.apache.helix.controller.common.ResourcesStateMap;
import org.apache.helix.controller.rebalancer.util.ResourceUsageCalculator;

public class PartitionWeightAwareEvennessConstraint
extends AbstractRebalanceSoftConstraint {
    private final PartitionWeightProvider _partitionWeightProvider;
    private final CapacityProvider _capacityProvider;
    private final Map<String, Integer> _pendingUsage;

    public PartitionWeightAwareEvennessConstraint(PartitionWeightProvider partitionWeightProvider, CapacityProvider capacityProvider) {
        this._partitionWeightProvider = partitionWeightProvider;
        this._capacityProvider = capacityProvider;
        this._pendingUsage = new HashMap<String, Integer>();
    }

    private int evaluate(String resource, String partition, String participant) {
        double capacity = this._capacityProvider.getParticipantCapacity(participant);
        if (capacity == 0.0) {
            return 0;
        }
        double usage = this._capacityProvider.getParticipantUsage(participant) + (this._pendingUsage.containsKey(participant) ? this._pendingUsage.get(participant) : 0);
        double available = capacity - usage - (double)this._partitionWeightProvider.getPartitionWeight(resource, partition);
        return (int)Math.ceil(available / capacity * 100.0);
    }

    @Override
    public Map<String, int[]> evaluate(String resource, Map<String, String[]> proposedAssignment) {
        HashMap<String, int[]> result = new HashMap<String, int[]>();
        for (String partition : proposedAssignment.keySet()) {
            String[] participants = proposedAssignment.get(partition);
            int[] evaluateResults = new int[participants.length];
            for (int i = 0; i < participants.length; ++i) {
                evaluateResults[i] = this.evaluate(resource, partition, participants[i]);
            }
            result.put(partition, evaluateResults);
        }
        return result;
    }

    @Override
    public void updateAssignment(ResourcesStateMap pendingAssignment) {
        Map<String, Integer> newParticipantUsage = ResourceUsageCalculator.getResourceUsage(pendingAssignment, this._partitionWeightProvider);
        for (String participant : newParticipantUsage.keySet()) {
            if (!this._pendingUsage.containsKey(participant)) {
                this._pendingUsage.put(participant, 0);
            }
            this._pendingUsage.put(participant, this._pendingUsage.get(participant) + newParticipantUsage.get(participant));
        }
    }
}

