"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express = require("express");
const user_1 = require("./controllers/user");
const helix_1 = require("./controllers/helix");
function setRoutes(app) {
    const router = express.Router();
    const userCtrl = new user_1.UserCtrl(router);
    const helixCtrl = new helix_1.HelixCtrl(router);
    // Apply the routes to our application with the prefix /api
    app.use('/api', router);
    /* GET /admin to check app health. */
    app.get('/admin', (req, res, next) => {
        res.status(200).send('GOOD');
    });
}
exports.default = setRoutes;
//# sourceMappingURL=routes.js.map