/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.IdealState;
import org.apache.helix.tools.ClusterSetup;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.webapp.resources.JsonParameters;
import org.apache.helix.webapp.resources.ResourceUtil;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceGroupsResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceGroupsResource.class);

    public ResourceGroupsResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation = null;
        try {
            String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
            presentation = this.getHostedEntitiesRepresentation(clusterName);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("Exception in get resourceGroups", (Throwable)e);
        }
        return presentation;
    }

    StringRepresentation getHostedEntitiesRepresentation(String clusterName) throws JsonGenerationException, JsonMappingException, IOException {
        ZkClient zkclient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.RAW_ZKCLIENT);
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
        Map<String, String> idealStateMap = ResourceUtil.readZkChildrenAsBytesMap(zkclient, keyBuilder.idealStates());
        ZNRecord hostedEntitiesRecord = new ZNRecord("ResourceGroups");
        HashMap tagMap = Maps.newHashMap();
        for (String resourceName : idealStateMap.keySet()) {
            String idealStateStr = idealStateMap.get(resourceName);
            String tag = ResourceUtil.extractSimpleFieldFromZNRecord(idealStateStr, IdealState.IdealStateProperty.INSTANCE_GROUP_TAG.toString());
            if (tag == null) continue;
            tagMap.put(resourceName, tag);
        }
        ArrayList allResources = Lists.newArrayList(idealStateMap.keySet());
        hostedEntitiesRecord.setListField("ResourceGroups", (List)allResources);
        if (!tagMap.isEmpty()) {
            hostedEntitiesRecord.setMapField("ResourceTags", (Map)tagMap);
        }
        StringRepresentation representation = new StringRepresentation((CharSequence)ClusterRepresentationUtil.ZNRecordToJson(hostedEntitiesRecord), MediaType.APPLICATION_JSON);
        return representation;
    }

    public Representation post(Representation entity) {
        try {
            int maxPartitionsPerNode;
            int bucketSize;
            String mode;
            int partitions;
            String stateModelDefRef;
            String entityName;
            String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
            JsonParameters jsonParameters = new JsonParameters(entity);
            String command = jsonParameters.getCommand();
            if (command.equalsIgnoreCase("addResource") || JsonParameters.CLUSTERSETUP_COMMAND_ALIASES.get("addResource").contains(command)) {
                jsonParameters.verifyCommand("addResource");
                entityName = jsonParameters.getParameter("resourceGroupName");
                stateModelDefRef = jsonParameters.getParameter("stateModelDefRef");
                partitions = Integer.parseInt(jsonParameters.getParameter("partitions"));
                mode = IdealState.RebalanceMode.SEMI_AUTO.toString();
                if (jsonParameters.getParameter("mode") != null) {
                    mode = jsonParameters.getParameter("mode");
                }
                bucketSize = 0;
                if (jsonParameters.getParameter("bucketSize") != null) {
                    try {
                        bucketSize = Integer.parseInt(jsonParameters.getParameter("bucketSize"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                maxPartitionsPerNode = -1;
                if (jsonParameters.getParameter("maxPartitionsPerNode") != null) {
                    try {
                        maxPartitionsPerNode = Integer.parseInt(jsonParameters.getParameter("maxPartitionsPerNode"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            } else {
                throw new HelixException("Unsupported command: " + command + ". Should be one of [" + "addResource" + "]");
            }
            ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
            ClusterSetup setupTool = new ClusterSetup((RealmAwareZkClient)zkClient);
            setupTool.addResourceToCluster(clusterName, entityName, partitions, stateModelDefRef, mode, bucketSize, maxPartitionsPerNode);
            this.getResponse().setEntity((Representation)this.getHostedEntitiesRepresentation(clusterName));
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
            LOG.error("Error in posting " + entity, (Throwable)e);
        }
        return null;
    }
}

