/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import java.io.IOException;
import org.apache.helix.PropertyKey;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.webapp.resources.ResourceUtil;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalViewResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalViewResource.class);

    public ExternalViewResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation = null;
        try {
            String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
            String resourceName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.RESOURCE_NAME);
            presentation = this.getExternalViewRepresentation(clusterName, resourceName);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("Exception in get externalView", (Throwable)e);
        }
        return presentation;
    }

    StringRepresentation getExternalViewRepresentation(String clusterName, String resourceName) throws JsonGenerationException, JsonMappingException, IOException {
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
        ZkClient zkclient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.RAW_ZKCLIENT);
        String extViewStr = ResourceUtil.readZkAsBytes(zkclient, keyBuilder.externalView(resourceName));
        StringRepresentation representation = new StringRepresentation((CharSequence)extViewStr, MediaType.APPLICATION_JSON);
        return representation;
    }
}

