/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import java.io.IOException;
import java.util.List;
import org.apache.helix.HelixException;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.manager.zk.client.HelixZkClient;
import org.apache.helix.tools.ClusterSetup;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.webapp.resources.JsonParameters;
import org.apache.helix.webapp.resources.ResourceUtil;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClustersResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClustersResource.class);

    public ClustersResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation = null;
        try {
            presentation = this.getClustersRepresentation();
        }
        catch (Exception e) {
            LOG.error("Exception in get all clusters", (Throwable)e);
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
        }
        return presentation;
    }

    StringRepresentation getClustersRepresentation() throws JsonGenerationException, JsonMappingException, IOException {
        ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
        ClusterSetup setupTool = new ClusterSetup((HelixZkClient)zkClient);
        List clusters = setupTool.getClusterManagementTool().getClusters();
        ZNRecord clustersRecord = new ZNRecord("Clusters Summary");
        clustersRecord.setListField("clusters", clusters);
        StringRepresentation representation = new StringRepresentation((CharSequence)ClusterRepresentationUtil.ZNRecordToJson(clustersRecord), MediaType.APPLICATION_JSON);
        return representation;
    }

    public Representation post(Representation entity) {
        try {
            JsonParameters jsonParameters = new JsonParameters(entity);
            String command = jsonParameters.getCommand();
            if (command == null) {
                throw new HelixException("Could NOT find 'command' in parameterMap: " + jsonParameters._parameterMap);
            }
            if (!command.equalsIgnoreCase("addCluster")) {
                throw new HelixException("Unsupported command: " + command + ". Should be one of [" + "addCluster" + "]");
            }
            jsonParameters.verifyCommand("addCluster");
            ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
            ClusterSetup setupTool = new ClusterSetup((HelixZkClient)zkClient);
            setupTool.addCluster(jsonParameters.getParameter("clusterName"), false);
            this.getResponse().setEntity((Representation)this.getClustersRepresentation());
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
            LOG.error("Error in posting " + entity, (Throwable)e);
        }
        return null;
    }

    public Representation delete() {
        return null;
    }
}

