/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.jute.compiler;

public abstract class JType {
    private String mCName;
    private String mCppName;
    private String mCsharpName;
    private String mJavaName;
    protected String mMethodSuffix;
    private String mWrapper;
    private String mSharpWrapper;
    private String mUnwrapMethod;

    JType(String cname, String cppname, String csharpName, String javaname, String suffix, String wrapper, String csharpWrapper, String unwrap) {
        this.mCName = cname;
        this.mCppName = cppname;
        this.mCsharpName = "Id".equals(csharpName) ? "ZKId" : csharpName;
        this.mJavaName = javaname;
        this.mMethodSuffix = suffix;
        this.mWrapper = wrapper;
        this.mSharpWrapper = csharpWrapper;
        this.mUnwrapMethod = unwrap;
    }

    abstract String getSignature();

    String genCppDecl(String fname) {
        return "  " + this.mCppName + " m" + fname + ";\n";
    }

    String genCDecl(String name) {
        return "    " + this.mCName + " " + name + ";\n";
    }

    public String genCsharpDecl(String name) {
        return "  private " + this.mCsharpName + " " + name + ";\n";
    }

    String genJavaDecl(String fname) {
        return "  private " + this.mJavaName + " " + fname + ";\n";
    }

    String genJavaConstructorParam(String fname) {
        return "        " + this.mJavaName + " " + fname;
    }

    String genCppGetSet(String fname, int fIdx) {
        String getFunc = "  virtual " + this.mCppName + " get" + fname + "() const {\n";
        getFunc = getFunc + "    return m" + fname + ";\n";
        getFunc = getFunc + "  }\n";
        String setFunc = "  virtual void set" + fname + "(" + this.mCppName + " m_) {\n";
        setFunc = setFunc + "    m" + fname + "=m_; bs_.set(" + fIdx + ");\n";
        setFunc = setFunc + "  }\n";
        return getFunc + setFunc;
    }

    String genCsharpGetSet(String fname, int fIdx) {
        String getFunc = "  public " + this.getCsharpType() + " " + JType.capitalize(fname) + " { get; set; } ";
        return getFunc;
    }

    static String capitalize(String s2) {
        return s2.substring(0, 1).toUpperCase() + s2.substring(1);
    }

    String genJavaGetSet(String fname, int fIdx) {
        String getFunc = "  public " + this.mJavaName + " get" + JType.capitalize(fname) + "() {\n";
        getFunc = getFunc + "    return " + fname + ";\n";
        getFunc = getFunc + "  }\n";
        String setFunc = "  public void set" + JType.capitalize(fname) + "(" + this.mJavaName + " m_) {\n";
        setFunc = setFunc + "    " + fname + "=m_;\n";
        setFunc = setFunc + "  }\n";
        return getFunc + setFunc;
    }

    String getCType() {
        return this.mCName;
    }

    String getCppType() {
        return this.mCppName;
    }

    String getCsharpType() {
        return this.mCsharpName;
    }

    String getJavaType() {
        return this.mJavaName;
    }

    String getJavaWrapperType() {
        return this.mWrapper;
    }

    String getCsharpWrapperType() {
        return this.mSharpWrapper;
    }

    String getMethodSuffix() {
        return this.mMethodSuffix;
    }

    String genJavaWriteMethod(String fname, String tag) {
        return "    a_.write" + this.mMethodSuffix + "(" + fname + ",\"" + tag + "\");\n";
    }

    String genJavaReadMethod(String fname, String tag) {
        return "    " + fname + "=a_.read" + this.mMethodSuffix + "(\"" + tag + "\");\n";
    }

    String genJavaReadWrapper(String fname, String tag, boolean decl) {
        String ret = "";
        if (decl) {
            ret = "    " + this.mWrapper + " " + fname + ";\n";
        }
        return ret + "    " + fname + "=new " + this.mWrapper + "(a_.read" + this.mMethodSuffix + "(\"" + tag + "\"));\n";
    }

    String genJavaWriteWrapper(String fname, String tag) {
        return "        a_.write" + this.mMethodSuffix + "(" + fname + "." + this.mUnwrapMethod + "(),\"" + tag + "\");\n";
    }

    String genJavaCompareTo(String fname) {
        return "    ret = (" + fname + " == peer." + fname + ")? 0 :((" + fname + "<peer." + fname + ")?-1:1);\n";
    }

    String genJavaEquals(String fname, String peer) {
        return "    ret = (" + fname + "==" + peer + ");\n";
    }

    String genJavaHashCode(String fname) {
        return "    ret = (int)" + fname + ";\n";
    }

    String genJavaConstructorSet(String fname, String name) {
        return "    this." + fname + "=" + name + ";\n";
    }

    String genCsharpWriteMethod(String fname, String tag) {
        return "    a_.Write" + this.mMethodSuffix + "(" + JType.capitalize(fname) + ",\"" + tag + "\");\n";
    }

    String genCsharpReadMethod(String fname, String tag) {
        return "    " + JType.capitalize(fname) + "=a_.Read" + this.mMethodSuffix + "(\"" + tag + "\");\n";
    }

    String genCsharpReadWrapper(String fname, String tag, boolean decl) {
        String ret = "";
        if (decl) {
            ret = "    " + this.mWrapper + " " + fname + ";\n";
        }
        return ret + "    " + fname + "=a_.Read" + this.mMethodSuffix + "(\"" + tag + "\");\n";
    }

    String genCsharpWriteWrapper(String fname, String tag) {
        if (this.mUnwrapMethod == null) {
            return "        a_.Write" + this.mMethodSuffix + "(" + fname + "," + tag + ");\n";
        }
        return "        a_.Write" + this.mMethodSuffix + "(" + fname + "." + this.mUnwrapMethod + "(),\"" + tag + "\");\n";
    }

    String genCsharpCompareTo(String name) {
        return "    ret = (" + JType.capitalize(name) + " == peer." + JType.capitalize(name) + ")? 0 :((" + JType.capitalize(name) + "<peer." + JType.capitalize(name) + ")?-1:1);\n";
    }

    String genCsharpEquals(String name, String peer) {
        String[] peerSplit = peer.split("\\.");
        return "    ret = (" + JType.capitalize(name) + "==" + peerSplit[0] + "." + JType.capitalize(peerSplit[1]) + ");\n";
    }

    String genCsharpHashCode(String fname) {
        return "    ret = (int)" + JType.capitalize(fname) + ";\n";
    }

    String genCsharpConstructorSet(String mName, String fname) {
        return JType.capitalize(fname) + "=" + mName + ";\n";
    }

    public String genCsharpConstructorParam(String fname) {
        return "  " + this.mCsharpName + " " + fname + "\n";
    }
}

