/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestSplitWithCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSplitWithCache.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSplitWithCache.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setInt("hbase.client.meta.operation.timeout", 1000);
        UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        UTIL.getConfiguration().setBoolean("hbase.rs.cacheblocksonwrite", true);
        UTIL.getConfiguration().setBoolean("hbase.rs.prefetchblocksonopen", true);
        UTIL.getConfiguration().set("hbase.bucketcache.ioengine", "offheap");
        UTIL.getConfiguration().setInt("hbase.bucketcache.size", 200);
    }

    @Test
    public void testEvictOnSplit() throws Exception {
        this.doTest("testEvictOnSplit", true, (f, m) -> Waiter.waitFor((Configuration)UTIL.getConfiguration(), (long)1000L, () -> m.get(f) != null), (f, m) -> Waiter.waitFor((Configuration)UTIL.getConfiguration(), (long)1000L, () -> m.get(f) == null));
    }

    @Test
    public void testDoesntEvictOnSplit() throws Exception {
        this.doTest("testDoesntEvictOnSplit", false, (f, m) -> Waiter.waitFor((Configuration)UTIL.getConfiguration(), (long)1000L, () -> m.get(f) != null), (f, m) -> Waiter.waitFor((Configuration)UTIL.getConfiguration(), (long)1000L, () -> m.get(f) != null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(String table, boolean evictOnSplit, BiConsumer<String, Map<String, Pair<String, Long>>> predicateBeforeSplit, BiConsumer<String, Map<String, Pair<String, Long>>> predicateAfterSplit) throws Exception {
        UTIL.getConfiguration().setBoolean("hbase.rs.evictblocksonsplit", evictOnSplit);
        UTIL.startMiniCluster(1);
        try {
            TableName tableName = TableName.valueOf((String)table);
            byte[] family = Bytes.toBytes((String)"CF");
            TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).build();
            UTIL.getAdmin().createTable(td);
            UTIL.waitTableAvailable(tableName);
            Table tbl = UTIL.getConnection().getTable(tableName);
            ArrayList<Put> puts = new ArrayList<Put>();
            for (int i = 0; i < 1000; ++i) {
                Put p = new Put(Bytes.toBytes((String)("row-" + i)));
                p.addColumn(family, Bytes.toBytes((int)1), Bytes.toBytes((String)("val-" + i)));
                puts.add(p);
            }
            tbl.put(puts);
            UTIL.getAdmin().flush(tableName);
            Collection files = ((HStore)UTIL.getMiniHBaseCluster().getRegions(tableName).get(0).getStores().get(0)).getStorefiles();
            this.checkCacheForBlocks(tableName, files, predicateBeforeSplit);
            UTIL.getAdmin().split(tableName, Bytes.toBytes((String)"row-500"));
            Waiter.waitFor((Configuration)UTIL.getConfiguration(), (long)30000L, () -> UTIL.getMiniHBaseCluster().getRegions(tableName).size() == 2);
            UTIL.waitUntilNoRegionsInTransition();
            this.checkCacheForBlocks(tableName, files, predicateAfterSplit);
        }
        finally {
            UTIL.shutdownMiniCluster();
        }
    }

    private void checkCacheForBlocks(TableName tableName, Collection<HStoreFile> files, BiConsumer<String, Map<String, Pair<String, Long>>> checker) {
        files.forEach(f -> UTIL.getMiniHBaseCluster().getRegionServer(0).getBlockCache().ifPresent(cache -> {
            cache.getFullyCachedFiles().ifPresent(m -> checker.accept(f.getPath().getName(), (Map<String, Pair<String, Long>>)m));
            Assert.assertTrue((boolean)cache.getFullyCachedFiles().isPresent());
        }));
    }
}

