/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.JaasConfiguration;
import com.microsoft.sqlserver.jdbc.KerbCallback;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriverStringProperty;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSPIAuthentication;
import com.microsoft.sqlserver.jdbc.dns.DNSKerberosLocator;
import java.lang.reflect.Method;
import java.net.IDN;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

final class KerbAuthentication
extends SSPIAuthentication {
    private static final Logger authLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.KerbAuthentication");
    private final SQLServerConnection con;
    private final String spn;
    private final GSSManager manager = GSSManager.getInstance();
    private LoginContext lc = null;
    private GSSCredential peerCredentials = null;
    private GSSContext peerContext = null;
    private static final Pattern SPN_PATTERN;
    private static RealmValidator validator;

    private void intAuthInit() throws SQLServerException {
        block13: {
            try {
                Subject currentSubject;
                Oid kerberos = new Oid("1.2.840.113554.1.2.2");
                GSSName remotePeerName = this.manager.createName(this.spn, null);
                if (null != this.peerCredentials) {
                    this.peerContext = this.manager.createContext(remotePeerName, kerberos, this.peerCredentials, 0);
                    this.peerContext.requestCredDeleg(false);
                    this.peerContext.requestMutualAuth(true);
                    this.peerContext.requestInteg(true);
                    break block13;
                }
                String configName = this.con.activeConnectionProperties.getProperty(SQLServerDriverStringProperty.JAAS_CONFIG_NAME.toString(), SQLServerDriverStringProperty.JAAS_CONFIG_NAME.getDefaultValue());
                KerbCallback callback = new KerbCallback(this.con);
                try {
                    AccessControlContext context = AccessController.getContext();
                    currentSubject = Subject.getSubject(context);
                    if (null == currentSubject) {
                        this.lc = new LoginContext(configName, callback);
                        this.lc.login();
                        currentSubject = this.lc.getSubject();
                    }
                }
                catch (LoginException le) {
                    if (authLogger.isLoggable(Level.FINE)) {
                        authLogger.fine(this.toString() + "Failed to login using Kerberos due to " + le.getClass().getName() + ":" + le.getMessage());
                    }
                    try {
                        this.con.terminate(0, SQLServerException.getErrString("R_integratedAuthenticationFailed"), le);
                    }
                    catch (SQLServerException alwaysTriggered) {
                        String message = MessageFormat.format(SQLServerException.getErrString("R_kerberosLoginFailed"), alwaysTriggered.getMessage(), le.getClass().getName(), le.getMessage());
                        if (callback.getUsernameRequested() != null) {
                            message = MessageFormat.format(SQLServerException.getErrString("R_kerberosLoginFailedForUsername"), callback.getUsernameRequested(), message);
                        }
                        throw new SQLServerException(message, alwaysTriggered.getSQLState(), 18456, (Throwable)le);
                    }
                    return;
                }
                if (authLogger.isLoggable(Level.FINER)) {
                    authLogger.finer(this.toString() + " Getting client credentials");
                }
                this.peerCredentials = KerbAuthentication.getClientCredential(currentSubject, this.manager, kerberos);
                if (authLogger.isLoggable(Level.FINER)) {
                    authLogger.finer(this.toString() + " creating security context");
                }
                this.peerContext = this.manager.createContext(remotePeerName, kerberos, this.peerCredentials, 0);
                this.peerContext.requestCredDeleg(true);
                this.peerContext.requestMutualAuth(true);
                this.peerContext.requestInteg(true);
            }
            catch (GSSException ge) {
                authLogger.finer(this.toString() + "initAuthInit failed GSSException:-" + ge);
                this.con.terminate(0, SQLServerException.getErrString("R_integratedAuthenticationFailed"), ge);
            }
            catch (PrivilegedActionException ge) {
                authLogger.finer(this.toString() + "initAuthInit failed privileged exception:-" + ge);
                this.con.terminate(0, SQLServerException.getErrString("R_integratedAuthenticationFailed"), ge);
            }
        }
    }

    private static GSSCredential getClientCredential(Subject subject, final GSSManager MANAGER, final Oid kerboid) throws PrivilegedActionException {
        PrivilegedExceptionAction<GSSCredential> action = new PrivilegedExceptionAction<GSSCredential>(){

            @Override
            public GSSCredential run() throws GSSException {
                return MANAGER.createCredential(null, 0, kerboid, 1);
            }
        };
        GSSCredential credential = Subject.doAs(subject, action);
        return credential;
    }

    private byte[] intAuthHandShake(byte[] pin, boolean[] done) throws SQLServerException {
        try {
            if (authLogger.isLoggable(Level.FINER)) {
                authLogger.finer(this.toString() + " Sending token to server over secure context");
            }
            byte[] byteToken = this.peerContext.initSecContext(pin, 0, pin.length);
            if (this.peerContext.isEstablished()) {
                done[0] = true;
                if (authLogger.isLoggable(Level.FINER)) {
                    authLogger.finer(this.toString() + "Authentication done.");
                }
            } else if (null == byteToken) {
                if (authLogger.isLoggable(Level.INFO)) {
                    authLogger.info(this.toString() + "byteToken is null in initSecContext.");
                }
                this.con.terminate(0, SQLServerException.getErrString("R_integratedAuthenticationFailed"));
            }
            return byteToken;
        }
        catch (GSSException ge) {
            authLogger.finer(this.toString() + "initSecContext Failed :-" + ge);
            this.con.terminate(0, SQLServerException.getErrString("R_integratedAuthenticationFailed"), ge);
            return null;
        }
    }

    private String makeSpn(String server, int port) throws SQLServerException {
        if (authLogger.isLoggable(Level.FINER)) {
            authLogger.finer(this.toString() + " Server: " + server + " port: " + port);
        }
        StringBuilder spn = new StringBuilder("MSSQLSvc/");
        if (this.con.serverNameAsACE()) {
            spn.append(IDN.toASCII(server));
        } else {
            spn.append(server);
        }
        spn.append(":");
        spn.append(port);
        String strSPN = spn.toString();
        if (authLogger.isLoggable(Level.FINER)) {
            authLogger.finer(this.toString() + " SPN: " + strSPN);
        }
        return strSPN;
    }

    KerbAuthentication(SQLServerConnection con, String address, int port) throws SQLServerException {
        String spn;
        this.con = con;
        String userSuppliedServerSpn = con.activeConnectionProperties.getProperty(SQLServerDriverStringProperty.SERVER_SPN.toString());
        if (null != userSuppliedServerSpn) {
            if (con.serverNameAsACE()) {
                int slashPos = userSuppliedServerSpn.indexOf("/");
                spn = userSuppliedServerSpn.substring(0, slashPos + 1) + IDN.toASCII(userSuppliedServerSpn.substring(slashPos + 1));
            } else {
                spn = userSuppliedServerSpn;
            }
        } else {
            spn = this.makeSpn(address, port);
        }
        this.spn = this.enrichSpnWithRealm(spn, null == userSuppliedServerSpn);
        if (!this.spn.equals(spn) && authLogger.isLoggable(Level.FINER)) {
            authLogger.finer(this.toString() + "SPN enriched: " + spn + " := " + this.spn);
        }
    }

    private String enrichSpnWithRealm(String spn, boolean allowHostnameCanonicalization) {
        if (spn == null) {
            return spn;
        }
        Matcher m = SPN_PATTERN.matcher(spn);
        if (!m.matches()) {
            return spn;
        }
        if (m.group(3) != null) {
            return spn;
        }
        String dnsName = m.group(1);
        String portOrInstance = m.group(2);
        RealmValidator realmValidator = KerbAuthentication.getRealmValidator(dnsName);
        String realm = this.findRealmFromHostname(realmValidator, dnsName);
        if (realm == null && allowHostnameCanonicalization) {
            try {
                String canonicalHostName = InetAddress.getByName(dnsName).getCanonicalHostName();
                realm = this.findRealmFromHostname(realmValidator, canonicalHostName);
                dnsName = canonicalHostName;
            }
            catch (UnknownHostException canonicalHostName) {
                // empty catch block
            }
        }
        if (realm == null) {
            return spn;
        }
        StringBuilder sb = new StringBuilder("MSSQLSvc/");
        sb.append(dnsName).append(":").append(portOrInstance).append("@").append(realm.toUpperCase(Locale.ENGLISH));
        return sb.toString();
    }

    static RealmValidator getRealmValidator(String hostnameToTest) {
        if (validator != null) {
            return validator;
        }
        try {
            RealmValidator oracleRealmValidator;
            Class<?> clz = Class.forName("sun.security.krb5.Config");
            Method getInstance = clz.getMethod("getInstance", new Class[0]);
            final Method getKDCList = clz.getMethod("getKDCList", String.class);
            final Object instance = getInstance.invoke(null, new Object[0]);
            validator = oracleRealmValidator = new RealmValidator(){

                @Override
                public boolean isRealmValid(String realm) {
                    try {
                        Object ret = getKDCList.invoke(instance, realm);
                        return ret != null;
                    }
                    catch (Exception err) {
                        return false;
                    }
                }
            };
            if (!validator.isRealmValid("this.might.not.exist." + hostnameToTest)) {
                authLogger.fine("Kerberos Realm Validator: Using Built-in Oracle Realm Validation method.");
                return oracleRealmValidator;
            }
            authLogger.fine("Kerberos Realm Validator: Detected buggy Oracle Realm Validator, using DNSKerberosLocator.");
        }
        catch (ReflectiveOperationException notTheRightJVMException) {
            authLogger.fine("Kerberos Realm Validator: No Oracle Realm Validator Available, using DNSKerberosLocator.");
        }
        validator = new RealmValidator(){

            @Override
            public boolean isRealmValid(String realm) {
                try {
                    return DNSKerberosLocator.isRealmValid(realm);
                }
                catch (NamingException err) {
                    return false;
                }
            }
        };
        return validator;
    }

    private String findRealmFromHostname(RealmValidator realmValidator, String hostname) {
        if (hostname == null) {
            return null;
        }
        int index = 0;
        while (index != -1 && index < hostname.length() - 2) {
            String realm = hostname.substring(index);
            if (authLogger.isLoggable(Level.FINEST)) {
                authLogger.finest(this.toString() + " looking up REALM candidate " + realm);
            }
            if (realmValidator.isRealmValid(realm)) {
                return realm.toUpperCase();
            }
            if ((index = hostname.indexOf(".", index + 1)) == -1) continue;
            ++index;
        }
        return null;
    }

    KerbAuthentication(SQLServerConnection con, String address, int port, GSSCredential ImpersonatedUserCred) throws SQLServerException {
        this(con, address, port);
        this.peerCredentials = ImpersonatedUserCred;
    }

    @Override
    byte[] GenerateClientContext(byte[] pin, boolean[] done) throws SQLServerException {
        if (null == this.peerContext) {
            this.intAuthInit();
        }
        return this.intAuthHandShake(pin, done);
    }

    @Override
    int ReleaseClientContext() throws SQLServerException {
        try {
            if (null != this.peerCredentials) {
                this.peerCredentials.dispose();
            }
            if (null != this.peerContext) {
                this.peerContext.dispose();
            }
            if (null != this.lc) {
                this.lc.logout();
            }
        }
        catch (LoginException e) {
            authLogger.fine(this.toString() + " Release of the credentials failed LoginException: " + e);
        }
        catch (GSSException e) {
            authLogger.fine(this.toString() + " Release of the credentials failed GSSException: " + e);
        }
        return 0;
    }

    static {
        Configuration.setConfiguration(new JaasConfiguration(Configuration.getConfiguration()));
        SPN_PATTERN = Pattern.compile("MSSQLSvc/(.*):([^:@]+)(@.+)?", 2);
    }

    static interface RealmValidator {
        public boolean isRealmValid(String var1);
    }
}

