/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.mob.MobFile;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CachedMobFile
extends MobFile
implements Comparable<CachedMobFile> {
    private long accessCount;
    private AtomicLong referenceCount = new AtomicLong(0L);

    public CachedMobFile(HStoreFile sf) {
        super(sf);
    }

    public static CachedMobFile create(FileSystem fs, Path path, Configuration conf, CacheConfig cacheConf) throws IOException {
        HStoreFile sf = new HStoreFile(fs, path, conf, cacheConf, BloomType.NONE, true);
        return new CachedMobFile(sf);
    }

    public void access(long accessCount) {
        this.accessCount = accessCount;
    }

    @Override
    public int compareTo(CachedMobFile that) {
        if (this.accessCount == that.accessCount) {
            return 0;
        }
        return this.accessCount < that.accessCount ? 1 : -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CachedMobFile)) {
            return false;
        }
        return this.compareTo((CachedMobFile)obj) == 0;
    }

    public int hashCode() {
        return (int)(this.accessCount ^ this.accessCount >>> 32);
    }

    @Override
    public void open() throws IOException {
        super.open();
        this.referenceCount.incrementAndGet();
    }

    @Override
    public void close() throws IOException {
        long refs = this.referenceCount.decrementAndGet();
        if (refs == 0L) {
            super.close();
        }
    }

    public long getReferenceCount() {
        return this.referenceCount.longValue();
    }
}

