/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit;

import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.commit.MagicCommitPaths;
import org.apache.hadoop.fs.s3a.commit.PutTracker;
import org.apache.hadoop.fs.s3a.commit.magic.InMemoryMagicCommitTracker;
import org.apache.hadoop.fs.s3a.commit.magic.MagicCommitTrackerUtils;
import org.apache.hadoop.fs.s3a.commit.magic.S3MagicCommitTracker;
import org.apache.hadoop.fs.s3a.impl.AbstractStoreOperation;
import org.apache.hadoop.fs.s3a.statistics.PutTrackerStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MagicCommitIntegration
extends AbstractStoreOperation {
    private static final Logger LOG = LoggerFactory.getLogger(MagicCommitIntegration.class);
    private final S3AFileSystem owner;
    private final boolean magicCommitEnabled;

    public MagicCommitIntegration(S3AFileSystem owner, boolean magicCommitEnabled) {
        super(owner.createStoreContext());
        this.owner = owner;
        this.magicCommitEnabled = magicCommitEnabled && owner.isMultipartUploadEnabled();
    }

    public String keyOfFinalDestination(List<String> elements, String key) {
        if (this.isMagicCommitPath(elements)) {
            return MagicCommitPaths.elementsToKey(this.finalDestination(elements));
        }
        return key;
    }

    public PutTracker createTracker(Path path, String key, PutTrackerStatistics trackerStatistics) {
        PutTracker tracker;
        List<String> elements = MagicCommitPaths.splitPathToElements(path);
        if (this.isMagicFile(elements)) {
            if (this.isMagicCommitPath(elements)) {
                String destKey = this.keyOfFinalDestination(elements, key);
                String pendingsetPath = key + ".pending";
                this.getStoreContext().incrementStatistic(Statistic.COMMITTER_MAGIC_FILES_CREATED);
                tracker = MagicCommitTrackerUtils.isTrackMagicCommitsInMemoryEnabled(this.getStoreContext().getConfiguration()) ? new InMemoryMagicCommitTracker(path, this.getStoreContext().getBucket(), key, destKey, pendingsetPath, this.owner.getWriteOperationHelper(), trackerStatistics) : new S3MagicCommitTracker(path, this.getStoreContext().getBucket(), key, destKey, pendingsetPath, this.owner.getWriteOperationHelper(), trackerStatistics);
                LOG.debug("Created {}", (Object)tracker);
            } else {
                LOG.warn("File being created has a \"magic\" path, but the filesystem has magic file support disabled: {}", (Object)path);
                tracker = new PutTracker(key);
            }
        } else {
            tracker = new PutTracker(key);
        }
        return tracker;
    }

    private List<String> finalDestination(List<String> elements) {
        return this.magicCommitEnabled ? MagicCommitPaths.finalDestination(elements) : elements;
    }

    public boolean isMagicCommitEnabled() {
        return this.magicCommitEnabled;
    }

    public boolean isMagicCommitPath(Path path) {
        return this.isMagicCommitPath(MagicCommitPaths.splitPathToElements(path));
    }

    private boolean isMagicCommitPath(List<String> elements) {
        return this.magicCommitEnabled && this.isMagicFile(elements);
    }

    private boolean isMagicFile(List<String> elements) {
        return MagicCommitPaths.isMagicPath(elements) && !this.isCommitMetadataFile(elements);
    }

    private boolean isCommitMetadataFile(List<String> elements) {
        String last = elements.get(elements.size() - 1);
        return last.endsWith(".pending") || last.endsWith(".pendingset");
    }

    public boolean isUnderMagicPath(Path path) {
        return this.magicCommitEnabled && MagicCommitPaths.isMagicPath(MagicCommitPaths.splitPathToElements(path));
    }
}

