/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.hdfs.util.EnumCounters;

public class NumberReplicas
extends EnumCounters<StoredReplicaState> {
    public NumberReplicas() {
        super(StoredReplicaState.class);
    }

    public int liveReplicas() {
        return (int)this.get(StoredReplicaState.LIVE);
    }

    public int readOnlyReplicas() {
        return (int)this.get(StoredReplicaState.READONLY);
    }

    public int decommissionedAndDecommissioning() {
        return this.decommissioned() + this.decommissioning();
    }

    public int decommissioned() {
        return (int)this.get(StoredReplicaState.DECOMMISSIONED);
    }

    public int decommissioning() {
        return (int)this.get(StoredReplicaState.DECOMMISSIONING);
    }

    public int corruptReplicas() {
        return (int)this.get(StoredReplicaState.CORRUPT);
    }

    public int excessReplicas() {
        return (int)this.get(StoredReplicaState.EXCESS);
    }

    public int replicasOnStaleNodes() {
        return (int)this.get(StoredReplicaState.STALESTORAGE);
    }

    public int redundantInternalBlocks() {
        return (int)this.get(StoredReplicaState.REDUNDANT);
    }

    public int maintenanceNotForReadReplicas() {
        return (int)this.get(StoredReplicaState.MAINTENANCE_NOT_FOR_READ);
    }

    public int maintenanceReplicas() {
        return (int)(this.get(StoredReplicaState.MAINTENANCE_NOT_FOR_READ) + this.get(StoredReplicaState.MAINTENANCE_FOR_READ));
    }

    public int outOfServiceReplicas() {
        return this.maintenanceReplicas() + this.decommissionedAndDecommissioning();
    }

    public int liveEnteringMaintenanceReplicas() {
        return (int)this.get(StoredReplicaState.MAINTENANCE_FOR_READ);
    }

    public static enum StoredReplicaState {
        LIVE,
        READONLY,
        DECOMMISSIONING,
        DECOMMISSIONED,
        MAINTENANCE_NOT_FOR_READ,
        MAINTENANCE_FOR_READ,
        CORRUPT,
        EXCESS,
        STALESTORAGE,
        REDUNDANT;

    }
}

