/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import java.util.List;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.random.ContinuousDistribution;
import org.ojalgo.random.Random1D;
import org.ojalgo.random.process.AbstractProcess;
import org.ojalgo.random.process.RandomProcess;

abstract class Process1D<D extends ContinuousDistribution, P extends AbstractProcess<D>> {
    private final Random1D myGenerator;
    private final AbstractProcess<? extends D>[] myProcesses;

    protected Process1D(Access2D<?> correlations, List<? extends P> processes) {
        this.myGenerator = new Random1D(correlations);
        this.myProcesses = processes.toArray(new AbstractProcess[processes.size()]);
    }

    protected Process1D(List<? extends P> processes) {
        int tmpSize = processes.size();
        this.myGenerator = new Random1D(tmpSize);
        this.myProcesses = processes.toArray(new AbstractProcess[tmpSize]);
    }

    public double getValue(int index) {
        return this.myProcesses[index].getValue();
    }

    public Primitive64Array getValues() {
        int tmpLength = this.myProcesses.length;
        Primitive64Array retVal = Primitive64Array.make(tmpLength);
        for (int p = 0; p < tmpLength; ++p) {
            retVal.set((long)p, this.myProcesses[p].getValue());
        }
        return retVal;
    }

    public void setValue(int index, double newValue) {
        this.myProcesses[index].setValue(newValue);
    }

    public void setValues(Access1D<?> newValues) {
        for (int p = 0; p < this.myProcesses.length; ++p) {
            this.myProcesses[p].setValue(newValues.doubleValue(p));
        }
    }

    public int size() {
        return this.myProcesses.length;
    }

    public Array1D<Double> step(double stepSize) {
        Array1D<Double> retVal = this.myGenerator.nextGaussian();
        for (int p = 0; p < this.myProcesses.length; ++p) {
            retVal.set((long)p, this.myProcesses[p].step(this.getValue(p), stepSize, retVal.doubleValue(p)));
        }
        return retVal;
    }

    protected AbstractProcess<?> getProcess(int index) {
        return this.myProcesses[index];
    }

    D getDistribution(int index, double stepSize) {
        return (D)((ContinuousDistribution)this.myProcesses[index].getDistribution(stepSize));
    }

    double getExpected(int index, double stepSize) {
        return this.myProcesses[index].getExpected(stepSize);
    }

    double getLowerConfidenceQuantile(int index, double stepSize, double confidence) {
        return this.myProcesses[index].getLowerConfidenceQuantile(stepSize, confidence);
    }

    double getStandardDeviation(int index, double stepSize) {
        return this.myProcesses[index].getStandardDeviation(stepSize);
    }

    double getUpperConfidenceQuantile(int index, double stepSize, double confidence) {
        return this.myProcesses[index].getUpperConfidenceQuantile(stepSize, confidence);
    }

    double getVariance(int index, double stepSize) {
        return this.myProcesses[index].getVariance(stepSize);
    }

    RandomProcess.SimulationResults simulate(int index, int numberOfRealisations, int numberOfSteps, double stepSize) {
        return this.myProcesses[index].simulate(numberOfRealisations, numberOfSteps, stepSize);
    }

    double step(int index, double stepSize) {
        return this.myProcesses[index].step(stepSize);
    }
}

