/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidAbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsCounters;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsIoUtils;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.AbfsThrottlingIntercept;
import org.apache.hadoop.fs.azurebfs.services.RetryReason;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsRestOperation {
    private final AbfsRestOperationType operationType;
    private final AbfsClient client;
    private final AbfsThrottlingIntercept intercept;
    private final String method;
    private final URL url;
    private final List<AbfsHttpHeader> requestHeaders;
    private final boolean hasRequestBody;
    private final String sasToken;
    private static final Logger LOG = LoggerFactory.getLogger(AbfsClient.class);
    private byte[] buffer;
    private int bufferOffset;
    private int bufferLength;
    private int retryCount = 0;
    private AbfsHttpOperation result;
    private AbfsCounters abfsCounters;
    private String failureReason;
    private TracingContext lastUsedTracingContext;

    public boolean hasResult() {
        return this.result != null;
    }

    public AbfsHttpOperation getResult() {
        return this.result;
    }

    public void hardSetResult(int httpStatus) {
        this.result = AbfsHttpOperation.getAbfsHttpOperationWithFixedResult(this.url, this.method, httpStatus);
    }

    public URL getUrl() {
        return this.url;
    }

    public List<AbfsHttpHeader> getRequestHeaders() {
        return this.requestHeaders;
    }

    public boolean isARetriedRequest() {
        return this.retryCount > 0;
    }

    String getSasToken() {
        return this.sasToken;
    }

    AbfsRestOperation(AbfsRestOperationType operationType, AbfsClient client, String method, URL url, List<AbfsHttpHeader> requestHeaders) {
        this(operationType, client, method, url, requestHeaders, null);
    }

    AbfsRestOperation(AbfsRestOperationType operationType, AbfsClient client, String method, URL url, List<AbfsHttpHeader> requestHeaders, String sasToken) {
        this.operationType = operationType;
        this.client = client;
        this.method = method;
        this.url = url;
        this.requestHeaders = requestHeaders;
        this.hasRequestBody = "PUT".equals(method) || "POST".equals(method) || "PATCH".equals(method);
        this.sasToken = sasToken;
        this.abfsCounters = client.getAbfsCounters();
        this.intercept = client.getIntercept();
    }

    AbfsRestOperation(AbfsRestOperationType operationType, AbfsClient client, String method, URL url, List<AbfsHttpHeader> requestHeaders, byte[] buffer, int bufferOffset, int bufferLength, String sasToken) {
        this(operationType, client, method, url, requestHeaders, sasToken);
        this.buffer = buffer;
        this.bufferOffset = bufferOffset;
        this.bufferLength = bufferLength;
        this.abfsCounters = client.getAbfsCounters();
    }

    public void execute(TracingContext tracingContext) throws AzureBlobFileSystemException {
        this.lastUsedTracingContext = this.createNewTracingContext(tracingContext);
        try {
            IOStatisticsBinding.trackDurationOfInvocation((DurationTrackerFactory)this.abfsCounters, (String)AbfsStatistic.getStatNameFromHttpCall(this.method), () -> this.completeExecute(this.lastUsedTracingContext));
        }
        catch (AzureBlobFileSystemException aze) {
            throw aze;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error while tracking Duration of an AbfsRestOperation call", e);
        }
    }

    void completeExecute(TracingContext tracingContext) throws AzureBlobFileSystemException {
        String latencyHeader = this.getClientLatency();
        if (latencyHeader != null && !latencyHeader.isEmpty()) {
            AbfsHttpHeader httpHeader = new AbfsHttpHeader("x-ms-abfs-client-latency", latencyHeader);
            this.requestHeaders.add(httpHeader);
        }
        this.retryCount = 0;
        LOG.debug("First execution of REST operation - {}", (Object)this.operationType);
        while (!this.executeHttpOperation(this.retryCount, tracingContext)) {
            try {
                ++this.retryCount;
                tracingContext.setRetryCount(this.retryCount);
                LOG.debug("Retrying REST operation {}. RetryCount = {}", (Object)this.operationType, (Object)this.retryCount);
                Thread.sleep(this.client.getRetryPolicy().getRetryInterval(this.retryCount));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        int status = this.result.getStatusCode();
        if (status < 100) {
            throw new InvalidAbfsRestOperationException(null, this.retryCount);
        }
        if (status >= 400) {
            throw new AbfsRestOperationException(this.result.getStatusCode(), this.result.getStorageErrorCode(), this.result.getStorageErrorMessage(), null, this.result);
        }
        LOG.trace("{} REST operation complete", (Object)this.operationType);
    }

    @VisibleForTesting
    String getClientLatency() {
        return this.client.getAbfsPerfTracker().getClientLatency();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean executeHttpOperation(int retryCount, TracingContext tracingContext) throws AzureBlobFileSystemException {
        boolean updateMetricsResponseCode;
        int status;
        AbfsHttpOperation httpOperation;
        try {
            httpOperation = this.createHttpOperation();
            this.incrementCounter(AbfsStatistic.CONNECTIONS_MADE, 1L);
            tracingContext.constructHeader(httpOperation, this.failureReason);
            this.signRequest(httpOperation, this.hasRequestBody ? this.bufferLength : 0);
        }
        catch (IOException e) {
            LOG.debug("Auth failure: {}, {}", (Object)this.method, (Object)this.url);
            throw new AbfsRestOperationException(-1, null, "Auth failure: " + e.getMessage(), e);
        }
        try {
            AbfsIoUtils.dumpHeadersToDebugLog("Request Headers", httpOperation.getConnection().getRequestProperties());
            this.intercept.sendingRequest(this.operationType, this.abfsCounters);
            if (this.hasRequestBody) {
                httpOperation.sendRequest(this.buffer, this.bufferOffset, this.bufferLength);
                this.incrementCounter(AbfsStatistic.SEND_REQUESTS, 1L);
                this.incrementCounter(AbfsStatistic.BYTES_SENT, this.bufferLength);
            }
            httpOperation.processResponse(this.buffer, this.bufferOffset, this.bufferLength);
            this.incrementCounter(AbfsStatistic.GET_RESPONSES, 1L);
            if (httpOperation.getStatusCode() >= 200 && httpOperation.getStatusCode() <= 206) {
                this.incrementCounter(AbfsStatistic.BYTES_RECEIVED, httpOperation.getBytesReceived());
            } else if (httpOperation.getStatusCode() == 503) {
                this.incrementCounter(AbfsStatistic.SERVER_UNAVAILABLE, 1L);
            }
            status = httpOperation.getStatusCode();
            boolean bl = updateMetricsResponseCode = status < 300 || status >= 500;
        }
        catch (UnknownHostException ex) {
            boolean updateMetricsResponseCode2;
            String hostname = null;
            hostname = httpOperation.getHost();
            this.failureReason = RetryReason.getAbbreviation(ex, null, null);
            LOG.warn("Unknown host name: {}. Retrying to resolve the host name...", (Object)hostname);
            if (!this.client.getRetryPolicy().shouldRetry(retryCount, -1)) {
                throw new InvalidAbfsRestOperationException(ex, retryCount);
            }
            boolean bl = false;
            int status2 = httpOperation.getStatusCode();
            boolean bl2 = updateMetricsResponseCode2 = status2 < 300 || status2 >= 500;
            if (updateMetricsResponseCode2) {
                this.intercept.updateMetrics(this.operationType, httpOperation);
            }
            return bl;
        }
        catch (IOException ex2) {
            boolean updateMetricsResponseCode3;
            if (LOG.isDebugEnabled()) {
                LOG.debug("HttpRequestFailure: {}, {}", (Object)httpOperation, (Object)ex2);
            }
            this.failureReason = RetryReason.getAbbreviation(ex2, -1, "");
            if (!this.client.getRetryPolicy().shouldRetry(retryCount, -1)) {
                throw new InvalidAbfsRestOperationException(ex2, retryCount);
            }
            boolean bl = false;
            int status3 = httpOperation.getStatusCode();
            boolean bl3 = updateMetricsResponseCode3 = status3 < 300 || status3 >= 500;
            {
                catch (Throwable throwable) {
                    boolean updateMetricsResponseCode4;
                    int status4 = httpOperation.getStatusCode();
                    boolean bl4 = updateMetricsResponseCode4 = status4 < 300 || status4 >= 500;
                    if (updateMetricsResponseCode4) {
                        this.intercept.updateMetrics(this.operationType, httpOperation);
                    }
                    throw throwable;
                }
            }
            if (updateMetricsResponseCode3) {
                this.intercept.updateMetrics(this.operationType, httpOperation);
            }
            return bl;
        }
        if (updateMetricsResponseCode) {
            this.intercept.updateMetrics(this.operationType, httpOperation);
        }
        LOG.debug("HttpRequest: {}: {}", (Object)this.operationType, (Object)httpOperation);
        if (this.client.getRetryPolicy().shouldRetry(retryCount, httpOperation.getStatusCode())) {
            status = httpOperation.getStatusCode();
            this.failureReason = RetryReason.getAbbreviation(null, status, httpOperation.getStorageErrorMessage());
            return false;
        }
        this.result = httpOperation;
        return true;
    }

    @VisibleForTesting
    public void signRequest(AbfsHttpOperation httpOperation, int bytesToSign) throws IOException {
        switch (this.client.getAuthType()) {
            case Custom: 
            case OAuth: {
                LOG.debug("Authenticating request with OAuth2 access token");
                httpOperation.getConnection().setRequestProperty("Authorization", this.client.getAccessToken());
                break;
            }
            case SAS: {
                httpOperation.setMaskForSAS();
                break;
            }
            default: {
                LOG.debug("Signing request with shared key");
                this.client.getSharedKeyCredentials().signRequest(httpOperation.getConnection(), bytesToSign);
            }
        }
    }

    @VisibleForTesting
    AbfsHttpOperation createHttpOperation() throws IOException {
        return new AbfsHttpOperation(this.url, this.method, this.requestHeaders);
    }

    private void incrementCounter(AbfsStatistic statistic, long value) {
        if (this.abfsCounters != null) {
            this.abfsCounters.incrementCounter(statistic, value);
        }
    }

    @VisibleForTesting
    public TracingContext createNewTracingContext(TracingContext tracingContext) {
        return new TracingContext(tracingContext);
    }

    @VisibleForTesting
    public final TracingContext getLastTracingContext() {
        return this.lastUsedTracingContext;
    }
}

