/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.nfs.conf.NfsConfiguration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.net.NetUtils;

class Nfs3HttpServer {
    private int infoPort;
    private int infoSecurePort;
    private HttpServer2 httpServer;
    private final NfsConfiguration conf;

    Nfs3HttpServer(NfsConfiguration conf) {
        this.conf = conf;
    }

    void start() throws IOException {
        InetSocketAddress httpAddr = this.getHttpAddress((Configuration)this.conf);
        String httpsAddrString = this.conf.get("nfs.https.address", "0.0.0.0:50579");
        InetSocketAddress httpsAddr = NetUtils.createSocketAddr((String)httpsAddrString);
        HttpServer2.Builder builder = DFSUtil.httpServerTemplateForNNAndJN((Configuration)this.conf, (InetSocketAddress)httpAddr, (InetSocketAddress)httpsAddr, (String)"nfs3", (String)"nfs.kerberos.principal", (String)"nfs.keytab.file");
        this.httpServer = builder.build();
        this.httpServer.start();
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy((Configuration)this.conf);
        int connIdx = 0;
        if (policy.isHttpEnabled()) {
            this.infoPort = this.httpServer.getConnectorAddress(connIdx++).getPort();
        }
        if (policy.isHttpsEnabled()) {
            this.infoSecurePort = this.httpServer.getConnectorAddress(connIdx).getPort();
        }
    }

    void stop() throws IOException {
        if (this.httpServer != null) {
            try {
                this.httpServer.stop();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public int getPort() {
        return this.infoPort;
    }

    public int getSecurePort() {
        return this.infoSecurePort;
    }

    public URI getServerURI() {
        InetSocketAddress addr = this.httpServer.getConnectorAddress(0);
        return URI.create(DFSUtil.getHttpClientScheme((Configuration)this.conf) + "://" + NetUtils.getHostPortString((InetSocketAddress)addr));
    }

    public InetSocketAddress getHttpAddress(Configuration conf) {
        String addr = conf.get("nfs.http.address", "0.0.0.0:50079");
        return NetUtils.createSocketAddr((String)addr, (int)50079, (String)"nfs.http.address");
    }
}

