/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.persistence;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.CachePersistenceException;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourceType;
import org.ehcache.core.spi.service.DiskResourceService;
import org.ehcache.core.spi.service.FileBasedPersistenceContext;
import org.ehcache.core.spi.service.LocalPersistenceService;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.ehcache.impl.persistence.FileBasedStateRepository;
import org.ehcache.impl.persistence.FileUtils;
import org.ehcache.spi.persistence.PersistableResourceService;
import org.ehcache.spi.persistence.StateRepository;
import org.ehcache.spi.service.MaintainableService;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceDependencies(value={LocalPersistenceService.class})
public class DefaultDiskResourceService
implements DiskResourceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDiskResourceService.class);
    static final String PERSISTENCE_SPACE_OWNER = "file";
    private final ConcurrentMap<String, PersistenceSpace> knownPersistenceSpaces = new ConcurrentHashMap<String, PersistenceSpace>();
    private volatile LocalPersistenceService persistenceService;
    private volatile boolean isStarted;

    private boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public void start(ServiceProvider<Service> serviceProvider) {
        this.innerStart(serviceProvider);
    }

    @Override
    public void startForMaintenance(ServiceProvider<? super MaintainableService> serviceProvider, MaintainableService.MaintenanceScope maintenanceScope) {
        this.innerStart(serviceProvider);
    }

    private void innerStart(ServiceProvider<? super MaintainableService> serviceProvider) {
        this.persistenceService = serviceProvider.getService(LocalPersistenceService.class);
        this.isStarted = true;
    }

    @Override
    public void stop() {
        this.isStarted = false;
        this.persistenceService = null;
    }

    @Override
    public boolean handlesResourceType(ResourceType<?> resourceType) {
        return this.persistenceService != null && ResourceType.Core.DISK.equals(resourceType);
    }

    public PersistableResourceService.PersistenceSpaceIdentifier<DiskResourceService> getPersistenceSpaceIdentifier(String name, CacheConfiguration<?, ?> config) throws CachePersistenceException {
        PersistenceSpace newSpace;
        if (this.persistenceService == null) {
            return null;
        }
        boolean persistent = config.getResourcePools().getPoolForResource(ResourceType.Core.DISK).isPersistent();
        do {
            PersistenceSpace persistenceSpace;
            if ((persistenceSpace = (PersistenceSpace)this.knownPersistenceSpaces.get(name)) == null) continue;
            return persistenceSpace.identifier;
        } while ((newSpace = this.createSpace(name, persistent)) == null);
        return newSpace.identifier;
    }

    @Override
    public void releasePersistenceSpaceIdentifier(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier) throws CachePersistenceException {
        String name = null;
        for (Map.Entry entry : this.knownPersistenceSpaces.entrySet()) {
            if (!((PersistenceSpace)entry.getValue()).identifier.equals(identifier)) continue;
            name = (String)entry.getKey();
        }
        if (name == null) {
            throw this.newCachePersistenceException(identifier);
        }
        PersistenceSpace persistenceSpace = (PersistenceSpace)this.knownPersistenceSpaces.remove(name);
        if (persistenceSpace != null) {
            for (FileBasedStateRepository stateRepository : persistenceSpace.stateRepositories.values()) {
                try {
                    stateRepository.close();
                }
                catch (IOException e) {
                    LOGGER.warn("StateRepository close failed - destroying persistence space {} to prevent corruption", identifier, (Object)e);
                    this.persistenceService.destroySafeSpace(((DefaultPersistenceSpaceIdentifier)identifier).persistentSpaceId, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceSpace createSpace(String name, boolean persistent) throws CachePersistenceException {
        DefaultPersistenceSpaceIdentifier persistenceSpaceIdentifier = new DefaultPersistenceSpaceIdentifier(this.persistenceService.createSafeSpaceIdentifier(PERSISTENCE_SPACE_OWNER, name));
        PersistenceSpace persistenceSpace = new PersistenceSpace(persistenceSpaceIdentifier);
        if (this.knownPersistenceSpaces.putIfAbsent(name, persistenceSpace) == null) {
            boolean created = false;
            try {
                if (!persistent) {
                    this.persistenceService.destroySafeSpace(persistenceSpaceIdentifier.persistentSpaceId, true);
                }
                this.persistenceService.createSafeSpace(persistenceSpaceIdentifier.persistentSpaceId);
                created = true;
            }
            finally {
                if (!created) {
                    this.knownPersistenceSpaces.remove(name, persistenceSpace);
                }
            }
            return persistenceSpace;
        }
        return null;
    }

    private void checkStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException(this.getClass().getName() + " should be started to call destroy");
        }
    }

    @Override
    public void destroy(String name) throws CachePersistenceException {
        this.checkStarted();
        if (this.persistenceService == null) {
            return;
        }
        PersistenceSpace space = (PersistenceSpace)this.knownPersistenceSpaces.remove(name);
        LocalPersistenceService.SafeSpaceIdentifier identifier = space == null ? this.persistenceService.createSafeSpaceIdentifier(PERSISTENCE_SPACE_OWNER, name) : space.identifier.persistentSpaceId;
        this.persistenceService.destroySafeSpace(identifier, true);
    }

    @Override
    public void destroyAll() {
        this.checkStarted();
        if (this.persistenceService == null) {
            return;
        }
        this.persistenceService.destroyAll(PERSISTENCE_SPACE_OWNER);
    }

    @Override
    public StateRepository getStateRepositoryWithin(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier, String name) throws CachePersistenceException {
        PersistenceSpace persistenceSpace = this.getPersistenceSpace(identifier);
        if (persistenceSpace == null) {
            throw this.newCachePersistenceException(identifier);
        }
        FileBasedStateRepository stateRepository = new FileBasedStateRepository(FileUtils.createSubDirectory(persistenceSpace.identifier.persistentSpaceId.getRoot(), name));
        FileBasedStateRepository previous = persistenceSpace.stateRepositories.putIfAbsent(name, stateRepository);
        if (previous != null) {
            return previous;
        }
        return stateRepository;
    }

    private CachePersistenceException newCachePersistenceException(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier) throws CachePersistenceException {
        return new CachePersistenceException("Unknown space: " + identifier);
    }

    private PersistenceSpace getPersistenceSpace(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier) {
        for (PersistenceSpace persistenceSpace : this.knownPersistenceSpaces.values()) {
            if (!persistenceSpace.identifier.equals(identifier)) continue;
            return persistenceSpace;
        }
        return null;
    }

    @Override
    public FileBasedPersistenceContext createPersistenceContextWithin(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier, String name) throws CachePersistenceException {
        if (this.getPersistenceSpace(identifier) == null) {
            throw this.newCachePersistenceException(identifier);
        }
        return new DefaultFileBasedPersistenceContext(FileUtils.createSubDirectory(((DefaultPersistenceSpaceIdentifier)identifier).persistentSpaceId.getRoot(), name));
    }

    private static class DefaultFileBasedPersistenceContext
    implements FileBasedPersistenceContext {
        private final File directory;

        private DefaultFileBasedPersistenceContext(File directory) {
            this.directory = directory;
        }

        @Override
        public File getDirectory() {
            return this.directory;
        }
    }

    private static class DefaultPersistenceSpaceIdentifier
    implements PersistableResourceService.PersistenceSpaceIdentifier<DiskResourceService> {
        final LocalPersistenceService.SafeSpaceIdentifier persistentSpaceId;

        private DefaultPersistenceSpaceIdentifier(LocalPersistenceService.SafeSpaceIdentifier persistentSpaceId) {
            this.persistentSpaceId = persistentSpaceId;
        }

        @Override
        public Class<DiskResourceService> getServiceType() {
            return DiskResourceService.class;
        }

        public String toString() {
            return this.persistentSpaceId.toString();
        }
    }

    private static class PersistenceSpace {
        final DefaultPersistenceSpaceIdentifier identifier;
        final ConcurrentMap<String, FileBasedStateRepository> stateRepositories = new ConcurrentHashMap<String, FileBasedStateRepository>();

        private PersistenceSpace(DefaultPersistenceSpaceIdentifier identifier) {
            this.identifier = identifier;
        }
    }
}

