/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Shell;

public class StatUtils {
    public static Permission getPermissionFromProcess(String filePath) throws Exception {
        String[] shellCommand = Shell.getGetPermissionCommand();
        String sPerm = StatUtils.getPermissionStringFromProcess(shellCommand, filePath);
        StringTokenizer tokenizer = new StringTokenizer(sPerm, Shell.TOKEN_SEPARATOR_REGEX);
        String symbolicPermission = tokenizer.nextToken();
        tokenizer.nextToken();
        String owner = tokenizer.nextToken();
        String group = tokenizer.nextToken();
        if (Shell.WINDOWS) {
            owner = StatUtils.removeDomain(owner);
            group = StatUtils.removeDomain(group);
        }
        Permission permission = new Permission(owner, group, FsPermission.valueOf((String)symbolicPermission));
        return permission;
    }

    public static void setPermissionFromProcess(String chmod, String filePath) throws Exception {
        StatUtils.setPermissionFromProcess(chmod, false, filePath);
    }

    public static void setPermissionFromProcess(String chmod, boolean recursive, String filePath) throws Exception {
        String[] shellCommand = Shell.getSetPermissionCommand((String)chmod, (boolean)recursive);
        StatUtils.getPermissionStringFromProcess(shellCommand, filePath);
    }

    private static String removeDomain(String str) {
        int index = str.indexOf("\\");
        if (index != -1) {
            str = str.substring(index + 1);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPermissionStringFromProcess(String[] shellCommand, String testFilePath) throws Exception {
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(shellCommand));
        cmd.add(testFilePath);
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        Process process = processBuilder.start();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.awaitTermination(2000L, TimeUnit.MILLISECONDS);
        try {
            Future<String> future = executorService.submit(() -> new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8)).lines().findFirst().orElse(""));
            String string = future.get();
            return string;
        }
        finally {
            process.destroy();
            executorService.shutdown();
        }
    }

    public static class Permission {
        private String owner;
        private String group;
        private FsPermission fsPermission;

        public Permission(String owner, String group, FsPermission fsPermission) {
            this.owner = owner;
            this.group = group;
            this.fsPermission = fsPermission;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getGroup() {
            return this.group;
        }

        public FsPermission getFsPermission() {
            return this.fsPermission;
        }
    }
}

