/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.PrintStream;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.tools.DebugAdmin;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDebugAdmin {
    private static final String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp"), TestDebugAdmin.class.getSimpleName()).getAbsolutePath();
    private Configuration conf = new Configuration();
    private MiniDFSCluster cluster;
    private DebugAdmin admin;

    @Before
    public void setUp() throws Exception {
        File testRoot = new File(TEST_ROOT_DIR);
        testRoot.delete();
        testRoot.mkdirs();
        this.admin = new DebugAdmin(this.conf);
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runCmd(String[] cmd) throws Exception {
        int ret;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldErr = System.err;
        PrintStream oldOut = System.out;
        System.setErr(out);
        System.setOut(out);
        try {
            ret = this.admin.run(cmd);
        }
        finally {
            System.setErr(oldErr);
            System.setOut(oldOut);
            IOUtils.closeStream((Closeable)out);
        }
        return "ret: " + ret + ", " + bytes.toString().replaceAll(System.lineSeparator(), "");
    }

    @Test(timeout=60000L)
    public void testRecoverLease() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        Assert.assertEquals((Object)"ret: 1, You must supply a -path argument to recoverLease.", (Object)this.runCmd(new String[]{"recoverLease", "-retries", "1"}));
        DistributedFileSystem fs = this.cluster.getFileSystem();
        FSDataOutputStream out = fs.create(new Path("/foo"));
        out.write(123);
        out.close();
        Assert.assertEquals((Object)"ret: 0, recoverLease SUCCEEDED on /foo", (Object)this.runCmd(new String[]{"recoverLease", "-path", "/foo"}));
    }

    @Test(timeout=60000L)
    public void testVerifyMetaCommand() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        DataNode datanode = this.cluster.getDataNodes().get(0);
        DFSTestUtil.createFile((FileSystem)fs, new Path("/bar"), 1234L, (short)1, -559038737L);
        FsDatasetSpi fsd = datanode.getFSDataset();
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, new Path("/bar"));
        File blockFile = FsDatasetTestUtil.getBlockFile(fsd, block.getBlockPoolId(), block.getLocalBlock());
        Assert.assertEquals((Object)"ret: 1, You must specify a meta file with -meta", (Object)this.runCmd(new String[]{"verifyMeta", "-block", blockFile.getAbsolutePath()}));
        File metaFile = FsDatasetTestUtil.getMetaFile(fsd, block.getBlockPoolId(), block.getLocalBlock());
        Assert.assertEquals((Object)"ret: 0, Checksum type: DataChecksum(type=CRC32C, chunkSize=512)", (Object)this.runCmd(new String[]{"verifyMeta", "-meta", metaFile.getAbsolutePath()}));
        Assert.assertEquals((Object)("ret: 0, Checksum type: DataChecksum(type=CRC32C, chunkSize=512)Checksum verification succeeded on block file " + blockFile.getAbsolutePath()), (Object)this.runCmd(new String[]{"verifyMeta", "-meta", metaFile.getAbsolutePath(), "-block", blockFile.getAbsolutePath()}));
    }

    @Test(timeout=60000L)
    public void testComputeMetaCommand() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        DataNode datanode = this.cluster.getDataNodes().get(0);
        DFSTestUtil.createFile((FileSystem)fs, new Path("/bar"), 1234L, (short)1, -559038737L);
        FsDatasetSpi fsd = datanode.getFSDataset();
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, new Path("/bar"));
        File blockFile = FsDatasetTestUtil.getBlockFile(fsd, block.getBlockPoolId(), block.getLocalBlock());
        Assert.assertEquals((Object)"ret: 1, computeMeta -block <block-file> -out <output-metadata-file>  Compute HDFS metadata from the specified block file, and save it to  the specified output metadata file.**NOTE: Use at your own risk! If the block file is corrupt and you overwrite it's meta file,  it will show up as good in HDFS, but you can't read the data. Only use as a last measure, and when you are 100% certain the block file is good.", (Object)this.runCmd(new String[]{"computeMeta"}));
        Assert.assertEquals((Object)"ret: 2, You must specify a block file with -block", (Object)this.runCmd(new String[]{"computeMeta", "-whatever"}));
        Assert.assertEquals((Object)"ret: 3, Block file <bla> does not exist or is not a file", (Object)this.runCmd(new String[]{"computeMeta", "-block", "bla"}));
        Assert.assertEquals((Object)"ret: 4, You must specify a output file with -out", (Object)this.runCmd(new String[]{"computeMeta", "-block", blockFile.getAbsolutePath()}));
        Assert.assertEquals((Object)"ret: 5, output file already exists!", (Object)this.runCmd(new String[]{"computeMeta", "-block", blockFile.getAbsolutePath(), "-out", blockFile.getAbsolutePath()}));
        File outFile = new File(TEST_ROOT_DIR, "out.meta");
        outFile.delete();
        Assert.assertEquals((Object)("ret: 0, Checksum calculation succeeded on block file " + blockFile.getAbsolutePath() + " saved metadata to meta file " + outFile.getAbsolutePath()), (Object)this.runCmd(new String[]{"computeMeta", "-block", blockFile.getAbsolutePath(), "-out", outFile.getAbsolutePath()}));
        Assert.assertTrue((boolean)outFile.exists());
        Assert.assertTrue((outFile.length() > 0L ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testRecoverLeaseforFileNotFound() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        Assert.assertTrue((boolean)this.runCmd(new String[]{"recoverLease", "-path", "/foo", "-retries", "2"}).contains("Giving up on recoverLease for /foo after 1 try"));
    }

    @Test(timeout=60000L)
    public void testVerifyECCommand() throws Exception {
        ErasureCodingPolicy ecPolicy = SystemErasureCodingPolicies.getByID((byte)2);
        this.cluster = DFSTestUtil.setupCluster(this.conf, 6, 5, 0);
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        Assert.assertEquals((Object)"ret: 1, verifyEC -file <file>  Verify HDFS erasure coding on all block groups of the file.", (Object)this.runCmd(new String[]{"verifyEC"}));
        Assert.assertEquals((Object)"ret: 1, File /bar does not exist.", (Object)this.runCmd(new String[]{"verifyEC", "-file", "/bar"}));
        fs.create(new Path("/bar")).close();
        Assert.assertEquals((Object)"ret: 1, File /bar is not erasure coded.", (Object)this.runCmd(new String[]{"verifyEC", "-file", "/bar"}));
        Path ecDir = new Path("/ec");
        fs.mkdir(ecDir, FsPermission.getDirDefault());
        fs.enableErasureCodingPolicy(ecPolicy.getName());
        fs.setErasureCodingPolicy(ecDir, ecPolicy.getName());
        Assert.assertEquals((Object)"ret: 1, File /ec is not a regular file.", (Object)this.runCmd(new String[]{"verifyEC", "-file", "/ec"}));
        fs.create(new Path(ecDir, "foo"));
        Assert.assertEquals((Object)"ret: 1, File /ec/foo is not closed.", (Object)this.runCmd(new String[]{"verifyEC", "-file", "/ec/foo"}));
        boolean repl = true;
        long k = 1024L;
        long m = 0x100000L;
        long seed = 19088743L;
        DFSTestUtil.createFile((FileSystem)fs, new Path(ecDir, "foo_65535"), 65535L, (short)1, 19088743L);
        Assert.assertTrue((boolean)this.runCmd(new String[]{"verifyEC", "-file", "/ec/foo_65535"}).contains("All EC block group status: OK"));
        DFSTestUtil.createFile((FileSystem)fs, new Path(ecDir, "foo_256k"), 262144L, (short)1, 19088743L);
        Assert.assertTrue((boolean)this.runCmd(new String[]{"verifyEC", "-file", "/ec/foo_256k"}).contains("All EC block group status: OK"));
        DFSTestUtil.createFile((FileSystem)fs, new Path(ecDir, "foo_1m"), 0x100000L, (short)1, 19088743L);
        Assert.assertTrue((boolean)this.runCmd(new String[]{"verifyEC", "-file", "/ec/foo_1m"}).contains("All EC block group status: OK"));
        DFSTestUtil.createFile((FileSystem)fs, new Path(ecDir, "foo_2m"), 0x200000L, (short)1, 19088743L);
        Assert.assertTrue((boolean)this.runCmd(new String[]{"verifyEC", "-file", "/ec/foo_2m"}).contains("All EC block group status: OK"));
        DFSTestUtil.createFile((FileSystem)fs, new Path(ecDir, "foo_3m"), 0x300000L, (short)1, 19088743L);
        Assert.assertTrue((boolean)this.runCmd(new String[]{"verifyEC", "-file", "/ec/foo_3m"}).contains("All EC block group status: OK"));
        DFSTestUtil.createFile((FileSystem)fs, new Path(ecDir, "foo_5m"), 0x500000L, (short)1, 19088743L);
        Assert.assertTrue((boolean)this.runCmd(new String[]{"verifyEC", "-file", "/ec/foo_5m"}).contains("All EC block group status: OK"));
        DFSTestUtil.createFile((FileSystem)fs, new Path(ecDir, "foo_6m"), 1024, 0x600000L, 0x100000L, (short)1, 19088743L);
        Assert.assertEquals((Object)"ret: 0, Checking EC block group: blk_x;Status: OKChecking EC block group: blk_x;Status: OKAll EC block group status: OK", (Object)this.runCmd(new String[]{"verifyEC", "-file", "/ec/foo_6m"}).replaceAll("blk_-[0-9]+", "blk_x;"));
        Path corruptFile = new Path(ecDir, "foo_corrupt");
        DFSTestUtil.createFile((FileSystem)fs, corruptFile, 5841961L, (short)1, 19088743L);
        List<LocatedBlock> blocks = DFSTestUtil.getAllBlocks((FileSystem)fs, corruptFile);
        Assert.assertEquals((long)1L, (long)blocks.size());
        LocatedStripedBlock blockGroup = (LocatedStripedBlock)blocks.get(0);
        LocatedBlock[] indexedBlocks = StripedBlockUtil.parseStripedBlockGroup((LocatedStripedBlock)blockGroup, (int)ecPolicy.getCellSize(), (int)ecPolicy.getNumDataUnits(), (int)ecPolicy.getNumParityUnits());
        LocatedBlock toCorruptLocatedBlock = indexedBlocks[0];
        ExtendedBlock toCorruptBlock = toCorruptLocatedBlock.getBlock();
        DataNode datanode = this.cluster.getDataNode(toCorruptLocatedBlock.getLocations()[0].getIpcPort());
        File blockFile = FsDatasetTestUtil.getBlockFile(datanode.getFSDataset(), toCorruptBlock.getBlockPoolId(), toCorruptBlock.getLocalBlock());
        File metaFile = FsDatasetTestUtil.getMetaFile(datanode.getFSDataset(), toCorruptBlock.getBlockPoolId(), toCorruptBlock.getLocalBlock());
        byte[] errorBytes = new byte[0x200000];
        new Random(19088743L).nextBytes(errorBytes);
        FileUtils.writeByteArrayToFile((File)blockFile, (byte[])errorBytes);
        metaFile.delete();
        this.runCmd(new String[]{"computeMeta", "-block", blockFile.getAbsolutePath(), "-out", metaFile.getAbsolutePath()});
        Assert.assertTrue((boolean)this.runCmd(new String[]{"verifyEC", "-file", "/ec/foo_corrupt"}).contains("Status: ERROR, message: EC compute result not match."));
    }
}

