/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.metrics.FederationRPCMetrics;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClientProtocol;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.TestRouterRpc;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.Whitebox;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestRouterRpcMultiDestination
extends TestRouterRpc {
    @Override
    public void testSetup() throws Exception {
        MockResolver resolver;
        Router router;
        MiniRouterDFSCluster cluster = this.getCluster();
        this.getCluster().installMockLocations();
        List<MiniRouterDFSCluster.RouterContext> routers = cluster.getRouters();
        for (MiniRouterDFSCluster.RouterContext rc : routers) {
            router = rc.getRouter();
            resolver = (MockResolver)router.getSubclusterResolver();
            resolver.addLocation("/", cluster.getNameservices().get(1), "/");
        }
        for (MiniRouterDFSCluster.RouterContext rc : routers) {
            router = rc.getRouter();
            resolver = (MockResolver)router.getSubclusterResolver();
            List<String> nss = cluster.getNameservices();
            String ns0 = nss.get(0);
            resolver.addLocation("/same", ns0, "/");
            resolver.addLocation("/same", ns0, cluster.getNamenodePathForNS(ns0));
        }
        cluster.deleteAllFiles();
        cluster.createTestDirectoriesNamenode();
        Thread.sleep(100L);
        MiniRouterDFSCluster.RouterContext router2 = cluster.getRandomRouter();
        this.setRouter(router2);
        String ns = cluster.getRandomNameservice();
        this.setNs(ns);
        this.setNamenode(cluster.getNamenode(ns, null));
        Random r = new Random();
        String randomString = "testfile-" + r.nextInt();
        this.setNamenodeFile("/" + randomString);
        this.setRouterFile("/" + randomString);
        FileSystem nnFs = this.getNamenodeFileSystem();
        FileSystem routerFs = this.getRouterFileSystem();
        FederationTestUtils.createFile(nnFs, this.getNamenodeFile(), 32L);
        FederationTestUtils.verifyFileExists(nnFs, this.getNamenodeFile());
        FederationTestUtils.verifyFileExists(routerFs, this.getRouterFile());
    }

    private void testListing(String path) throws IOException {
        TreeSet<String> requiredPaths = new TreeSet<String>();
        MiniRouterDFSCluster.RouterContext rc = this.getRouterContext();
        Router router = rc.getRouter();
        FileSubclusterResolver subclusterResolver = router.getSubclusterResolver();
        List mountList = subclusterResolver.getMountPoints(path);
        if (mountList != null) {
            requiredPaths.addAll(mountList);
        }
        PathLocation location = subclusterResolver.getDestinationForPath(path);
        for (RemoteLocation loc : location.getDestinations()) {
            FileStatus[] files;
            String nsId = loc.getNameserviceId();
            String dest = loc.getDest();
            MiniRouterDFSCluster.NamenodeContext nn = this.getCluster().getNamenode(nsId, null);
            FileSystem fs = nn.getFileSystem();
            for (FileStatus file : files = fs.listStatus(new Path(dest))) {
                String pathName = file.getPath().getName();
                requiredPaths.add(pathName);
            }
        }
        DirectoryListing listing = this.getRouterProtocol().getListing(path, HdfsFileStatus.EMPTY_NAME, false);
        Iterator requiredPathsIterator = requiredPaths.iterator();
        Object[] partialListing = listing.getPartialListing();
        for (HdfsFileStatus fileStatus : listing.getPartialListing()) {
            String fileName = (String)requiredPathsIterator.next();
            String currentFile = fileStatus.getFullPath(new Path(path)).getName();
            Assert.assertEquals((Object)currentFile, (Object)fileName);
        }
        Assert.assertEquals((String)(requiredPaths + " doesn't match " + Arrays.toString(partialListing)), (long)requiredPaths.size(), (long)partialListing.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxyOpWithRemoteException() throws IOException {
        String testPath = "/proxy_op/remote_exception.txt";
        FederationRPCMetrics metrics = this.getRouterContext().getRouter().getRpcServer().getRPCMetrics();
        String ns1 = this.getCluster().getNameservices().get(1);
        FileSystem fileSystem1 = this.getCluster().getNamenode(ns1, null).getFileSystem();
        try {
            FederationTestUtils.createFile(fileSystem1, "/proxy_op/remote_exception.txt", 32L);
            long beforeProxyOp = metrics.getProxyOps();
            this.getRouterProtocol().getBlockLocations("/proxy_op/remote_exception.txt", 0L, 1L);
            Assert.assertEquals((long)2L, (long)(metrics.getProxyOps() - beforeProxyOp));
        }
        finally {
            fileSystem1.delete(new Path("/proxy_op/remote_exception.txt"), true);
        }
    }

    @Override
    public void testProxyListFiles() throws IOException, InterruptedException, URISyntaxException, NoSuchMethodException, SecurityException {
        this.testListing("/");
        this.testListing("/same");
        ClientProtocol namenodeProtocol = this.getCluster().getRandomNamenode().getClient().getNamenode();
        Method m = ClientProtocol.class.getMethod("getListing", String.class, byte[].class, Boolean.TYPE);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpcMultiDestination.compareResponses(this.getRouterProtocol(), namenodeProtocol, m, new Object[]{badPath, HdfsFileStatus.EMPTY_NAME, false});
    }

    @Override
    public void testProxyRenameFiles() throws IOException, InterruptedException {
        super.testProxyRenameFiles();
        List<String> nss = this.getCluster().getNameservices();
        String ns0 = nss.get(0);
        String ns1 = nss.get(1);
        String testDir0 = this.getCluster().getFederatedTestDirectoryForNS(ns0);
        String filename0 = testDir0 + "/testrename";
        String renamedFile = "/testrename";
        this.testRename(this.getRouterContext(), filename0, renamedFile, false);
        this.testRename2(this.getRouterContext(), filename0, renamedFile, false);
        String testDir1 = this.getCluster().getFederatedTestDirectoryForNS(ns1);
        String filename1 = testDir1 + "/testrename";
        this.testRename(this.getRouterContext(), filename1, renamedFile, false);
        this.testRename2(this.getRouterContext(), filename1, renamedFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreviousBlockNotNull() throws IOException, URISyntaxException {
        FederationRPCMetrics metrics = this.getRouterContext().getRouter().getRpcServer().getRPCMetrics();
        ClientProtocol clientProtocol = this.getRouterProtocol();
        EnumSet<CreateFlag> createFlag = EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE);
        String clientName = this.getRouterContext().getClient().getClientName();
        String testPath = "/getAdditionalData/test.txt";
        String ns1 = this.getCluster().getNameservices().get(1);
        FileSystem fileSystem1 = this.getCluster().getNamenode(ns1, null).getFileSystem();
        try {
            FederationTestUtils.createFile(fileSystem1, "/getAdditionalData/test.txt", 32L);
            HdfsFileStatus status = clientProtocol.create("/getAdditionalData/test.txt", new FsPermission("777"), clientName, new EnumSetWritable(createFlag), true, (short)1, 1024L, CryptoProtocolVersion.supported(), null, null);
            long proxyNumCreate = metrics.getProcessingOps();
            LocatedBlock blockOne = clientProtocol.addBlock("/getAdditionalData/test.txt", clientName, null, null, status.getFileId(), null, null);
            Assert.assertNotNull((Object)blockOne);
            long proxyNumAddBlock = metrics.getProcessingOps();
            Assert.assertEquals((long)2L, (long)(proxyNumAddBlock - proxyNumCreate));
            LocatedBlock blockTwo = clientProtocol.addBlock("/getAdditionalData/test.txt", clientName, blockOne.getBlock(), null, status.getFileId(), null, null);
            Assert.assertNotNull((Object)blockTwo);
            long proxyNumAddBlock2 = metrics.getProcessingOps();
            Assert.assertEquals((long)1L, (long)(proxyNumAddBlock2 - proxyNumAddBlock));
            DatanodeInfo[] exclusions = DatanodeInfo.EMPTY_ARRAY;
            LocatedBlock newBlock = clientProtocol.getAdditionalDatanode("/getAdditionalData/test.txt", status.getFileId(), blockTwo.getBlock(), (DatanodeInfo[])blockTwo.getLocations(), blockTwo.getStorageIDs(), exclusions, 1, clientName);
            Assert.assertNotNull((Object)newBlock);
            long proxyNumAdditionalDatanode = metrics.getProcessingOps();
            Assert.assertEquals((long)1L, (long)(proxyNumAdditionalDatanode - proxyNumAddBlock2));
            clientProtocol.complete("/getAdditionalData/test.txt", clientName, newBlock.getBlock(), status.getFileId());
            long proxyNumComplete = metrics.getProcessingOps();
            Assert.assertEquals((long)1L, (long)(proxyNumComplete - proxyNumAdditionalDatanode));
        }
        finally {
            clientProtocol.delete("/getAdditionalData/test.txt", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoverLease() throws Exception {
        Path testPath = new Path("/recovery/test_recovery_lease");
        DistributedFileSystem routerFs = (DistributedFileSystem)this.getRouterFileSystem();
        FSDataOutputStream fsDataOutputStream = null;
        try {
            fsDataOutputStream = routerFs.create(testPath);
            fsDataOutputStream.write("hello world".getBytes());
            fsDataOutputStream.hflush();
            boolean result = routerFs.recoverLease(testPath);
            Assert.assertFalse((boolean)result);
        }
        finally {
            IOUtils.closeStream((Closeable)fsDataOutputStream);
            routerFs.delete(testPath, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsFileClosed() throws Exception {
        Path testPath = new Path("/is_file_closed.txt");
        DistributedFileSystem routerFs = (DistributedFileSystem)this.getRouterFileSystem();
        FSDataOutputStream fsDataOutputStream = null;
        try {
            fsDataOutputStream = routerFs.create(testPath);
            fsDataOutputStream.write("hello world".getBytes());
            fsDataOutputStream.hflush();
            boolean result = routerFs.isFileClosed(testPath);
            Assert.assertFalse((boolean)result);
        }
        finally {
            IOUtils.closeStream((Closeable)fsDataOutputStream);
            routerFs.delete(testPath, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetContentSummaryEc() throws Exception {
        DistributedFileSystem routerDFS = (DistributedFileSystem)this.getRouterFileSystem();
        Path dir = new Path("/");
        String expectedECPolicy = "RS-6-3-1024k";
        try {
            routerDFS.setErasureCodingPolicy(dir, expectedECPolicy);
            Assert.assertEquals((Object)expectedECPolicy, (Object)routerDFS.getContentSummary(dir).getErasureCodingPolicy());
        }
        finally {
            routerDFS.unsetErasureCodingPolicy(dir);
        }
    }

    @Test
    public void testSubclusterDown() throws Exception {
        int totalFiles = 6;
        List<MiniRouterDFSCluster.RouterContext> routers = this.getCluster().getRouters();
        FileSystem fs = this.getRouterFileSystem();
        FileStatus[] files = fs.listStatus(new Path("/"));
        Assert.assertEquals((long)6L, (long)files.length);
        NameNode nn0 = this.getCluster().getNamenode("ns0", null).getNamenode();
        FSNamesystem ns0 = nn0.getNamesystem();
        HAContext nn0haCtx = (HAContext)Whitebox.getInternalState((Object)ns0, (String)"haContext");
        HAContext mockCtx = (HAContext)Mockito.mock(HAContext.class);
        ((HAContext)Mockito.doThrow((Throwable[])new Throwable[]{new StandbyException("Mock")}).when((Object)mockCtx)).checkOperation((NameNode.OperationCategory)Matchers.any());
        Whitebox.setInternalState((Object)ns0, (String)"haContext", (Object)mockCtx);
        MiniRouterDFSCluster.RouterContext router0 = routers.get(0);
        RouterRpcServer router0RPCServer = router0.getRouter().getRpcServer();
        RouterClientProtocol router0ClientProtocol = router0RPCServer.getClientProtocolModule();
        Whitebox.setInternalState((Object)router0ClientProtocol, (String)"allowPartialList", (Object)false);
        try {
            router0.getFileSystem().listStatus(new Path("/"));
            Assert.fail((String)"I should throw an exception");
        }
        catch (RemoteException re) {
            GenericTestUtils.assertExceptionContains((String)"No namenode available to invoke getListing", (Throwable)re);
        }
        MiniRouterDFSCluster.RouterContext router1 = routers.get(1);
        files = router1.getFileSystem().listStatus(new Path("/"));
        Assert.assertTrue((String)("Found " + files.length + " items, we should have less"), (files.length < 6 ? 1 : 0) != 0);
        Whitebox.setInternalState((Object)ns0, (String)"haContext", (Object)nn0haCtx);
        Whitebox.setInternalState((Object)router0ClientProtocol, (String)"allowPartialList", (Object)true);
    }

    @Test
    public void testCallerContextWithMultiDestinations() throws IOException {
        GenericTestUtils.LogCapturer auditLog = GenericTestUtils.LogCapturer.captureLogs((Log)FSNamesystem.auditLog);
        CallerContext.setCurrent((CallerContext)new CallerContext.Builder("clientContext").build());
        Assert.assertEquals((Object)"clientContext", (Object)CallerContext.getCurrent().getContext());
        DistributedFileSystem routerFs = (DistributedFileSystem)this.getRouterFileSystem();
        Path dirPath = new Path("/test_caller_context_with_multi_destinations");
        routerFs.mkdirs(dirPath);
        routerFs.listStatus(dirPath);
        routerFs.getFileStatus(dirPath);
        String auditFlag = "src=" + dirPath.toString();
        String clientIpInfo = "clientIp:" + InetAddress.getLocalHost().getHostAddress();
        for (String line : auditLog.getOutput().split("\n")) {
            if (!line.contains(auditFlag)) continue;
            String callerContext = line.substring(line.indexOf("callerContext="));
            Assert.assertTrue((boolean)callerContext.contains("clientContext"));
            Assert.assertTrue((boolean)callerContext.contains(clientIpInfo));
            Assert.assertEquals((long)callerContext.indexOf(clientIpInfo), (long)callerContext.lastIndexOf(clientIpInfo));
        }
        CallerContext.setCurrent(null);
    }
}

