/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.util.GenericsUtil;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMErrorsAndWarningsPage;
import org.apache.hadoop.yarn.util.Log4jWarningErrorMetricsAppender;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class NavBlock
extends HtmlBlock
implements YarnWebParams {
    private Configuration conf;

    @Inject
    public NavBlock(Configuration conf) {
        this.conf = conf;
    }

    protected void render(HtmlBlock.Block html) {
        Log4jWarningErrorMetricsAppender appender;
        boolean addErrorsAndWarningsLink = false;
        if (GenericsUtil.isLog4jLogger(NMErrorsAndWarningsPage.class) && (appender = Log4jWarningErrorMetricsAppender.findAppender()) != null) {
            addErrorsAndWarningsLink = true;
        }
        String RMWebAppURL = WebAppUtils.getResolvedRMWebAppURLWithScheme((Configuration)this.conf);
        Hamlet.UL ul = (Hamlet.UL)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)((Hamlet.DIV)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.UL)((Hamlet.DIV)html.div("#nav").h3().__(new Object[]{"ResourceManager"}).__()).ul().li().a(RMWebAppURL, "RM Home").__()).__()).h3().__(new Object[]{"NodeManager"}).__()).ul().li().a(this.url(new String[]{"node"}), "Node Information").__()).li().a(this.url(new String[]{"allApplications"}), "List of Applications").__()).li().a(this.url(new String[]{"allContainers"}), "List of Containers").__()).__()).h3("Tools").ul().li().a("/conf", "Configuration").__()).li().a("/logs", "Local logs").__()).li().a("/stacks", "Server stacks").__()).li().a("/jmx?qry=Hadoop:*", "Server metrics").__();
        if (addErrorsAndWarningsLink) {
            ul.li().a(this.url(new String[]{"errors-and-warnings"}), "Errors/Warnings").__();
        }
        ((Hamlet.DIV)ul.__()).__();
    }
}

