/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.component;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.service.ContainerFailureTracker;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.ServiceEvent;
import org.apache.hadoop.yarn.service.ServiceEventType;
import org.apache.hadoop.yarn.service.ServiceMetrics;
import org.apache.hadoop.yarn.service.ServiceScheduler;
import org.apache.hadoop.yarn.service.api.ServiceApiConstants;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.api.records.PlacementConstraint;
import org.apache.hadoop.yarn.service.api.records.PlacementPolicy;
import org.apache.hadoop.yarn.service.api.records.ResourceInformation;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.component.AlwaysRestartPolicy;
import org.apache.hadoop.yarn.service.component.ComponentEvent;
import org.apache.hadoop.yarn.service.component.ComponentEventType;
import org.apache.hadoop.yarn.service.component.ComponentRestartPolicy;
import org.apache.hadoop.yarn.service.component.ComponentState;
import org.apache.hadoop.yarn.service.component.NeverRestartPolicy;
import org.apache.hadoop.yarn.service.component.OnFailureRestartPolicy;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEvent;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEventType;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceId;
import org.apache.hadoop.yarn.service.conf.YarnServiceConf;
import org.apache.hadoop.yarn.service.containerlaunch.ContainerLaunchService;
import org.apache.hadoop.yarn.service.monitor.ComponentHealthThresholdMonitor;
import org.apache.hadoop.yarn.service.monitor.probe.MonitorUtils;
import org.apache.hadoop.yarn.service.monitor.probe.Probe;
import org.apache.hadoop.yarn.service.provider.ProviderService;
import org.apache.hadoop.yarn.service.provider.ProviderUtils;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Apps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Component
implements EventHandler<ComponentEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(Component.class);
    private org.apache.hadoop.yarn.service.api.records.Component componentSpec;
    private long allocateId;
    private Priority priority;
    private ServiceMetrics componentMetrics;
    private ServiceScheduler scheduler;
    private ServiceContext context;
    private AMRMClientAsync<AMRMClient.ContainerRequest> amrmClient;
    private AtomicLong instanceIdCounter = new AtomicLong();
    private Map<String, ComponentInstance> compInstances = new ConcurrentHashMap<String, ComponentInstance>();
    private List<ComponentInstance> pendingInstances = Collections.synchronizedList(new LinkedList());
    private ContainerFailureTracker failureTracker;
    private Probe probe;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    public int maxContainerFailurePerComp;
    public AtomicInteger currentContainerFailure = new AtomicInteger(0);
    private Map<String, ComponentInstance> succeededInstances = new ConcurrentHashMap<String, ComponentInstance>();
    private Map<String, ComponentInstance> failedInstances = new ConcurrentHashMap<String, ComponentInstance>();
    private boolean healthThresholdMonitorEnabled = false;
    private UpgradeStatus upgradeStatus = new UpgradeStatus();
    private UpgradeStatus cancelUpgradeStatus = new UpgradeStatus();
    private StateMachine<ComponentState, ComponentEventType, ComponentEvent> stateMachine;
    private AsyncDispatcher dispatcher;
    private static final StateMachineFactory<Component, ComponentState, ComponentEventType, ComponentEvent> stateMachineFactory = new StateMachineFactory((Enum)ComponentState.INIT).addTransition((Enum)ComponentState.INIT, EnumSet.of(ComponentState.STABLE, ComponentState.FLEXING, ComponentState.INIT), (Enum)ComponentEventType.FLEX, (MultipleArcTransition)new FlexComponentTransition()).addTransition((Enum)ComponentState.INIT, (Enum)ComponentState.INIT, (Enum)ComponentEventType.CONTAINER_RECOVERED, (SingleArcTransition)new ContainerRecoveredTransition()).addTransition((Enum)ComponentState.INIT, (Enum)ComponentState.INIT, (Enum)ComponentEventType.DECOMMISSION_INSTANCE, (SingleArcTransition)new DecommissionInstanceTransition()).addTransition((Enum)ComponentState.FLEXING, (Enum)ComponentState.FLEXING, (Enum)ComponentEventType.CONTAINER_RECOVERED, (SingleArcTransition)new ContainerRecoveredTransition()).addTransition((Enum)ComponentState.FLEXING, (Enum)ComponentState.FLEXING, (Enum)ComponentEventType.CONTAINER_ALLOCATED, (SingleArcTransition)new ContainerAllocatedTransition()).addTransition((Enum)ComponentState.FLEXING, EnumSet.of(ComponentState.STABLE, ComponentState.FLEXING, ComponentState.UPGRADING), (Enum)ComponentEventType.CONTAINER_STARTED, (MultipleArcTransition)new ContainerStartedTransition()).addTransition((Enum)ComponentState.FLEXING, (Enum)ComponentState.FLEXING, (Enum)ComponentEventType.CONTAINER_COMPLETED, (SingleArcTransition)new ContainerCompletedTransition()).addTransition((Enum)ComponentState.FLEXING, EnumSet.of(ComponentState.FLEXING, ComponentState.STABLE), (Enum)ComponentEventType.FLEX, (MultipleArcTransition)new FlexComponentTransition()).addTransition((Enum)ComponentState.FLEXING, EnumSet.of(ComponentState.UPGRADING, ComponentState.FLEXING, ComponentState.STABLE), (Enum)ComponentEventType.CHECK_STABLE, (MultipleArcTransition)new CheckStableTransition()).addTransition((Enum)ComponentState.FLEXING, (Enum)ComponentState.FLEXING, (Enum)ComponentEventType.DECOMMISSION_INSTANCE, (SingleArcTransition)new DecommissionInstanceTransition()).addTransition((Enum)ComponentState.STABLE, (Enum)ComponentState.FLEXING, (Enum)ComponentEventType.CONTAINER_COMPLETED, (SingleArcTransition)new ContainerCompletedTransition()).addTransition((Enum)ComponentState.STABLE, (Enum)ComponentState.STABLE, (Enum)ComponentEventType.CONTAINER_ALLOCATED, (SingleArcTransition)new ContainerAllocatedTransition()).addTransition((Enum)ComponentState.STABLE, EnumSet.of(ComponentState.STABLE, ComponentState.FLEXING), (Enum)ComponentEventType.FLEX, (MultipleArcTransition)new FlexComponentTransition()).addTransition((Enum)ComponentState.STABLE, (Enum)ComponentState.STABLE, (Enum)ComponentEventType.DECOMMISSION_INSTANCE, (SingleArcTransition)new DecommissionInstanceTransition()).addTransition((Enum)ComponentState.STABLE, (Enum)ComponentState.UPGRADING, (Enum)ComponentEventType.UPGRADE, (SingleArcTransition)new NeedsUpgradeTransition()).addTransition((Enum)ComponentState.STABLE, (Enum)ComponentState.CANCEL_UPGRADING, (Enum)ComponentEventType.CANCEL_UPGRADE, (SingleArcTransition)new NeedsUpgradeTransition()).addTransition((Enum)ComponentState.STABLE, EnumSet.of(ComponentState.STABLE, ComponentState.FLEXING), (Enum)ComponentEventType.CHECK_STABLE, (MultipleArcTransition)new CheckStableTransition()).addTransition((Enum)ComponentState.UPGRADING, (Enum)ComponentState.CANCEL_UPGRADING, (Enum)ComponentEventType.CANCEL_UPGRADE, (SingleArcTransition)new NeedsUpgradeTransition()).addTransition((Enum)ComponentState.UPGRADING, EnumSet.of(ComponentState.UPGRADING, ComponentState.FLEXING, ComponentState.STABLE), (Enum)ComponentEventType.CHECK_STABLE, (MultipleArcTransition)new CheckStableTransition()).addTransition((Enum)ComponentState.UPGRADING, (Enum)ComponentState.UPGRADING, (Enum)ComponentEventType.CONTAINER_COMPLETED, (SingleArcTransition)new CompletedAfterUpgradeTransition()).addTransition((Enum)ComponentState.UPGRADING, (Enum)ComponentState.UPGRADING, (Enum)ComponentEventType.DECOMMISSION_INSTANCE, (SingleArcTransition)new DecommissionInstanceTransition()).addTransition((Enum)ComponentState.CANCEL_UPGRADING, EnumSet.of(ComponentState.CANCEL_UPGRADING, ComponentState.FLEXING, ComponentState.STABLE), (Enum)ComponentEventType.CHECK_STABLE, (MultipleArcTransition)new CheckStableTransition()).addTransition((Enum)ComponentState.CANCEL_UPGRADING, (Enum)ComponentState.CANCEL_UPGRADING, (Enum)ComponentEventType.CONTAINER_COMPLETED, (SingleArcTransition)new CompletedAfterUpgradeTransition()).addTransition((Enum)ComponentState.CANCEL_UPGRADING, (Enum)ComponentState.FLEXING, (Enum)ComponentEventType.CONTAINER_ALLOCATED, (SingleArcTransition)new ContainerAllocatedTransition()).addTransition((Enum)ComponentState.CANCEL_UPGRADING, (Enum)ComponentState.CANCEL_UPGRADING, (Enum)ComponentEventType.DECOMMISSION_INSTANCE, (SingleArcTransition)new DecommissionInstanceTransition()).installTopology();

    public Component(org.apache.hadoop.yarn.service.api.records.Component component, long allocateId, ServiceContext context) {
        this.allocateId = allocateId;
        this.priority = Priority.newInstance((int)((int)allocateId));
        this.componentSpec = component;
        this.componentMetrics = ServiceMetrics.register(component.getName(), "Metrics for component " + component.getName());
        this.componentMetrics.tag("type", "Metrics type [component or service]", "component");
        this.scheduler = context.scheduler;
        this.context = context;
        this.amrmClient = this.scheduler.getAmRMClient();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
        this.dispatcher = this.scheduler.getDispatcher();
        this.failureTracker = new ContainerFailureTracker(context, this);
        if (this.componentSpec.getReadinessCheck() != null || YarnServiceConf.getBoolean("yarn.service.default-readiness-check.enabled", true, this.componentSpec.getConfiguration(), this.scheduler.getConfig())) {
            this.probe = MonitorUtils.getProbe(this.componentSpec.getReadinessCheck());
        }
        this.maxContainerFailurePerComp = YarnServiceConf.getInt("yarn.service.container-failure-per-component.threshold", 10, this.componentSpec.getConfiguration(), this.scheduler.getConfig());
        this.createNumCompInstances(component.getNumberOfContainers());
        this.setDesiredContainers(component.getNumberOfContainers().intValue());
        this.checkAndScheduleHealthThresholdMonitor();
    }

    private void createNumCompInstances(long count) {
        int i = 0;
        while ((long)i < count) {
            this.createOneCompInstance();
            ++i;
        }
    }

    private void createOneCompInstance() {
        ComponentInstanceId id = new ComponentInstanceId(this.instanceIdCounter.getAndIncrement(), this.componentSpec.getName());
        while (this.componentSpec.getDecommissionedInstances().contains(id.getCompInstanceName())) {
            id = new ComponentInstanceId(this.instanceIdCounter.getAndIncrement(), this.componentSpec.getName());
        }
        ComponentInstance instance = new ComponentInstance(this, id);
        this.compInstances.put(instance.getCompInstanceName(), instance);
        this.pendingInstances.add(instance);
    }

    private void checkAndScheduleHealthThresholdMonitor() {
        int healthThresholdPercent = YarnServiceConf.getInt("yarn.service.container-health-threshold.percent", -1, this.componentSpec.getConfiguration(), this.scheduler.getConfig());
        if (healthThresholdPercent == -1) {
            LOG.info("No health threshold monitor enabled for component {}", (Object)this.componentSpec.getName());
            return;
        }
        if (healthThresholdPercent <= 0 || healthThresholdPercent > 100) {
            LOG.error("Invalid health threshold percent {}% for component {}. Monitor not enabled.", (Object)healthThresholdPercent, (Object)this.componentSpec.getName());
            return;
        }
        long window = YarnServiceConf.getLong("yarn.service.container-health-threshold.window-secs", 600L, this.componentSpec.getConfiguration(), this.scheduler.getConfig());
        long initDelay = YarnServiceConf.getLong("yarn.service.container-health-threshold.init-delay-secs", 600L, this.componentSpec.getConfiguration(), this.scheduler.getConfig());
        long pollFrequency = YarnServiceConf.getLong("yarn.service.container-health-threshold.poll-frequency-secs", 10L, this.componentSpec.getConfiguration(), this.scheduler.getConfig());
        if (window <= 0L) {
            LOG.error("Invalid health monitor window {} secs for component {}. Monitor not enabled.", (Object)window, (Object)this.componentSpec.getName());
            return;
        }
        if (initDelay < 0L) {
            LOG.error("Invalid health monitor init delay {} secs for component {}. Monitor not enabled.", (Object)initDelay, (Object)this.componentSpec.getName());
            return;
        }
        if (pollFrequency <= 0L) {
            LOG.error("Invalid health monitor poll frequency {} secs for component {}. Monitor not enabled.", (Object)pollFrequency, (Object)this.componentSpec.getName());
            return;
        }
        LOG.info("Scheduling the health threshold monitor for component {} with percent = {}%, window = {} secs, poll freq = {} secs, init-delay = {} secs", new Object[]{this.componentSpec.getName(), healthThresholdPercent, window, pollFrequency, initDelay});
        this.scheduler.executorService.scheduleAtFixedRate(new ComponentHealthThresholdMonitor(this, healthThresholdPercent, window), initDelay + 3L, pollFrequency, TimeUnit.SECONDS);
        this.setHealthThresholdMonitorEnabled(true);
    }

    @VisibleForTesting
    static ComponentState checkIfStable(Component component) {
        if (component.getRestartPolicyHandler().isLongLived()) {
            return Component.updateStateForLongRunningComponents(component);
        }
        return Component.updateStateForTerminatingComponents(component);
    }

    private static ComponentState updateStateForTerminatingComponents(Component component) {
        if ((long)component.getNumRunningInstances() + component.getNumSucceededInstances() + component.getNumFailedInstances() < component.getComponentSpec().getNumberOfContainers()) {
            component.setComponentState(org.apache.hadoop.yarn.service.api.records.ComponentState.FLEXING);
            return ComponentState.FLEXING;
        }
        component.setComponentState(org.apache.hadoop.yarn.service.api.records.ComponentState.STABLE);
        return ComponentState.STABLE;
    }

    private static ComponentState updateStateForLongRunningComponents(Component component) {
        if ((long)component.componentMetrics.containersReady.value() == component.getComponentSpec().getNumberOfContainers() && !component.doesNeedUpgrade()) {
            component.setComponentState(org.apache.hadoop.yarn.service.api.records.ComponentState.STABLE);
            return ComponentState.STABLE;
        }
        if (component.doesNeedUpgrade()) {
            component.setComponentState(org.apache.hadoop.yarn.service.api.records.ComponentState.NEEDS_UPGRADE);
            return component.getState();
        }
        if ((long)component.componentMetrics.containersReady.value() != component.getComponentSpec().getNumberOfContainers()) {
            component.setComponentState(org.apache.hadoop.yarn.service.api.records.ComponentState.FLEXING);
            return ComponentState.FLEXING;
        }
        return component.getState();
    }

    private static synchronized void checkAndUpdateComponentState(Component component, boolean isIncrement) {
        if (component.getRestartPolicyHandler().isLongLived()) {
            if (isIncrement) {
                if (!component.upgradeStatus.areContainersUpgrading() && !component.cancelUpgradeStatus.areContainersUpgrading() && component.componentMetrics.containersReady.value() == component.componentMetrics.containersDesired.value()) {
                    component.setComponentState(org.apache.hadoop.yarn.service.api.records.ComponentState.STABLE);
                    component.context.getServiceManager().checkAndUpdateServiceState();
                }
            } else {
                if (component.componentMetrics.containersReady.value() < component.componentMetrics.containersDesired.value()) {
                    component.setComponentState(org.apache.hadoop.yarn.service.api.records.ComponentState.FLEXING);
                } else if (component.componentMetrics.containersReady.value() == component.componentMetrics.containersDesired.value()) {
                    component.setComponentState(org.apache.hadoop.yarn.service.api.records.ComponentState.STABLE);
                }
                component.context.getServiceManager().checkAndUpdateServiceState();
            }
        } else {
            component.context.getServiceManager().checkAndUpdateServiceState();
        }
        component.dispatcher.getEventHandler().handle((Event)new ComponentEvent(component.getName(), ComponentEventType.CHECK_STABLE));
    }

    public void removePendingInstance(ComponentInstance instance) {
        this.pendingInstances.remove(instance);
    }

    public void reInsertPendingInstance(ComponentInstance instance) {
        this.pendingInstances.add(instance);
    }

    private void releaseContainer(Container container) {
        this.scheduler.getAmRMClient().releaseAssignedContainer(container.getId());
        this.componentMetrics.surplusContainers.incr();
        this.scheduler.getServiceMetrics().surplusContainers.incr();
    }

    private void assignContainerToCompInstance(Container container) {
        Future<ProviderService.ResolvedLaunchParams> resolvedParamFuture;
        if (this.pendingInstances.size() == 0) {
            LOG.info("[COMPONENT {}]: No pending component instance left, release surplus container {}", (Object)this.getName(), (Object)container.getId());
            this.releaseContainer(container);
            return;
        }
        ComponentInstance instance = this.pendingInstances.remove(0);
        LOG.info("[COMPONENT {}]: {} allocated, num pending component instances reduced to {}", new Object[]{this.getName(), container.getId(), this.pendingInstances.size()});
        instance.setContainer(container);
        this.scheduler.addLiveCompInstance(container.getId(), instance);
        LOG.info("[COMPONENT {}]: Assigned {} to component instance {} and launch on host {} ", new Object[]{this.getName(), container.getId(), instance.getCompInstanceName(), container.getNodeId()});
        if (!this.upgradeStatus.isCompleted() || !this.cancelUpgradeStatus.isCompleted()) {
            UpgradeStatus status = !this.cancelUpgradeStatus.isCompleted() ? this.cancelUpgradeStatus : this.upgradeStatus;
            resolvedParamFuture = this.scheduler.getContainerLaunchService().launchCompInstance(this.scheduler.getApp(), instance, container, this.createLaunchContext(status.getTargetSpec(), status.getTargetVersion()));
        } else {
            resolvedParamFuture = this.scheduler.getContainerLaunchService().launchCompInstance(this.scheduler.getApp(), instance, container, this.createLaunchContext(this.componentSpec, this.scheduler.getApp().getVersion()));
        }
        instance.updateResolvedLaunchParams(resolvedParamFuture);
    }

    public ContainerLaunchService.ComponentLaunchContext createLaunchContext(org.apache.hadoop.yarn.service.api.records.Component compSpec, String version) {
        ContainerLaunchService.ComponentLaunchContext launchContext = new ContainerLaunchService.ComponentLaunchContext(compSpec.getName(), version);
        launchContext.setArtifact(compSpec.getArtifact()).setConfiguration(compSpec.getConfiguration()).setLaunchCommand(compSpec.getLaunchCommand()).setRunPrivilegedContainer(compSpec.getRunPrivilegedContainer());
        return launchContext;
    }

    public void requestContainers(long count) {
        LOG.info("[COMPONENT {}] Requesting for {} container(s)", (Object)this.componentSpec.getName(), (Object)count);
        org.apache.hadoop.yarn.service.api.records.Resource componentResource = this.componentSpec.getResource();
        Resource resource = Resource.newInstance((long)componentResource.calcMemoryMB(), (int)componentResource.getCpus());
        if (componentResource.getAdditional() != null) {
            for (Map.Entry<String, ResourceInformation> entry : componentResource.getAdditional().entrySet()) {
                String resourceName = entry.getKey();
                if (resourceName.equals("memory-mb") || resourceName.equals("vcores")) {
                    LOG.warn("Please set memory/vcore in the main section of resource, ignoring this entry=" + resourceName);
                    continue;
                }
                ResourceInformation specInfo = entry.getValue();
                org.apache.hadoop.yarn.api.records.ResourceInformation ri = org.apache.hadoop.yarn.api.records.ResourceInformation.newInstance((String)entry.getKey(), (String)specInfo.getUnit(), (long)specInfo.getValue(), specInfo.getTags(), specInfo.getAttributes());
                resource.setResourceInformation(resourceName, ri);
            }
        }
        if (!this.scheduler.hasAtLeastOnePlacementConstraint()) {
            int i = 0;
            while ((long)i < count) {
                AMRMClient.ContainerRequest request = AMRMClient.ContainerRequest.newBuilder().capability(resource).priority(this.priority).allocationRequestId(this.allocateId).relaxLocality(true).build();
                LOG.info("[COMPONENT {}] Submitting container request : {}", (Object)this.componentSpec.getName(), (Object)request);
                this.amrmClient.addContainerRequest(request);
                ++i;
            }
        } else {
            PlacementPolicy placementPolicy = this.componentSpec.getPlacementPolicy();
            HashSet<SchedulingRequest> schedulingRequests = new HashSet<SchedulingRequest>();
            org.apache.hadoop.yarn.api.resource.PlacementConstraint finalConstraint = null;
            if (placementPolicy != null) {
                for (PlacementConstraint yarnServiceConstraint : placementPolicy.getConstraints()) {
                    ArrayList<PlacementConstraint.TargetExpression> targetExpressions = new ArrayList<PlacementConstraint.TargetExpression>();
                    if (!yarnServiceConstraint.getTargetTags().isEmpty()) {
                        targetExpressions.add(PlacementConstraints.PlacementTargets.allocationTag((String[])yarnServiceConstraint.getTargetTags().toArray(new String[0])));
                    }
                    for (Map.Entry<String, List<String>> attribute : yarnServiceConstraint.getNodeAttributes().entrySet()) {
                        targetExpressions.add(PlacementConstraints.PlacementTargets.nodeAttribute((String)attribute.getKey(), (String[])attribute.getValue().toArray(new String[0])));
                    }
                    if (!yarnServiceConstraint.getNodePartitions().isEmpty()) {
                        targetExpressions.add(PlacementConstraints.PlacementTargets.nodePartition((String[])yarnServiceConstraint.getNodePartitions().toArray(new String[0])));
                    }
                    org.apache.hadoop.yarn.api.resource.PlacementConstraint constraint = null;
                    switch (yarnServiceConstraint.getType()) {
                        case AFFINITY: {
                            constraint = PlacementConstraints.targetIn((String)yarnServiceConstraint.getScope().getValue(), (PlacementConstraint.TargetExpression[])targetExpressions.toArray(new PlacementConstraint.TargetExpression[0])).build();
                            break;
                        }
                        case ANTI_AFFINITY: {
                            constraint = PlacementConstraints.targetNotIn((String)yarnServiceConstraint.getScope().getValue(), (PlacementConstraint.TargetExpression[])targetExpressions.toArray(new PlacementConstraint.TargetExpression[0])).build();
                            break;
                        }
                        case AFFINITY_WITH_CARDINALITY: {
                            constraint = PlacementConstraints.targetCardinality((String)yarnServiceConstraint.getScope().name().toLowerCase(), (int)(yarnServiceConstraint.getMinCardinality() == null ? 0 : yarnServiceConstraint.getMinCardinality().intValue()), (int)(yarnServiceConstraint.getMaxCardinality() == null ? Integer.MAX_VALUE : yarnServiceConstraint.getMaxCardinality().intValue()), (PlacementConstraint.TargetExpression[])targetExpressions.toArray(new PlacementConstraint.TargetExpression[0])).build();
                        }
                    }
                    if (constraint == null) {
                        LOG.info("[COMPONENT {}] Placement constraint: null ", (Object)this.componentSpec.getName());
                        continue;
                    }
                    finalConstraint = finalConstraint != null ? PlacementConstraints.and((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{constraint.getConstraintExpr(), finalConstraint.getConstraintExpr()}).build() : constraint;
                    LOG.debug("[COMPONENT {}] Placement constraint: {}", (Object)this.componentSpec.getName(), (Object)constraint.getConstraintExpr().toString());
                }
            }
            ResourceSizing resourceSizing = ResourceSizing.newInstance((int)((int)count), (Resource)resource);
            LOG.debug("[COMPONENT {}] Resource sizing: {}", (Object)this.componentSpec.getName(), (Object)resourceSizing);
            SchedulingRequest request = SchedulingRequest.newBuilder().priority(this.priority).allocationRequestId(this.allocateId).allocationTags(Collections.singleton(this.componentSpec.getName())).executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED, (boolean)true)).placementConstraintExpression(finalConstraint).resourceSizing(resourceSizing).build();
            LOG.info("[COMPONENT {}] Submitting scheduling request: {}", (Object)this.componentSpec.getName(), (Object)request);
            schedulingRequests.add(request);
            this.amrmClient.addSchedulingRequests(schedulingRequests);
        }
    }

    private void setDesiredContainers(int n) {
        int delta = n - this.scheduler.getServiceMetrics().containersDesired.value();
        if (delta != 0) {
            this.scheduler.getServiceMetrics().containersDesired.incr(delta);
        }
        this.componentMetrics.containersDesired.set(n);
    }

    private void updateMetrics(ContainerStatus status) {
        if (status != null) {
            switch (status.getExitStatus()) {
                case 0: {
                    this.componentMetrics.containersSucceeded.incr();
                    this.scheduler.getServiceMetrics().containersSucceeded.incr();
                    return;
                }
                case -102: {
                    this.componentMetrics.containersPreempted.incr();
                    this.scheduler.getServiceMetrics().containersPreempted.incr();
                    break;
                }
                case -101: {
                    this.componentMetrics.containersDiskFailure.incr();
                    this.scheduler.getServiceMetrics().containersDiskFailure.incr();
                    break;
                }
            }
        }
        this.componentMetrics.containersFailed.incr();
        this.scheduler.getServiceMetrics().containersFailed.incr();
        if (status != null && Apps.shouldCountTowardsNodeBlacklisting((int)status.getExitStatus())) {
            String host = this.scheduler.getLiveInstances().get(status.getContainerId()).getNodeId().getHost();
            this.failureTracker.incNodeFailure(host);
            this.currentContainerFailure.getAndIncrement();
        }
    }

    private boolean doesNeedUpgrade() {
        return this.cancelUpgradeStatus.areContainersUpgrading() || this.upgradeStatus.areContainersUpgrading() || this.upgradeStatus.failed.get();
    }

    public boolean areDependenciesReady() {
        List<String> dependencies = this.componentSpec.getDependencies();
        if (ServiceUtils.isEmpty(dependencies)) {
            return true;
        }
        for (String dependency : dependencies) {
            Component dependentComponent = this.scheduler.getAllComponents().get(dependency);
            if (dependentComponent == null) {
                LOG.error("Couldn't find dependency {} for {} (should never happen)", (Object)dependency, (Object)this.getName());
                continue;
            }
            if (dependentComponent.isReadyForDownstream()) continue;
            LOG.info("[COMPONENT {}]: Dependency {} not satisfied, only {} of {} instances are ready or the dependent component has not completed ", new Object[]{this.getName(), dependency, dependentComponent.getNumReadyInstances(), dependentComponent.getNumDesiredInstances()});
            return false;
        }
        return true;
    }

    public Map<String, String> getDependencyHostIpTokens() {
        HashMap<String, String> tokens = new HashMap<String, String>();
        List<String> dependencies = this.componentSpec.getDependencies();
        if (ServiceUtils.isEmpty(dependencies)) {
            return tokens;
        }
        for (String dependency : dependencies) {
            Collection<ComponentInstance> instances = this.scheduler.getAllComponents().get(dependency).getAllComponentInstances();
            for (ComponentInstance instance : instances) {
                if (instance.getContainerStatus() == null || ServiceUtils.isEmpty(instance.getContainerStatus().getIPs()) || ServiceUtils.isUnset(instance.getContainerStatus().getHost())) continue;
                String ip = (String)instance.getContainerStatus().getIPs().get(0);
                String host = instance.getContainerStatus().getHost();
                tokens.put(String.format(ServiceApiConstants.COMPONENT_INSTANCE_IP, instance.getCompInstanceName().toUpperCase()), ip);
                tokens.put(String.format(ServiceApiConstants.COMPONENT_INSTANCE_HOST, instance.getCompInstanceName().toUpperCase()), host);
            }
        }
        return tokens;
    }

    public void incRunningContainers() {
        this.componentMetrics.containersRunning.incr();
        this.scheduler.getServiceMetrics().containersRunning.incr();
    }

    public void decRunningContainers() {
        this.componentMetrics.containersRunning.decr();
        this.scheduler.getServiceMetrics().containersRunning.decr();
    }

    public void incContainersReady(boolean updateDefinition) {
        this.componentMetrics.containersReady.incr();
        this.scheduler.getServiceMetrics().containersReady.incr();
        if (updateDefinition) {
            Component.checkAndUpdateComponentState(this, true);
        }
    }

    public void decContainersReady(boolean updateDefinition) {
        this.componentMetrics.containersReady.decr();
        this.scheduler.getServiceMetrics().containersReady.decr();
        if (updateDefinition) {
            Component.checkAndUpdateComponentState(this, false);
        }
    }

    public int getNumReadyInstances() {
        return this.componentMetrics.containersReady.value();
    }

    public int getNumRunningInstances() {
        return this.componentMetrics.containersRunning.value();
    }

    public int getNumDesiredInstances() {
        return this.componentMetrics.containersDesired.value();
    }

    public ComponentInstance getComponentInstance(String componentInstanceName) {
        return this.compInstances.get(componentInstanceName);
    }

    public Collection<ComponentInstance> getAllComponentInstances() {
        return this.compInstances.values();
    }

    public org.apache.hadoop.yarn.service.api.records.Component getComponentSpec() {
        return this.componentSpec;
    }

    public void resetCompFailureCount() {
        LOG.info("[COMPONENT {}]: Reset container failure count from {} to 0.", (Object)this.getName(), (Object)this.currentContainerFailure.get());
        this.currentContainerFailure.set(0);
        this.failureTracker.resetContainerFailures();
    }

    public Probe getProbe() {
        return this.probe;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public long getAllocateId() {
        return this.allocateId;
    }

    public String getName() {
        return this.componentSpec.getName();
    }

    public ComponentState getState() {
        this.readLock.lock();
        try {
            ComponentState componentState = (ComponentState)this.stateMachine.getCurrentState();
            return componentState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isUpgrading() {
        this.readLock.lock();
        try {
            boolean bl = !this.upgradeStatus.isCompleted() || !this.cancelUpgradeStatus.isCompleted();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public UpgradeStatus getUpgradeStatus() {
        this.readLock.lock();
        try {
            UpgradeStatus upgradeStatus = this.upgradeStatus;
            return upgradeStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public UpgradeStatus getCancelUpgradeStatus() {
        this.readLock.lock();
        try {
            UpgradeStatus upgradeStatus = this.cancelUpgradeStatus;
            return upgradeStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public ServiceScheduler getScheduler() {
        return this.scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ComponentEvent event) {
        this.writeLock.lock();
        try {
            ComponentState oldState = this.getState();
            try {
                this.stateMachine.doTransition((Enum)event.getType(), (Object)event);
            }
            catch (InvalidStateTransitionException e) {
                LOG.error(MessageFormat.format("[COMPONENT {0}]: Invalid event {1} at {2}", new Object[]{this.componentSpec.getName(), event.getType(), oldState}), (Throwable)e);
            }
            if (oldState != this.getState()) {
                LOG.info("[COMPONENT {}] Transitioned from {} to {} on {} event.", new Object[]{this.componentSpec.getName(), oldState, this.getState(), event.getType()});
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void setComponentState(org.apache.hadoop.yarn.service.api.records.ComponentState state) {
        org.apache.hadoop.yarn.service.api.records.ComponentState curState = this.componentSpec.getState();
        if (!curState.equals((Object)state)) {
            this.componentSpec.setState(state);
            LOG.info("[COMPONENT {}] spec state changed from {} -> {}", new Object[]{this.componentSpec.getName(), curState, state});
        }
    }

    public ServiceContext getContext() {
        return this.context;
    }

    public List<ComponentInstance> getPendingInstances() {
        return this.pendingInstances;
    }

    public boolean isHealthThresholdMonitorEnabled() {
        return this.healthThresholdMonitorEnabled;
    }

    public void setHealthThresholdMonitorEnabled(boolean healthThresholdMonitorEnabled) {
        this.healthThresholdMonitorEnabled = healthThresholdMonitorEnabled;
    }

    public Collection<ComponentInstance> getSucceededInstances() {
        return this.succeededInstances.values();
    }

    public long getNumSucceededInstances() {
        return this.succeededInstances.size();
    }

    public long getNumFailedInstances() {
        return this.failedInstances.size();
    }

    public Collection<ComponentInstance> getFailedInstances() {
        return this.failedInstances.values();
    }

    public synchronized void markAsSucceeded(ComponentInstance instance) {
        this.removeFailedInstanceIfExists(instance);
        this.succeededInstances.put(instance.getCompInstanceName(), instance);
    }

    public synchronized void markAsFailed(ComponentInstance instance) {
        this.removeSuccessfulInstanceIfExists(instance);
        this.failedInstances.put(instance.getCompInstanceName(), instance);
    }

    public boolean removeFailedInstanceIfExists(ComponentInstance instance) {
        if (this.failedInstances.containsKey(instance.getCompInstanceName())) {
            this.failedInstances.remove(instance.getCompInstanceName());
            return true;
        }
        return false;
    }

    public boolean removeSuccessfulInstanceIfExists(ComponentInstance instance) {
        if (this.succeededInstances.containsKey(instance.getCompInstanceName())) {
            this.succeededInstances.remove(instance.getCompInstanceName());
            return true;
        }
        return false;
    }

    public boolean isReadyForDownstream() {
        return this.getRestartPolicyHandler().isReadyForDownStream(this);
    }

    public static ComponentRestartPolicy getRestartPolicyHandler(Component.RestartPolicyEnum restartPolicyEnum) {
        if (Component.RestartPolicyEnum.NEVER == restartPolicyEnum) {
            return NeverRestartPolicy.getInstance();
        }
        if (Component.RestartPolicyEnum.ON_FAILURE == restartPolicyEnum) {
            return OnFailureRestartPolicy.getInstance();
        }
        return AlwaysRestartPolicy.getInstance();
    }

    public ComponentRestartPolicy getRestartPolicyHandler() {
        Component.RestartPolicyEnum restartPolicyEnum = this.getComponentSpec().getRestartPolicy();
        return Component.getRestartPolicyHandler(restartPolicyEnum);
    }

    public String getHostnameSuffix() {
        return ServiceApiUtil.getHostnameSuffix(this.context.service.getName(), this.scheduler.getConfig());
    }

    public static class UpgradeStatus {
        private org.apache.hadoop.yarn.service.api.records.Component targetSpec;
        private String targetVersion;
        private AtomicBoolean inProgress = new AtomicBoolean(false);
        private AtomicLong containersNeedUpgrade = new AtomicLong(0L);
        private AtomicBoolean failed = new AtomicBoolean(false);

        public org.apache.hadoop.yarn.service.api.records.Component getTargetSpec() {
            return this.targetSpec;
        }

        public String getTargetVersion() {
            return this.targetVersion;
        }

        public boolean isCompleted() {
            return !this.inProgress.get();
        }

        public void decContainersThatNeedUpgrade() {
            if (this.inProgress.get()) {
                this.containersNeedUpgrade.decrementAndGet();
            }
        }

        public void containerFailedUpgrade() {
            this.failed.set(true);
        }

        void reset() {
            this.containersNeedUpgrade.set(0L);
            this.targetSpec = null;
            this.targetVersion = null;
            this.inProgress.set(false);
            this.failed.set(false);
        }

        boolean areContainersUpgrading() {
            return this.containersNeedUpgrade.get() != 0L;
        }
    }

    private static class BaseTransition
    implements SingleArcTransition<Component, ComponentEvent> {
        private BaseTransition() {
        }

        public void transition(Component component, ComponentEvent event) {
        }
    }

    private static class CheckStableTransition
    implements MultipleArcTransition<Component, ComponentEvent, ComponentState> {
        private CheckStableTransition() {
        }

        public ComponentState transition(Component component, ComponentEvent componentEvent) {
            ComponentState targetState = Component.checkIfStable(component);
            if (!(!targetState.equals((Object)ComponentState.STABLE) || component.upgradeStatus.isCompleted() && component.cancelUpgradeStatus.isCompleted())) {
                UpgradeStatus status = !component.cancelUpgradeStatus.isCompleted() ? component.cancelUpgradeStatus : component.upgradeStatus;
                component.componentSpec.overwrite(status.getTargetSpec());
                status.reset();
                ServiceEvent checkStable = new ServiceEvent(ServiceEventType.CHECK_STABLE);
                component.dispatcher.getEventHandler().handle((Event)checkStable);
            }
            return targetState;
        }
    }

    private static class NeedsUpgradeTransition
    extends BaseTransition {
        private NeedsUpgradeTransition() {
        }

        @Override
        public void transition(Component component, ComponentEvent event) {
            boolean isCancel = event.getType().equals((Object)ComponentEventType.CANCEL_UPGRADE);
            UpgradeStatus status = !isCancel ? component.upgradeStatus : component.cancelUpgradeStatus;
            status.inProgress.set(true);
            status.targetSpec = event.getTargetSpec();
            status.targetVersion = event.getUpgradeVersion();
            LOG.info("[COMPONENT {}]: need upgrade to {}", (Object)component.getName(), (Object)status.targetVersion);
            status.containersNeedUpgrade.set(component.componentSpec.getNumberOfContainers());
            component.setComponentState(org.apache.hadoop.yarn.service.api.records.ComponentState.NEEDS_UPGRADE);
            component.getAllComponentInstances().forEach(instance -> instance.setContainerState(ContainerState.NEEDS_UPGRADE));
            if (event.getType().equals((Object)ComponentEventType.CANCEL_UPGRADE)) {
                component.upgradeStatus.reset();
            }
        }
    }

    private static class CompletedAfterUpgradeTransition
    extends BaseTransition {
        private CompletedAfterUpgradeTransition() {
        }

        @Override
        public void transition(Component component, ComponentEvent event) {
            Preconditions.checkNotNull((Object)event.getContainerId());
            component.updateMetrics(event.getStatus());
            component.dispatcher.getEventHandler().handle((Event)new ComponentInstanceEvent(event.getContainerId(), ComponentInstanceEventType.STOP).setStatus(event.getStatus()));
        }
    }

    private static class ContainerCompletedTransition
    extends BaseTransition {
        private ContainerCompletedTransition() {
        }

        @Override
        public void transition(Component component, ComponentEvent event) {
            Preconditions.checkNotNull((Object)event.getContainerId());
            component.updateMetrics(event.getStatus());
            component.dispatcher.getEventHandler().handle((Event)new ComponentInstanceEvent(event.getContainerId(), ComponentInstanceEventType.STOP).setStatus(event.getStatus()));
            ComponentRestartPolicy restartPolicy = component.getRestartPolicyHandler();
            if (restartPolicy.shouldRelaunchInstance(event.getInstance(), event.getStatus())) {
                component.componentSpec.setState(org.apache.hadoop.yarn.service.api.records.ComponentState.FLEXING);
                if (((Component)component).context.service.getState().equals((Object)ServiceState.STABLE)) {
                    component.getScheduler().getApp().setState(ServiceState.STARTED);
                    LOG.info("Service def state changed from {} -> {}", (Object)ServiceState.STABLE, (Object)ServiceState.STARTED);
                }
            }
        }
    }

    private static class ContainerStartedTransition
    implements MultipleArcTransition<Component, ComponentEvent, ComponentState> {
        private ContainerStartedTransition() {
        }

        public ComponentState transition(Component component, ComponentEvent event) {
            component.dispatcher.getEventHandler().handle((Event)new ComponentInstanceEvent(event.getContainerId(), ComponentInstanceEventType.START));
            return Component.checkIfStable(component);
        }
    }

    private static class ContainerRecoveredTransition
    extends BaseTransition {
        private ContainerRecoveredTransition() {
        }

        @Override
        public void transition(Component component, ComponentEvent event) {
            ComponentInstance instance = event.getInstance();
            Container container = event.getContainer();
            if (instance == null) {
                LOG.info("[COMPONENT {}]: Trying to recover {} but event did not specify component instance", (Object)component.getName(), (Object)container.getId());
                component.releaseContainer(container);
                return;
            }
            component.pendingInstances.remove(instance);
            instance.setContainer(container);
            ProviderUtils.initCompInstanceDir(component.getContext().fs, component.createLaunchContext(component.componentSpec, component.scheduler.getApp().getVersion()), instance);
            component.getScheduler().addLiveCompInstance(container.getId(), instance);
            LOG.info("[COMPONENT {}]: Recovered {} for component instance {} on host {}, num pending component instances reduced to {} ", new Object[]{component.getName(), container.getId(), instance.getCompInstanceName(), container.getNodeId(), component.pendingInstances.size()});
            component.dispatcher.getEventHandler().handle((Event)new ComponentInstanceEvent(container.getId(), ComponentInstanceEventType.START));
        }
    }

    private static class ContainerAllocatedTransition
    extends BaseTransition {
        private ContainerAllocatedTransition() {
        }

        @Override
        public void transition(Component component, ComponentEvent event) {
            component.assignContainerToCompInstance(event.getContainer());
        }
    }

    private static class DecommissionInstanceTransition
    extends BaseTransition {
        private DecommissionInstanceTransition() {
        }

        @Override
        public void transition(Component component, ComponentEvent event) {
            String hostnameSuffix;
            String instanceName = event.getInstanceName();
            if (instanceName.endsWith(hostnameSuffix = component.getHostnameSuffix())) {
                instanceName = instanceName.substring(0, instanceName.length() - hostnameSuffix.length());
            }
            if (component.getComponentSpec().getDecommissionedInstances().contains(instanceName)) {
                LOG.info("Instance {} already decommissioned", (Object)instanceName);
                return;
            }
            component.getComponentSpec().addDecommissionedInstance(instanceName);
            ComponentInstance instance = component.getComponentInstance(instanceName);
            if (instance == null) {
                LOG.info("Instance was null for decommissioned instance {}", (Object)instanceName);
                return;
            }
            component.compInstances.remove(instance.getCompInstanceName());
            component.pendingInstances.remove(instance);
            ((Component)component).scheduler.getServiceMetrics().containersDesired.decr();
            ((Component)component).componentMetrics.containersDesired.decr();
            component.getComponentSpec().setNumberOfContainers(component.getComponentSpec().getNumberOfContainers() - 1L);
            instance.destroy();
        }
    }

    private static class FlexComponentTransition
    implements MultipleArcTransition<Component, ComponentEvent, ComponentState> {
        private FlexComponentTransition() {
        }

        public ComponentState transition(Component component, ComponentEvent event) {
            component.setDesiredContainers((int)event.getDesired());
            if (!component.areDependenciesReady()) {
                LOG.info("[FLEX COMPONENT {}]: Flex deferred because dependencies not satisfied.", (Object)component.getName());
                return component.getState();
            }
            if (component.getState() == ComponentState.INIT) {
                LOG.info("[INIT COMPONENT " + component.getName() + "]: " + event.getDesired() + " instances.");
                component.requestContainers(component.pendingInstances.size());
                return Component.checkIfStable(component);
            }
            long before = component.getComponentSpec().getNumberOfContainers();
            long delta = event.getDesired() - before;
            component.getComponentSpec().setNumberOfContainers(event.getDesired());
            if (delta > 0L) {
                LOG.info("[FLEX UP COMPONENT " + component.getName() + "]: scaling up from " + before + " to " + event.getDesired());
                component.requestContainers(delta);
                component.createNumCompInstances(delta);
                component.setComponentState(org.apache.hadoop.yarn.service.api.records.ComponentState.FLEXING);
                component.getScheduler().getApp().setState(ServiceState.STARTED);
                return ComponentState.FLEXING;
            }
            if (delta < 0L) {
                delta = 0L - delta;
                LOG.info("[FLEX DOWN COMPONENT " + component.getName() + "]: scaling down from " + before + " to " + event.getDesired());
                ArrayList<ComponentInstance> list = new ArrayList<ComponentInstance>(component.getAllComponentInstances());
                list.sort(Collections.reverseOrder());
                int i = 0;
                while ((long)i < delta) {
                    ComponentInstance instance = (ComponentInstance)list.get(i);
                    component.compInstances.remove(instance.getCompInstanceName());
                    component.pendingInstances.remove(instance);
                    component.instanceIdCounter.decrementAndGet();
                    instance.destroy();
                    ++i;
                }
                Component.checkAndUpdateComponentState(component, false);
                return component.componentSpec.getState() == org.apache.hadoop.yarn.service.api.records.ComponentState.STABLE ? ComponentState.STABLE : ComponentState.FLEXING;
            }
            LOG.info("[FLEX COMPONENT " + component.getName() + "]: already has " + event.getDesired() + " instances, ignoring");
            return ComponentState.STABLE;
        }
    }
}

