/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix.emulators.resourceusage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.gridmix.Progressive;
import org.apache.hadoop.mapred.gridmix.emulators.resourceusage.ResourceUsageEmulatorPlugin;
import org.apache.hadoop.tools.rumen.ResourceUsageMetrics;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.util.ResourceCalculatorPlugin;

public class ResourceUsageMatcher
implements Progressive {
    public static final String RESOURCE_USAGE_EMULATION_PLUGINS = "gridmix.emulators.resource-usage.plugins";
    private List<ResourceUsageEmulatorPlugin> emulationPlugins = new ArrayList<ResourceUsageEmulatorPlugin>();

    public void configure(Configuration conf, ResourceCalculatorPlugin monitor, ResourceUsageMetrics metrics, Progressive progress) {
        Class[] plugins = conf.getClasses(RESOURCE_USAGE_EMULATION_PLUGINS, new Class[0]);
        if (plugins == null) {
            System.out.println("No resource usage emulator plugins configured.");
        } else {
            for (Class clazz : plugins) {
                if (clazz == null) continue;
                if (ResourceUsageEmulatorPlugin.class.isAssignableFrom(clazz)) {
                    ResourceUsageEmulatorPlugin plugin = (ResourceUsageEmulatorPlugin)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
                    this.emulationPlugins.add(plugin);
                    continue;
                }
                throw new RuntimeException("Misconfigured resource usage plugins. Class " + clazz.getClass().getName() + " is not a resource usage plugin as it does not extend " + ResourceUsageEmulatorPlugin.class.getName());
            }
        }
        for (ResourceUsageEmulatorPlugin emulator : this.emulationPlugins) {
            emulator.initialize(conf, metrics, monitor, progress);
        }
    }

    public void matchResourceUsage() throws IOException, InterruptedException {
        for (ResourceUsageEmulatorPlugin emulator : this.emulationPlugins) {
            emulator.emulate();
        }
    }

    @Override
    public float getProgress() {
        if (this.emulationPlugins.size() > 0) {
            float progress = 0.0f;
            for (ResourceUsageEmulatorPlugin emulator : this.emulationPlugins) {
                progress += emulator.getProgress();
            }
            return progress / (float)this.emulationPlugins.size();
        }
        return 1.0f;
    }
}

