/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.InvalidateBlocks;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.test.Whitebox;
import org.apache.hadoop.util.VersionInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestComputeInvalidateWork {
    private Configuration conf;
    private final int NUM_OF_DATANODES = 3;
    private MiniDFSCluster cluster;
    private FSNamesystem namesystem;
    private BlockManager bm;
    private DatanodeDescriptor[] nodes;
    private ErasureCodingPolicy ecPolicy;
    private DistributedFileSystem fs;
    private Path ecFile;
    private int totalBlockGroups;
    private int blockGroupSize;
    private int stripesPerBlock;
    private int cellSize;
    private LocatedStripedBlock locatedStripedBlock;

    @Before
    public void setup() throws Exception {
        this.ecPolicy = SystemErasureCodingPolicies.getByID((byte)4);
        this.conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.namesystem = this.cluster.getNamesystem();
        this.bm = this.namesystem.getBlockManager();
        this.nodes = this.bm.getDatanodeManager().getHeartbeatManager().getDatanodes();
        BlockManagerTestUtil.stopRedundancyThread(this.bm);
        Assert.assertEquals((long)this.nodes.length, (long)3L);
        Path ecDir = new Path("/ec");
        this.fs = this.cluster.getFileSystem();
        this.fs.enableErasureCodingPolicy(this.ecPolicy.getName());
        this.fs.mkdirs(ecDir);
        this.fs.getClient().setErasureCodingPolicy(ecDir.toString(), this.ecPolicy.getName());
        this.ecFile = new Path(ecDir, "ec-file");
        this.stripesPerBlock = 2;
        this.cellSize = this.ecPolicy.getCellSize();
        int blockSize = this.stripesPerBlock * this.cellSize;
        this.blockGroupSize = this.ecPolicy.getNumDataUnits() * blockSize;
        this.totalBlockGroups = 4;
        DFSTestUtil.createStripedFile(this.cluster, this.ecFile, ecDir, this.totalBlockGroups, this.stripesPerBlock, false, this.ecPolicy);
        LocatedBlocks lbs = this.cluster.getFileSystem().getClient().getNamenode().getBlockLocations(this.ecFile.toString(), 0L, (long)this.blockGroupSize);
        assert (lbs.get(0) instanceof LocatedStripedBlock);
        this.locatedStripedBlock = (LocatedStripedBlock)lbs.get(0);
    }

    @After
    public void teardown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private void verifyInvalidationWorkCounts(int blockInvalidateLimit) {
        Assert.assertEquals((long)(blockInvalidateLimit * 3), (long)this.bm.computeInvalidateWork(4));
        Assert.assertEquals((long)(blockInvalidateLimit * 3), (long)this.bm.computeInvalidateWork(3));
        Assert.assertEquals((long)(blockInvalidateLimit * 2), (long)this.bm.computeInvalidateWork(2));
        int workCount = this.bm.computeInvalidateWork(1);
        if (workCount == 1) {
            Assert.assertEquals((long)(blockInvalidateLimit + 1), (long)this.bm.computeInvalidateWork(2));
        } else {
            Assert.assertEquals((long)workCount, (long)blockInvalidateLimit);
            Assert.assertEquals((long)2L, (long)this.bm.computeInvalidateWork(2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testComputeInvalidateReplicas() throws Exception {
        int blockInvalidateLimit = this.bm.getDatanodeManager().getBlockInvalidateLimit();
        this.namesystem.writeLock();
        try {
            for (int i = 0; i < this.nodes.length; ++i) {
                for (int j = 0; j < 3 * blockInvalidateLimit + 1; ++j) {
                    Block block = new Block((long)(i * (blockInvalidateLimit + 1) + j), 0L, 1000L);
                    this.bm.addToInvalidates(block, (DatanodeInfo)this.nodes[i]);
                }
            }
            this.verifyInvalidationWorkCounts(blockInvalidateLimit);
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testComputeInvalidateStripedBlockGroups() throws Exception {
        int blockInvalidateLimit = this.bm.getDatanodeManager().getBlockInvalidateLimit();
        this.namesystem.writeLock();
        try {
            int nodeCount = this.ecPolicy.getNumDataUnits() + this.ecPolicy.getNumParityUnits();
            for (int i = 0; i < nodeCount; ++i) {
                for (int j = 0; j < 3 * blockInvalidateLimit + 1; ++j) {
                    Block blk = new Block(this.locatedStripedBlock.getBlock().getBlockId() + (long)(i * 10 + j), (long)(this.stripesPerBlock * this.cellSize), this.locatedStripedBlock.getBlock().getGenerationStamp());
                    this.bm.addToInvalidates(blk, (DatanodeInfo)this.nodes[i]);
                }
            }
            this.verifyInvalidationWorkCounts(blockInvalidateLimit);
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testComputeInvalidate() throws Exception {
        int blockInvalidateLimit = this.bm.getDatanodeManager().getBlockInvalidateLimit();
        Random random = new Random(System.currentTimeMillis());
        this.namesystem.writeLock();
        try {
            int nodeCount = this.ecPolicy.getNumDataUnits() + this.ecPolicy.getNumParityUnits();
            for (int i = 0; i < nodeCount; ++i) {
                for (int j = 0; j < 3 * blockInvalidateLimit + 1; ++j) {
                    if (random.nextBoolean()) {
                        Block stripedBlock = new Block(this.locatedStripedBlock.getBlock().getBlockId() + (long)(i * 10 + j), (long)(this.stripesPerBlock * this.cellSize), this.locatedStripedBlock.getBlock().getGenerationStamp());
                        this.bm.addToInvalidates(stripedBlock, (DatanodeInfo)this.nodes[i]);
                        continue;
                    }
                    Block replica = new Block((long)(i * (blockInvalidateLimit + 1) + j), 0L, 1000L);
                    this.bm.addToInvalidates(replica, (DatanodeInfo)this.nodes[i]);
                }
            }
            this.verifyInvalidationWorkCounts(blockInvalidateLimit);
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testDatanodeReformat() throws Exception {
        this.namesystem.writeLock();
        try {
            String poolId = this.cluster.getNamesystem().getBlockPoolId();
            DatanodeRegistration dnr = this.cluster.getDataNode(this.nodes[0].getIpcPort()).getDNRegistrationForBP(poolId);
            dnr = new DatanodeRegistration(UUID.randomUUID().toString(), dnr);
            this.cluster.stopDataNode(this.nodes[0].getXferAddr());
            Block block = new Block(0L, 0L, 1000L);
            this.bm.addToInvalidates(block, (DatanodeInfo)this.nodes[0]);
            Block stripedBlock = new Block(this.locatedStripedBlock.getBlock().getBlockId() + 100L, (long)(this.stripesPerBlock * this.cellSize), this.locatedStripedBlock.getBlock().getGenerationStamp());
            this.bm.addToInvalidates(stripedBlock, (DatanodeInfo)this.nodes[0]);
            this.bm.getDatanodeManager().registerDatanode(dnr);
            Assert.assertEquals((long)0L, (long)this.bm.computeInvalidateWork(1));
            Assert.assertEquals((long)0L, (long)this.bm.getPendingDeletionBlocksCount());
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=12000L)
    public void testDatanodeReRegistration() throws Exception {
        InvalidateBlocks invalidateBlocks;
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        Path path = new Path("/testRR");
        short totalReplicas = 3;
        DFSTestUtil.createFile((FileSystem)dfs, path, dfs.getDefaultBlockSize(), totalReplicas, 0xED0ED0L);
        DFSTestUtil.waitForReplication(dfs, path, (short)3, 12000);
        for (DataNode dn : this.cluster.getDataNodes()) {
            dn.shutdown();
        }
        dfs.delete(path, false);
        dfs.delete(this.ecFile, false);
        BlockManagerTestUtil.waitForMarkedDeleteQueueIsEmpty(this.cluster.getNamesystem(0).getBlockManager());
        this.namesystem.writeLock();
        int totalStripedDataBlocks = this.totalBlockGroups * (this.ecPolicy.getNumDataUnits() + this.ecPolicy.getNumParityUnits());
        int expected = totalReplicas + totalStripedDataBlocks;
        try {
            invalidateBlocks = (InvalidateBlocks)Whitebox.getInternalState((Object)this.cluster.getNamesystem().getBlockManager(), (String)"invalidateBlocks");
            Assert.assertEquals((String)"Invalidate blocks should include both Replicas and Striped BlockGroups!", (long)expected, (long)invalidateBlocks.numBlocks());
            Assert.assertEquals((String)"Unexpected invalidate count for replicas!", (long)totalReplicas, (long)invalidateBlocks.getBlocks());
            Assert.assertEquals((String)"Unexpected invalidate count for striped block groups!", (long)totalStripedDataBlocks, (long)invalidateBlocks.getECBlocks());
        }
        finally {
            this.namesystem.writeUnlock();
        }
        int totalBlockGroupsPerDataNode = this.totalBlockGroups;
        int totalReplicasPerDataNode = totalReplicas / 3;
        for (DataNode dn : this.cluster.getDataNodes()) {
            DatanodeID did = dn.getDatanodeId();
            DatanodeRegistration reg = new DatanodeRegistration(new DatanodeID(UUID.randomUUID().toString(), did), new StorageInfo(HdfsServerConstants.NodeType.DATA_NODE), new ExportedBlockKeys(), VersionInfo.getVersion());
            this.namesystem.writeLock();
            try {
                this.bm.getDatanodeManager().registerDatanode(reg);
                Assert.assertEquals((String)"Expected number of invalidate blocks to decrease", (long)(expected -= totalReplicasPerDataNode + totalBlockGroupsPerDataNode), (long)invalidateBlocks.numBlocks());
            }
            finally {
                this.namesystem.writeUnlock();
            }
        }
    }
}

