/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common.telemetry;

import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.common.telemetry.EpochFormatter;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Metric;
import software.amazon.s3.analyticsaccelerator.common.telemetry.MetricMeasurementKind;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryDatapointMeasurement;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryFormat;

public class MetricMeasurement
extends TelemetryDatapointMeasurement {
    @NonNull
    private final MetricMeasurementKind kind;
    private final double value;

    private MetricMeasurement(Metric metric, @NonNull MetricMeasurementKind kind, long epochTimestampNanos, double value) {
        super(metric, epochTimestampNanos);
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        this.kind = kind;
        this.value = value;
    }

    @Override
    protected double getValueCore() {
        return this.value;
    }

    public Metric getMetric() {
        return (Metric)this.getDatapoint();
    }

    @Override
    public String toString(@NonNull TelemetryFormat telemetryFormat, @NonNull EpochFormatter epochFormatter) {
        if (telemetryFormat == null) {
            throw new NullPointerException("telemetryFormat is marked non-null but is null");
        }
        if (epochFormatter == null) {
            throw new NullPointerException("epochFormatter is marked non-null but is null");
        }
        return telemetryFormat.renderMetricMeasurement(this, epochFormatter);
    }

    public static MetricMeasurementBuilder builder() {
        return new MetricMeasurementBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricMeasurement)) {
            return false;
        }
        MetricMeasurement other = (MetricMeasurement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.value, other.value) != 0) {
            return false;
        }
        MetricMeasurementKind this$kind = this.getKind();
        MetricMeasurementKind other$kind = other.getKind();
        return !(this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetricMeasurement;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $value = Double.doubleToLongBits(this.value);
        result = result * 59 + (int)($value >>> 32 ^ $value);
        MetricMeasurementKind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public MetricMeasurementKind getKind() {
        return this.kind;
    }

    public static class MetricMeasurementBuilder
    extends TelemetryDatapointMeasurement.TelemetryDatapointMeasurementBuilder<MetricMeasurement, MetricMeasurementBuilder> {
        private Metric metric;
        private MetricMeasurementKind kind = MetricMeasurementKind.RAW;
        double value = Double.NaN;

        public MetricMeasurementBuilder metric(@NonNull Metric metric) {
            if (metric == null) {
                throw new NullPointerException("metric is marked non-null but is null");
            }
            this.metric = metric;
            return this;
        }

        public MetricMeasurementBuilder kind(@NonNull MetricMeasurementKind kind) {
            if (kind == null) {
                throw new NullPointerException("kind is marked non-null but is null");
            }
            this.kind = kind;
            return this;
        }

        public MetricMeasurementBuilder value(double value) {
            this.value = value;
            return this;
        }

        @Override
        protected MetricMeasurement buildCore() {
            Preconditions.checkNotNull(this.metric, "The `metric` must be set.");
            Preconditions.checkArgument(!Double.isNaN(this.value), "The `value` must be set.");
            return new MetricMeasurement(this.metric, this.kind, this.getEpochTimestampNanos(), this.value);
        }
    }
}

