/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.UGIResolver;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class SingleUGIResolver
extends UGIResolver
implements Configurable {
    public static final String UID = "hdfs.image.writer.ugi.single.uid";
    public static final String USER = "hdfs.image.writer.ugi.single.user";
    public static final String GID = "hdfs.image.writer.ugi.single.gid";
    public static final String GROUP = "hdfs.image.writer.ugi.single.group";
    private int uid;
    private int gid;
    private String user;
    private String group;
    private Configuration conf;

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.uid = conf.getInt(UID, 0);
        this.user = conf.get(USER);
        if (null == this.user) {
            try {
                this.user = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException e) {
                this.user = "hadoop";
            }
        }
        this.gid = conf.getInt(GID, 1);
        this.group = conf.get(GROUP);
        if (null == this.group) {
            this.group = this.user;
        }
        this.resetUGInfo();
        this.addUser(this.user, this.uid);
        this.addGroup(this.group, this.gid);
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public String user(String s) {
        return this.user;
    }

    @Override
    public String group(String s) {
        return this.group;
    }

    @Override
    public void addUser(String name) {
    }

    @Override
    public void addGroup(String name) {
    }
}

