/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.auth.external;

import io.trino.jdbc.$internal.client.auth.external.RedirectException;
import io.trino.jdbc.$internal.client.auth.external.RedirectHandler;
import io.trino.jdbc.$internal.guava.base.Splitter;
import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class SystemOpenRedirectHandler
implements RedirectHandler {
    private static final List<String> LINUX_BROWSERS = ImmutableList.of("xdg-open", "gnome-open", "kde-open", "chromium", "google", "google-chrome", "firefox", "mozilla", "opera", "epiphany", "konqueror");
    private static final String MACOS_OPEN_COMMAND = "open";
    private static final String WINDOWS_OPEN_COMMAND = "rundll32 url.dll,FileProtocolHandler";
    private static final Splitter SPLITTER = Splitter.on(":").omitEmptyStrings().trimResults();

    @Override
    public void redirectTo(URI uri) throws RedirectException {
        String operatingSystem = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        try {
            if (operatingSystem.contains("mac")) {
                SystemOpenRedirectHandler.exec(uri, MACOS_OPEN_COMMAND);
            } else if (operatingSystem.contains("windows")) {
                SystemOpenRedirectHandler.exec(uri, WINDOWS_OPEN_COMMAND);
            } else {
                String executablePath = SystemOpenRedirectHandler.findLinuxBrowser().orElseThrow(() -> new FileNotFoundException("Could not find any known linux browser in $PATH"));
                SystemOpenRedirectHandler.exec(uri, executablePath);
            }
        }
        catch (IOException e) {
            throw new RedirectException(String.format("Could not open uri %s", uri), e);
        }
    }

    private static Optional<String> findLinuxBrowser() {
        List<String> paths = SPLITTER.splitToList(System.getenv("PATH"));
        for (String path : paths) {
            File[] found = Paths.get(path, new String[0]).toFile().listFiles((dir, name) -> LINUX_BROWSERS.contains(name));
            if (found == null || found.length <= 0) continue;
            return Optional.of(found[0].getPath());
        }
        return Optional.empty();
    }

    private static void exec(URI uri, String openCommand) throws IOException {
        Runtime.getRuntime().exec(openCommand + " " + uri.toString());
    }
}

