/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.lancedb.lance.namespace.model.JsonArrowField;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"fields", "length", "type"})
public class JsonArrowDataType {
    public static final String JSON_PROPERTY_FIELDS = "fields";
    @Nullable
    private List<JsonArrowField> fields = new ArrayList<JsonArrowField>();
    public static final String JSON_PROPERTY_LENGTH = "length";
    @Nullable
    private Long length;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private String type;

    public JsonArrowDataType fields(@Nullable List<JsonArrowField> fields) {
        this.fields = fields;
        return this;
    }

    public JsonArrowDataType addFieldsItem(JsonArrowField fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<JsonArrowField>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<JsonArrowField> getFields() {
        return this.fields;
    }

    @JsonProperty(value="fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFields(@Nullable List<JsonArrowField> fields) {
        this.fields = fields;
    }

    public JsonArrowDataType length(@Nullable Long length) {
        this.length = length;
        return this;
    }

    @Nullable
    @JsonProperty(value="length")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getLength() {
        return this.length;
    }

    @JsonProperty(value="length")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLength(@Nullable Long length) {
        this.length = length;
    }

    public JsonArrowDataType type(@Nonnull String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonArrowDataType jsonArrowDataType = (JsonArrowDataType)o;
        return Objects.equals(this.fields, jsonArrowDataType.fields) && Objects.equals(this.length, jsonArrowDataType.length) && Objects.equals(this.type, jsonArrowDataType.type);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.length, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JsonArrowDataType {\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getFields() != null) {
            for (int i = 0; i < this.getFields().size(); ++i) {
                if (this.getFields().get(i) == null) continue;
                joiner.add(this.getFields().get(i).toUrlQueryString(String.format("%sfields%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getLength() != null) {
            try {
                joiner.add(String.format("%slength%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLength()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getType() != null) {
            try {
                joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

