/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.rest.RESTRequest;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=SetSchemaPropertyRequest.class, name="setProperty"), @JsonSubTypes.Type(value=RemoveSchemaPropertyRequest.class, name="removeProperty")})
public interface SchemaUpdateRequest
extends RESTRequest {
    public SchemaChange schemaChange();

    public static class RemoveSchemaPropertyRequest
    implements SchemaUpdateRequest {
        @JsonProperty(value="property")
        private final String property;

        public RemoveSchemaPropertyRequest(String property) {
            this.property = property;
        }

        public RemoveSchemaPropertyRequest() {
            this(null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.property), (Object)"\"property\" field is required and cannot be empty");
        }

        @Override
        public SchemaChange schemaChange() {
            return SchemaChange.removeProperty((String)this.property);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoveSchemaPropertyRequest)) {
                return false;
            }
            RemoveSchemaPropertyRequest other = (RemoveSchemaPropertyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            return !(this$property == null ? other$property != null : !this$property.equals(other$property));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RemoveSchemaPropertyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            return result;
        }

        public String toString() {
            return "SchemaUpdateRequest.RemoveSchemaPropertyRequest(property=" + this.getProperty() + ")";
        }

        public String getProperty() {
            return this.property;
        }
    }

    public static class SetSchemaPropertyRequest
    implements SchemaUpdateRequest {
        @JsonProperty(value="property")
        private final String property;
        @JsonProperty(value="value")
        private final String value;

        public SetSchemaPropertyRequest(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public SetSchemaPropertyRequest() {
            this(null, null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.property), (Object)"\"property\" field is required and cannot be empty");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.value), (Object)"\"value\" field is required and cannot be empty");
        }

        @Override
        public SchemaChange schemaChange() {
            return SchemaChange.setProperty((String)this.property, (String)this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SetSchemaPropertyRequest)) {
                return false;
            }
            SetSchemaPropertyRequest other = (SetSchemaPropertyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SetSchemaPropertyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "SchemaUpdateRequest.SetSchemaPropertyRequest(property=" + this.getProperty() + ", value=" + this.getValue() + ")";
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }
    }
}

