# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from dataclasses import dataclass, field
from typing import Optional

from dataclasses_json import config

from gravitino.dto.job.job_template_dto import JobTemplateDTO
from gravitino.rest.rest_message import RESTRequest


@dataclass
class JobTemplateRegisterRequest(RESTRequest):
    """Represents a request to register a job template."""

    _job_template: JobTemplateDTO = field(metadata=config(field_name="jobTemplate"))

    def job_template(self) -> Optional[JobTemplateDTO]:
        """Returns the job template to register."""
        return self._job_template

    def validate(self):
        """Validates the request.

        Raises:
            ValueError: If the request is invalid.
        """
        if self._job_template is None:
            raise ValueError('"jobTemplate" is required and cannot be None')

        self._job_template.validate()
