/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.generic;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.gravitino.catalog.lakehouse.generic.LakehouseTableDelegator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LakehouseTableDelegatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LakehouseTableDelegatorFactory.class);
    private static ImmutableMap<String, LakehouseTableDelegator> delegators;

    private LakehouseTableDelegatorFactory() {
    }

    private static synchronized void createTableDelegators() {
        if (delegators != null) {
            return;
        }
        ClassLoader cl = Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElse(LakehouseTableDelegator.class.getClassLoader());
        ServiceLoader<LakehouseTableDelegator> loader = ServiceLoader.load(LakehouseTableDelegator.class, cl);
        delegators = ImmutableMap.copyOf(loader.stream().collect(Collectors.toMap(provider -> ((LakehouseTableDelegator)provider.get()).tableFormat(), ServiceLoader.Provider::get)));
        Preconditions.checkArgument((!delegators.isEmpty() ? 1 : 0) != 0, (Object)"No LakehouseTableDelegator implementation found via ServiceLoader, this is unexpected, please check the code to see what is going on.");
        LOG.info("Loaded LakehouseTableDelegators: {}", (Object)delegators.keySet());
    }

    public static ImmutableMap<String, LakehouseTableDelegator> tableDelegators() {
        LakehouseTableDelegatorFactory.createTableDelegators();
        return delegators;
    }
}

