/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class GroupPO {
    private Long groupId;
    private String groupName;
    private Long metalakeId;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    public Long getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Long getMetalakeId() {
        return this.metalakeId;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupPO)) {
            return false;
        }
        GroupPO tablePO = (GroupPO)o;
        return Objects.equal((Object)this.getGroupId(), (Object)tablePO.getGroupId()) && Objects.equal((Object)this.getGroupName(), (Object)tablePO.getGroupName()) && Objects.equal((Object)this.getMetalakeId(), (Object)tablePO.getMetalakeId()) && Objects.equal((Object)this.getAuditInfo(), (Object)tablePO.getAuditInfo()) && Objects.equal((Object)this.getCurrentVersion(), (Object)tablePO.getCurrentVersion()) && Objects.equal((Object)this.getLastVersion(), (Object)tablePO.getLastVersion()) && Objects.equal((Object)this.getDeletedAt(), (Object)tablePO.getDeletedAt());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getGroupId(), this.getGroupName(), this.getMetalakeId(), this.getAuditInfo(), this.getCurrentVersion(), this.getLastVersion(), this.getDeletedAt()});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final GroupPO groupPO = new GroupPO();

        private Builder() {
        }

        public Builder withGroupId(Long groupId) {
            this.groupPO.groupId = groupId;
            return this;
        }

        public Builder withGroupName(String groupName) {
            this.groupPO.groupName = groupName;
            return this;
        }

        public Builder withMetalakeId(Long metalakeId) {
            this.groupPO.metalakeId = metalakeId;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.groupPO.auditInfo = auditInfo;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.groupPO.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.groupPO.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.groupPO.deletedAt = deletedAt;
            return this;
        }

        private void validate() {
            Preconditions.checkArgument((this.groupPO.groupId != null ? 1 : 0) != 0, (Object)"Group id is required");
            Preconditions.checkArgument((this.groupPO.groupName != null ? 1 : 0) != 0, (Object)"Group name is required");
            Preconditions.checkArgument((this.groupPO.metalakeId != null ? 1 : 0) != 0, (Object)"Metalake id is required");
            Preconditions.checkArgument((this.groupPO.auditInfo != null ? 1 : 0) != 0, (Object)"Audit info is required");
            Preconditions.checkArgument((this.groupPO.currentVersion != null ? 1 : 0) != 0, (Object)"Current version is required");
            Preconditions.checkArgument((this.groupPO.lastVersion != null ? 1 : 0) != 0, (Object)"Last version is required");
            Preconditions.checkArgument((this.groupPO.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
        }

        public GroupPO build() {
            this.validate();
            return this.groupPO;
        }
    }
}

