/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hive.client;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedActionException;
import java.util.Properties;
import org.apache.gravitino.hive.client.HiveClient;
import org.apache.gravitino.hive.client.HiveClientClassLoader;
import org.apache.gravitino.hive.client.HiveClientFactory;
import org.apache.hadoop.security.UserGroupInformation;

public class ProxyHiveClientImpl
implements InvocationHandler {
    private final HiveClient delegate;
    private final UserGroupInformation ugi;

    private ProxyHiveClientImpl(HiveClient delegate, UserGroupInformation ugi) {
        this.delegate = delegate;
        this.ugi = ugi;
    }

    public static HiveClient createClient(HiveClientClassLoader.HiveVersion version, UserGroupInformation ugi, Properties properties) {
        try {
            HiveClient client = (HiveClient)ugi.doAs(() -> HiveClientFactory.createHiveClientImpl(version, properties, Thread.currentThread().getContextClassLoader()));
            return (HiveClient)Proxy.newProxyInstance(HiveClient.class.getClassLoader(), new Class[]{HiveClient.class}, (InvocationHandler)new ProxyHiveClientImpl(client, ugi));
        }
        catch (IOException | InterruptedException ex) {
            throw new RuntimeException("Failed to create Kerberos Hive client", ex);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return this.ugi.doAs(() -> method.invoke((Object)this.delegate, args));
        }
        catch (UndeclaredThrowableException e) {
            Throwable innerException = e.getCause();
            if (innerException instanceof PrivilegedActionException) {
                throw innerException.getCause();
            }
            if (innerException instanceof InvocationTargetException) {
                throw innerException.getCause();
            }
            throw innerException;
        }
    }
}

