/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hive.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import org.apache.gravitino.hive.HivePartition;
import org.apache.gravitino.hive.HiveSchema;
import org.apache.gravitino.hive.HiveTable;
import org.apache.gravitino.hive.client.HiveClientClassLoader;
import org.apache.gravitino.hive.client.HiveExceptionConverter;
import org.apache.gravitino.hive.client.HiveShim;
import org.apache.gravitino.hive.client.Util;
import org.apache.gravitino.hive.converter.HiveDatabaseConverter;
import org.apache.gravitino.hive.converter.HiveTableConverter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;

class HiveShimV2
extends HiveShim {
    HiveShimV2(Properties properties) {
        super(HiveClientClassLoader.HiveVersion.HIVE2, properties);
    }

    HiveShimV2(HiveClientClassLoader.HiveVersion version, Properties properties) {
        super(version, properties);
    }

    @Override
    public IMetaStoreClient createMetaStoreClient(Properties properties) {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> clientClass = classLoader.loadClass("org.apache.hadoop.hive.metastore.RetryingMetaStoreClient");
            Class<?> hiveConfClass = classLoader.loadClass("org.apache.hadoop.hive.conf.HiveConf");
            Class<?> confClass = classLoader.loadClass("org.apache.hadoop.conf.Configuration");
            Object conf = confClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Util.updateConfigurationFromProperties(properties, (Configuration)conf);
            Constructor<?> hiveConfCtor = hiveConfClass.getConstructor(confClass, Class.class);
            Object hiveConfInstance = hiveConfCtor.newInstance(conf, hiveConfClass);
            Method getProxyMethod = clientClass.getMethod("getProxy", hiveConfClass, Boolean.TYPE);
            return (IMetaStoreClient)getProxyMethod.invoke(null, hiveConfInstance, false);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.other("MetaStoreClient"));
        }
    }

    @Override
    public void createDatabase(HiveSchema database) {
        try {
            Database db = HiveDatabaseConverter.toHiveDb(database);
            this.client.createDatabase(db);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.schema(database.name()));
        }
    }

    @Override
    public HiveSchema getDatabase(String catalogName, String databaseName) {
        try {
            Database db = this.client.getDatabase(databaseName);
            return HiveDatabaseConverter.fromHiveDB(db);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.schema(databaseName));
        }
    }

    @Override
    public void alterDatabase(String catalogName, String databaseName, HiveSchema database) {
        try {
            Database db = HiveDatabaseConverter.toHiveDb(database);
            this.client.alterDatabase(databaseName, db);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.schema(databaseName));
        }
    }

    @Override
    public void dropDatabase(String catalogName, String databaseName, boolean cascade) {
        try {
            this.client.dropDatabase(databaseName, false, false, cascade);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.schema(databaseName));
        }
    }

    @Override
    public List<String> getAllTables(String catalogName, String databaseName) {
        try {
            return this.client.getAllTables(databaseName);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.schema(databaseName));
        }
    }

    @Override
    public List<String> listTableNamesByFilter(String catalogName, String databaseName, String filter, short pageSize) {
        try {
            return this.client.listTableNamesByFilter(databaseName, filter, pageSize);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.schema(databaseName));
        }
    }

    @Override
    public HiveTable getTable(String catalogName, String databaseName, String tableName) {
        try {
            Table tb = this.client.getTable(databaseName, tableName);
            return HiveTableConverter.fromHiveTable(tb);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.table(tableName));
        }
    }

    @Override
    public void alterTable(String catalogName, String databaseName, String tableName, HiveTable alteredHiveTable) {
        try {
            Table tb = HiveTableConverter.toHiveTable(alteredHiveTable);
            this.client.alter_table(databaseName, tableName, tb);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.table(tableName));
        }
    }

    @Override
    public void dropTable(String catalogName, String databaseName, String tableName, boolean deleteData, boolean ifPurge) {
        try {
            this.client.dropTable(databaseName, tableName, deleteData, ifPurge);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.table(tableName));
        }
    }

    @Override
    public void createTable(HiveTable hiveTable) {
        try {
            Table tb = HiveTableConverter.toHiveTable(hiveTable);
            this.client.createTable(tb);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.table(hiveTable.name()));
        }
    }

    @Override
    public List<String> listPartitionNames(HiveTable table, short pageSize) {
        try {
            String databaseName = table.databaseName();
            return this.client.listPartitionNames(databaseName, table.name(), pageSize);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.table(table.name()));
        }
    }

    @Override
    public List<HivePartition> listPartitions(HiveTable table, short pageSize) {
        try {
            String databaseName = table.databaseName();
            List partitions = this.client.listPartitions(databaseName, table.name(), pageSize);
            return partitions.stream().map(p -> HiveTableConverter.fromHivePartition(table, p)).toList();
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.table(table.name()));
        }
    }

    @Override
    public List<HivePartition> listPartitions(HiveTable table, List<String> filterPartitionValueList, short pageSize) {
        try {
            String databaseName = table.databaseName();
            List partitions = this.client.listPartitions(databaseName, table.name(), filterPartitionValueList, pageSize);
            return partitions.stream().map(p -> HiveTableConverter.fromHivePartition(table, p)).toList();
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.table(table.name()));
        }
    }

    @Override
    public HivePartition getPartition(HiveTable table, String partitionName) {
        try {
            String databaseName = table.databaseName();
            List<String> partitionValues = HivePartition.extractPartitionValues(partitionName);
            Partition partition = this.client.getPartition(databaseName, table.name(), partitionValues);
            return HiveTableConverter.fromHivePartition(table, partition);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.partition(partitionName));
        }
    }

    @Override
    public HivePartition addPartition(HiveTable table, HivePartition partition) {
        try {
            String databaseName = table.databaseName();
            Partition hivePartition = HiveTableConverter.toHivePartition(databaseName, table, partition);
            Partition addedPartition = this.client.add_partition(hivePartition);
            return HiveTableConverter.fromHivePartition(table, addedPartition);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.partition(partition.name()));
        }
    }

    @Override
    public void dropPartition(String catalogName, String databaseName, String tableName, String partitionName, boolean deleteData) {
        try {
            List<String> partitionValues = HivePartition.extractPartitionValues(partitionName);
            this.client.dropPartition(databaseName, tableName, partitionValues, deleteData);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.partition(partitionName));
        }
    }

    @Override
    public String getDelegationToken(String finalPrincipalName, String userName) {
        try {
            return this.client.getDelegationToken(finalPrincipalName, userName);
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.other(finalPrincipalName));
        }
    }

    @Override
    public List<HiveTable> getTableObjectsByName(String catalogName, String databaseName, List<String> allTables) {
        try {
            List tables = this.client.getTableObjectsByName(databaseName, allTables);
            return tables.stream().map(HiveTableConverter::fromHiveTable).toList();
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.schema(databaseName));
        }
    }

    @Override
    public List<String> getCatalogs() {
        return List.of();
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }
}

