/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.utils;

import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.Timer;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderResourceCleanerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ClassLoaderResourceCleanerUtils.class);

    private ClassLoaderResourceCleanerUtils() {
    }

    public static void closeClassLoaderResource(ClassLoader classLoader) {
        boolean testEnv;
        boolean bl = testEnv = System.getenv("GRAVITINO_TEST") != null;
        if (testEnv) {
            return;
        }
        ClassLoaderResourceCleanerUtils.executeAndCatch(ClassLoaderResourceCleanerUtils::closeStatsDataClearerInFileSystem, classLoader);
        ClassLoaderResourceCleanerUtils.executeAndCatch(ClassLoaderResourceCleanerUtils::stopThreadsAndClearThreadLocalVariables, classLoader);
        ClassLoaderResourceCleanerUtils.executeAndCatch(ClassLoaderResourceCleanerUtils::releaseLogFactoryInCommonLogging, classLoader);
        ClassLoaderResourceCleanerUtils.executeAndCatch(ClassLoaderResourceCleanerUtils::closeResourceInAWS, classLoader);
        ClassLoaderResourceCleanerUtils.executeAndCatch(ClassLoaderResourceCleanerUtils::closeResourceInGCP, classLoader);
        ClassLoaderResourceCleanerUtils.executeAndCatch(ClassLoaderResourceCleanerUtils::closeResourceInAzure, classLoader);
        ClassLoaderResourceCleanerUtils.executeAndCatch(ClassLoaderResourceCleanerUtils::clearShutdownHooks, classLoader);
    }

    private static void closeStatsDataClearerInFileSystem(ClassLoader targetClassLoader) throws Exception {
        Class<?> fileSystemClass = Class.forName("org.apache.hadoop.fs.FileSystem", true, targetClassLoader);
        MethodUtils.invokeStaticMethod(fileSystemClass, (String)"closeAll", (Object[])new Object[0]);
        Class<?> mutableQuantilesClass = Class.forName("org.apache.hadoop.metrics2.lib.MutableQuantiles", true, targetClassLoader);
        Class<?> statisticsClass = Class.forName("org.apache.hadoop.fs.FileSystem$Statistics", true, targetClassLoader);
        ScheduledExecutorService scheduler = (ScheduledExecutorService)FieldUtils.readStaticField(mutableQuantilesClass, (String)"scheduler", (boolean)true);
        scheduler.shutdownNow();
        Field statisticsCleanerField = FieldUtils.getField(statisticsClass, (String)"STATS_DATA_CLEANER", (boolean)true);
        Object statisticsCleaner = statisticsCleanerField.get(null);
        if (statisticsCleaner != null) {
            ((Thread)statisticsCleaner).interrupt();
            ((Thread)statisticsCleaner).setContextClassLoader(null);
            ((Thread)statisticsCleaner).join();
        }
    }

    private static void stopThreadsAndClearThreadLocalVariables(ClassLoader classLoader) {
        Thread[] threads;
        for (Thread thread : threads = ClassLoaderResourceCleanerUtils.getAllThreads()) {
            ClassLoaderResourceCleanerUtils.clearThreadLocalMap(thread, classLoader);
            if (!ClassLoaderResourceCleanerUtils.runningWithClassLoader(thread, classLoader)) continue;
            LOG.debug("Interrupting thread: {}", (Object)thread.getName());
            thread.setContextClassLoader(null);
            thread.interrupt();
            try {
                thread.join(500L);
            }
            catch (InterruptedException e) {
                LOG.debug("Failed to join thread: {}", (Object)thread.getName(), (Object)e);
            }
        }
    }

    private static boolean runningWithClassLoader(Thread thread, ClassLoader targetClassLoader) {
        return thread != null && thread.getContextClassLoader() == targetClassLoader;
    }

    private static Thread[] getAllThreads() {
        ThreadGroup parentGroup;
        ThreadGroup rootGroup = Thread.currentThread().getThreadGroup();
        while ((parentGroup = rootGroup.getParent()) != null) {
            rootGroup = parentGroup;
        }
        Thread[] threads = new Thread[rootGroup.activeCount()];
        while (rootGroup.enumerate(threads, true) == threads.length) {
            threads = new Thread[threads.length * 2];
        }
        return threads;
    }

    private static void clearThreadLocalMap(Thread thread, ClassLoader targetClassLoader) {
        if (thread == null || !thread.getName().startsWith("Gravitino-webserver-")) {
            return;
        }
        try {
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Object threadLocalMap = threadLocalsField.get(thread);
            if (threadLocalMap != null) {
                Object[] table;
                Class<?> tlmClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
                Field tableField = tlmClass.getDeclaredField("table");
                tableField.setAccessible(true);
                for (Object entry : table = (Object[])tableField.get(threadLocalMap)) {
                    Object value;
                    if (entry == null || (value = FieldUtils.readField((Object)entry, (String)"value", (boolean)true)) == null || value.getClass().getClassLoader() == null || value.getClass().getClassLoader() != targetClassLoader) continue;
                    LOG.debug("Cleaning up thread local {} for thread {} with custom class loader", value, (Object)thread.getName());
                    FieldUtils.writeField((Object)entry, (String)"value", null, (boolean)true);
                }
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to clean up thread locals for thread {}", (Object)thread.getName(), (Object)e);
        }
    }

    private static void clearShutdownHooks(ClassLoader targetClassLoader) throws Exception {
        Class<?> shutdownHooks = Class.forName("java.lang.ApplicationShutdownHooks");
        IdentityHashMap hooks = (IdentityHashMap)FieldUtils.readStaticField(shutdownHooks, (String)"hooks", (boolean)true);
        hooks.entrySet().removeIf(entry -> {
            Thread thread = (Thread)entry.getKey();
            return thread.getContextClassLoader() == targetClassLoader;
        });
    }

    private static void releaseLogFactoryInCommonLogging(ClassLoader currentClassLoader) throws Exception {
        try {
            Class<?> htraceLogFactoryClass = Class.forName("org.apache.htrace.shaded.commons.logging.LogFactory", true, currentClassLoader);
            MethodUtils.invokeStaticMethod(htraceLogFactoryClass, (String)"release", (Object[])new Object[]{currentClassLoader});
        }
        catch (Exception e) {
            LOG.debug("HTrace is not used, skipping release of HTrace LogFactory...");
        }
        Class<?> logFactoryClass = Class.forName("org.apache.commons.logging.LogFactory", true, currentClassLoader);
        MethodUtils.invokeStaticMethod(logFactoryClass, (String)"release", (Object[])new Object[]{currentClassLoader});
    }

    private static void closeResourceInAWS(ClassLoader classLoader) throws Exception {
        Class<?> awsSdkMetricsClass = Class.forName("com.amazonaws.metrics.AwsSdkMetrics", true, classLoader);
        MethodUtils.invokeStaticMethod(awsSdkMetricsClass, (String)"unregisterMetricAdminMBean", (Object[])new Object[0]);
    }

    private static void closeResourceInGCP(ClassLoader classLoader) throws Exception {
        Class<?> relocatedLogFactory = Class.forName("org.apache.gravitino.gcp.shaded.org.apache.commons.logging.LogFactory", true, classLoader);
        MethodUtils.invokeStaticMethod(relocatedLogFactory, (String)"release", (Object[])new Object[]{classLoader});
    }

    private static void closeResourceInAzure(ClassLoader classLoader) throws Exception {
        Class<?> abfsClientThrottlingInterceptClass = Class.forName("org.apache.hadoop.fs.azurebfs.services.AbfsClientThrottlingIntercept", true, classLoader);
        Object abfsClientThrottlingIntercept = FieldUtils.readStaticField(abfsClientThrottlingInterceptClass, (String)"singleton", (boolean)true);
        Object readThrottler = FieldUtils.readField((Object)abfsClientThrottlingIntercept, (String)"readThrottler", (boolean)true);
        Object writeThrottler = FieldUtils.readField((Object)abfsClientThrottlingIntercept, (String)"writeThrottler", (boolean)true);
        Timer readTimer = (Timer)FieldUtils.readField((Object)readThrottler, (String)"timer", (boolean)true);
        readTimer.cancel();
        Timer writeTimer = (Timer)FieldUtils.readField((Object)writeThrottler, (String)"timer", (boolean)true);
        writeTimer.cancel();
        Class<?> relocatedLogFactory = Class.forName("org.apache.gravitino.azure.shaded.org.apache.commons.logging.LogFactory", true, classLoader);
        MethodUtils.invokeStaticMethod(relocatedLogFactory, (String)"release", (Object[])new Object[]{classLoader});
    }

    private static <T> void executeAndCatch(ThrowableConsumer<T> consumer, T value) {
        try {
            consumer.accept(value);
        }
        catch (Exception e) {
            LOG.debug("Failed to execute consumer: ", (Throwable)e);
        }
    }

    @FunctionalInterface
    private static interface ThrowableConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

