/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Booleans;
import java.util.Objects;
import java.util.Set;

public final class JvmOptions {
    private final String extraOptions;
    private final DebugOptions debugOptions;

    public JvmOptions(String extraOptions, DebugOptions debugOptions) {
        this.extraOptions = extraOptions;
        this.debugOptions = debugOptions;
    }

    public String getExtraOptions() {
        return this.extraOptions;
    }

    public DebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public static final class DebugOptions {
        private final boolean doDebug;
        private final boolean doSuspend;
        private final Set<String> runnables;
        public static final DebugOptions NO_DEBUG = new DebugOptions(false, false, null);

        public DebugOptions(boolean doDebug, boolean doSuspend, Iterable<String> runnables) {
            this.doDebug = doDebug;
            this.doSuspend = doDebug && doSuspend;
            this.runnables = doDebug && runnables != null && Iterables.size(runnables) > 0 ? ImmutableSet.copyOf(runnables) : null;
        }

        public boolean doDebug() {
            return this.doDebug;
        }

        public boolean doSuspend() {
            return this.doSuspend;
        }

        public Set<String> getRunnables() {
            return this.runnables;
        }

        public boolean doDebug(String runnable) {
            return this.doDebug && (this.runnables == null || this.runnables.contains(runnable));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof DebugOptions)) {
                return false;
            }
            DebugOptions that = (DebugOptions)object;
            return this.doDebug == that.doDebug() && this.doSuspend == this.doSuspend() && Objects.equals(this.runnables, that.getRunnables());
        }

        public int hashCode() {
            int hash = 17;
            hash = 31 * hash + Booleans.hashCode((boolean)this.doDebug);
            hash = 31 * hash + Booleans.hashCode((boolean)this.doSuspend);
            hash = 31 * hash + Objects.hashCode(this.runnables);
            return hash;
        }

        public String toString() {
            return "{\"doDebug\":" + this.doDebug + ",\"doSuspend\":" + this.doSuspend + ",\"runnables\":" + (this.runnables != null ? this.runnables.toString() : "none") + "}";
        }
    }
}

