/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.paimon.data.columnar.BytesColumnVector;
import org.apache.paimon.data.columnar.heap.HeapBytesVector;
import org.apache.paimon.data.columnar.heap.HeapIntVector;
import org.apache.paimon.data.columnar.writable.WritableBytesVector;
import org.apache.paimon.data.columnar.writable.WritableIntVector;
import org.apache.paimon.format.parquet.reader.VectorizedDeltaBinaryPackedReader;
import org.apache.paimon.format.parquet.reader.VectorizedDeltaLengthByteArrayReader;
import org.apache.paimon.format.parquet.reader.VectorizedReaderBase;
import org.apache.paimon.format.parquet.reader.VectorizedValuesReader;
import org.apache.paimon.shade.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.paimon.shade.org.apache.parquet.column.values.RequiresPreviousReader;
import org.apache.paimon.shade.org.apache.parquet.column.values.ValuesReader;
import org.apache.paimon.shade.org.apache.parquet.io.api.Binary;

public class VectorizedDeltaByteArrayReader
extends VectorizedReaderBase
implements VectorizedValuesReader,
RequiresPreviousReader {
    private final VectorizedDeltaBinaryPackedReader prefixLengthReader = new VectorizedDeltaBinaryPackedReader();
    private final VectorizedDeltaLengthByteArrayReader suffixReader = new VectorizedDeltaLengthByteArrayReader();
    private HeapIntVector prefixLengthVector;
    private ByteBuffer previous;
    private int currentRow = 0;
    private final HeapBytesVector binaryValVector = new HeapBytesVector(1);
    private final HeapBytesVector tempBinaryValVector = new HeapBytesVector(1);

    VectorizedDeltaByteArrayReader() {
    }

    @Override
    public void initFromPage(int valueCount, ByteBufferInputStream in) throws IOException {
        this.prefixLengthVector = new HeapIntVector(valueCount);
        this.prefixLengthReader.initFromPage(valueCount, in);
        this.prefixLengthReader.readIntegers(this.prefixLengthReader.getTotalValueCount(), (WritableIntVector)this.prefixLengthVector, 0);
        this.suffixReader.initFromPage(valueCount, in);
    }

    @Override
    public Binary readBinary(int len) {
        this.readValues(1, (WritableBytesVector)this.binaryValVector, 0);
        return Binary.fromConstantByteArray(this.binaryValVector.getBytes(0).getBytes());
    }

    private void readValues(int total, WritableBytesVector c, int rowId) {
        for (int i = 0; i < total; ++i) {
            int prefixLength = this.prefixLengthVector.getInt(this.currentRow);
            ByteBuffer suffix = this.suffixReader.getBytes(this.currentRow);
            byte[] suffixArray = suffix.array();
            int suffixLength = suffix.limit() - suffix.position();
            int length = prefixLength + suffixLength;
            int offset = c.getElementsAppended();
            byte[] bytes = new byte[length];
            if (prefixLength != 0) {
                System.arraycopy(this.previous.array(), this.previous.position(), bytes, 0, prefixLength);
            }
            System.arraycopy(suffixArray, suffix.position(), bytes, prefixLength, suffixLength);
            c.putByteArray(rowId + i, bytes, offset, length);
            BytesColumnVector.Bytes b = c.getBytes(rowId + i);
            this.previous = ByteBuffer.wrap(b.data, b.offset, b.len);
            ++this.currentRow;
        }
    }

    @Override
    public void readBinary(int total, WritableBytesVector c, int rowId) {
        this.readValues(total, c, rowId);
    }

    @Override
    public void setPreviousReader(ValuesReader reader) {
        if (reader != null) {
            this.previous = ((VectorizedDeltaByteArrayReader)reader).previous;
        }
    }

    @Override
    public void skipBinary(int total) {
        HeapBytesVector c1 = this.tempBinaryValVector;
        HeapBytesVector c2 = this.binaryValVector;
        for (int i = 0; i < total; ++i) {
            int prefixLength = this.prefixLengthVector.getInt(this.currentRow);
            ByteBuffer suffix = this.suffixReader.getBytes(this.currentRow);
            byte[] suffixArray = suffix.array();
            int suffixLength = suffix.limit() - suffix.position();
            int length = prefixLength + suffixLength;
            byte[] bytes = new byte[length];
            c1.reset();
            if (prefixLength != 0) {
                System.arraycopy(this.previous.array(), this.previous.position(), bytes, 0, prefixLength);
            }
            System.arraycopy(suffixArray, suffix.position(), bytes, prefixLength, suffixLength);
            c1.putByteArray(0, bytes, 0, length);
            BytesColumnVector.Bytes b = c1.getBytes(0);
            this.previous = ByteBuffer.wrap(b.data, b.offset, b.len);
            ++this.currentRow;
            HeapBytesVector tmp = c1;
            c1 = c2;
            c2 = tmp;
        }
    }
}

