/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.orc.reader;

import org.apache.paimon.data.Timestamp;
import org.apache.paimon.format.orc.reader.AbstractOrcColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.utils.DateTimeUtils;

public class OrcTimestampColumnVector
extends AbstractOrcColumnVector
implements org.apache.paimon.data.columnar.TimestampColumnVector {
    private final Boolean legacyTimestampLtzType;
    private final DataType dataType;
    private final TimestampColumnVector vector;

    public OrcTimestampColumnVector(ColumnVector vector, VectorizedRowBatch orcBatch, DataType dataType, boolean legacyTimestampLtzType) {
        super(vector, orcBatch);
        this.vector = (TimestampColumnVector)vector;
        this.dataType = dataType;
        this.legacyTimestampLtzType = legacyTimestampLtzType;
    }

    public Timestamp getTimestamp(int i, int precision) {
        i = this.rowMapper(i);
        if (this.dataType instanceof TimestampType || this.legacyTimestampLtzType.booleanValue()) {
            return DateTimeUtils.toInternal((long)this.vector.time[i], (int)(this.vector.nanos[i] % 1000000));
        }
        return Timestamp.fromEpochMillis((long)this.vector.time[i], (int)(this.vector.nanos[i] % 1000000));
    }
}

