/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.splitread;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.operation.MergeFileSplitRead;
import org.apache.paimon.operation.SplitRead;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.KeyValueTableRead;
import org.apache.paimon.table.source.splitread.SplitReadProvider;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.LazyField;

public class MergeFileSplitReadProvider
implements SplitReadProvider {
    private final LazyField<SplitRead<InternalRow>> splitRead = new LazyField(() -> {
        SplitRead<InternalRow> read = this.create(supplier);
        valuesAssigner.accept(read);
        return read;
    });

    public MergeFileSplitReadProvider(Supplier<MergeFileSplitRead> supplier, Consumer<SplitRead<InternalRow>> valuesAssigner) {
    }

    private SplitRead<InternalRow> create(Supplier<MergeFileSplitRead> supplier) {
        MergeFileSplitRead read = supplier.get().withReadKeyType(RowType.of());
        return SplitRead.convert(read, split -> KeyValueTableRead.unwrap(read.createReader((DataSplit)split)));
    }

    @Override
    public boolean match(DataSplit split, boolean forceKeepDelete) {
        return split.beforeFiles().isEmpty();
    }

    @Override
    public boolean initialized() {
        return this.splitRead.initialized();
    }

    @Override
    public SplitRead<InternalRow> getOrCreate() {
        return (SplitRead)this.splitRead.get();
    }
}

