/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.apache.paimon.Changelog;
import org.apache.paimon.Snapshot;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.utils.ChangelogManager;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public class RollbackHelper {
    private final SnapshotManager snapshotManager;
    private final ChangelogManager changelogManager;
    private final TagManager tagManager;
    private final FileIO fileIO;

    public RollbackHelper(SnapshotManager snapshotManager, ChangelogManager changelogManager, TagManager tagManager, FileIO fileIO) {
        this.snapshotManager = snapshotManager;
        this.changelogManager = changelogManager;
        this.tagManager = tagManager;
        this.fileIO = fileIO;
    }

    public void cleanLargerThan(Snapshot retainedSnapshot) {
        try {
            this.cleanSnapshots(retainedSnapshot);
            this.cleanLongLivedChangelogs(retainedSnapshot);
            this.cleanTags(retainedSnapshot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void createSnapshotFileIfNeeded(Snapshot taggedSnapshot) {
        if (!this.snapshotManager.snapshotExists(taggedSnapshot.id())) {
            try {
                this.fileIO.writeFile(this.snapshotManager.snapshotPath(taggedSnapshot.id()), taggedSnapshot.toJson(), false);
                this.snapshotManager.commitEarliestHint(taggedSnapshot.id());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void cleanSnapshots(Snapshot retainedSnapshot) throws IOException {
        long earliest = (Long)Preconditions.checkNotNull((Object)this.snapshotManager.earliestSnapshotId(), (String)"Cannot find earliest snapshot.");
        long latest = (Long)Preconditions.checkNotNull((Object)this.snapshotManager.latestSnapshotId(), (String)"Cannot find latest snapshot.");
        this.snapshotManager.commitLatestHint(retainedSnapshot.id());
        long to = Math.max(earliest, retainedSnapshot.id() + 1L);
        for (long i = latest; i >= to; --i) {
            if (!this.snapshotManager.snapshotExists(i)) continue;
            this.snapshotManager.deleteSnapshot(i);
        }
    }

    private void cleanLongLivedChangelogs(Snapshot retainedSnapshot) throws IOException {
        Long earliest = this.changelogManager.earliestLongLivedChangelogId();
        Long latest = this.changelogManager.latestLongLivedChangelogId();
        if (earliest == null || latest == null) {
            return;
        }
        ArrayList<Changelog> toBeCleaned = new ArrayList<Changelog>();
        long to = Math.max(earliest, retainedSnapshot.id() + 1L);
        for (long i = latest.longValue(); i >= to; --i) {
            toBeCleaned.add(this.changelogManager.changelog(i));
        }
        if (!toBeCleaned.isEmpty()) {
            if (to == earliest) {
                this.changelogManager.commitLongLivedChangelogLatestHint(-1L);
            } else {
                this.changelogManager.commitLongLivedChangelogLatestHint(to - 1L);
            }
        }
        for (Changelog changelog : toBeCleaned) {
            this.fileIO.deleteQuietly(this.changelogManager.longLivedChangelogPath(changelog.id()));
        }
    }

    private void cleanTags(Snapshot retainedSnapshot) {
        Snapshot tag;
        SortedMap<Snapshot, List<String>> tags = this.tagManager.tags();
        if (tags.isEmpty()) {
            return;
        }
        ArrayList<Snapshot> taggedSnapshots = new ArrayList<Snapshot>(tags.keySet());
        for (int i = taggedSnapshots.size() - 1; i >= 0 && (tag = (Snapshot)taggedSnapshots.get(i)).id() > retainedSnapshot.id(); --i) {
            ((List)tags.get(tag)).forEach(tagName -> this.fileIO.deleteQuietly(this.tagManager.tagPath((String)tagName)));
        }
    }
}

