/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.stats;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.paimon.casting.CastFieldGetter;
import org.apache.paimon.casting.CastedRow;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.ProjectedArray;
import org.apache.paimon.utils.ProjectedRow;

public class SimpleStatsEvolution {
    private final List<String> fieldNames;
    @Nullable
    private final int[] indexMapping;
    @Nullable
    private final CastFieldGetter[] castFieldGetters;
    private final Map<List<String>, int[]> indexMappings;
    private final GenericRow emptyValues;
    private final GenericArray emptyNullCounts;

    public SimpleStatsEvolution(RowType rowType, @Nullable int[] indexMapping, @Nullable CastFieldGetter[] castFieldGetters) {
        this.fieldNames = rowType.getFieldNames();
        this.indexMapping = indexMapping;
        this.castFieldGetters = castFieldGetters;
        this.indexMappings = new ConcurrentHashMap<List<String>, int[]>();
        this.emptyValues = new GenericRow(this.fieldNames.size());
        this.emptyNullCounts = new GenericArray(new Object[this.fieldNames.size()]);
    }

    public InternalRow evolution(InternalRow row, @Nullable List<String> denseFields) {
        InternalRow result = row;
        if (denseFields != null && denseFields.isEmpty()) {
            result = this.emptyValues;
        } else if (denseFields != null) {
            int[] denseIndexMapping = this.indexMappings.computeIfAbsent(denseFields, k -> this.fieldNames.stream().mapToInt(denseFields::indexOf).toArray());
            result = ProjectedRow.from((int[])denseIndexMapping).replaceRow(result);
        }
        if (this.indexMapping != null) {
            result = ProjectedRow.from((int[])this.indexMapping).replaceRow(result);
        }
        if (this.castFieldGetters != null) {
            result = CastedRow.from((CastFieldGetter[])this.castFieldGetters).replaceRow(result);
        }
        return result;
    }

    public Result evolution(SimpleStats stats, @Nullable Long rowCount, @Nullable List<String> denseFields) {
        BinaryRow minValues = stats.minValues();
        BinaryRow maxValues = stats.maxValues();
        Object nullCounts = stats.nullCounts();
        if (denseFields != null && denseFields.isEmpty()) {
            minValues = this.emptyValues;
            maxValues = this.emptyValues;
            nullCounts = this.emptyNullCounts;
        } else if (denseFields != null) {
            int[] denseIndexMapping = this.indexMappings.computeIfAbsent(denseFields, k -> this.fieldNames.stream().mapToInt(denseFields::indexOf).toArray());
            minValues = ProjectedRow.from((int[])denseIndexMapping).replaceRow((InternalRow)minValues);
            maxValues = ProjectedRow.from((int[])denseIndexMapping).replaceRow((InternalRow)maxValues);
            nullCounts = ProjectedArray.from((int[])denseIndexMapping).replaceArray((InternalArray)nullCounts);
        }
        if (this.indexMapping != null) {
            minValues = ProjectedRow.from((int[])this.indexMapping).replaceRow((InternalRow)minValues);
            maxValues = ProjectedRow.from((int[])this.indexMapping).replaceRow((InternalRow)maxValues);
            if (rowCount == null) {
                throw new RuntimeException("Schema Evolution for stats needs row count.");
            }
            nullCounts = new NullCountsEvoArray(this.indexMapping, (InternalArray)nullCounts, rowCount);
        }
        if (this.castFieldGetters != null) {
            minValues = CastedRow.from((CastFieldGetter[])this.castFieldGetters).replaceRow((InternalRow)minValues);
            maxValues = CastedRow.from((CastFieldGetter[])this.castFieldGetters).replaceRow((InternalRow)maxValues);
        }
        return new Result((InternalRow)minValues, (InternalRow)maxValues, (InternalArray)nullCounts);
    }

    private static class NullCountsEvoArray
    implements InternalArray {
        private final int[] indexMapping;
        private final InternalArray array;
        private final long notFoundValue;

        private NullCountsEvoArray(int[] indexMapping, InternalArray array, long notFoundValue) {
            this.indexMapping = indexMapping;
            this.array = array;
            this.notFoundValue = notFoundValue;
        }

        public int size() {
            return this.indexMapping.length;
        }

        public boolean isNullAt(int pos) {
            if (this.indexMapping[pos] < 0) {
                return false;
            }
            return this.array.isNullAt(this.indexMapping[pos]);
        }

        public long getLong(int pos) {
            if (this.indexMapping[pos] < 0) {
                return this.notFoundValue;
            }
            return this.array.getLong(this.indexMapping[pos]);
        }

        public boolean getBoolean(int pos) {
            throw new UnsupportedOperationException();
        }

        public byte getByte(int pos) {
            throw new UnsupportedOperationException();
        }

        public short getShort(int pos) {
            throw new UnsupportedOperationException();
        }

        public int getInt(int pos) {
            throw new UnsupportedOperationException();
        }

        public float getFloat(int pos) {
            throw new UnsupportedOperationException();
        }

        public double getDouble(int pos) {
            throw new UnsupportedOperationException();
        }

        public BinaryString getString(int pos) {
            throw new UnsupportedOperationException();
        }

        public Decimal getDecimal(int pos, int precision, int scale) {
            throw new UnsupportedOperationException();
        }

        public Timestamp getTimestamp(int pos, int precision) {
            throw new UnsupportedOperationException();
        }

        public byte[] getBinary(int pos) {
            throw new UnsupportedOperationException();
        }

        public Variant getVariant(int pos) {
            throw new UnsupportedOperationException();
        }

        public InternalArray getArray(int pos) {
            throw new UnsupportedOperationException();
        }

        public InternalMap getMap(int pos) {
            throw new UnsupportedOperationException();
        }

        public InternalRow getRow(int pos, int numFields) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            throw new UnsupportedOperationException();
        }

        public boolean[] toBooleanArray() {
            throw new UnsupportedOperationException();
        }

        public byte[] toByteArray() {
            throw new UnsupportedOperationException();
        }

        public short[] toShortArray() {
            throw new UnsupportedOperationException();
        }

        public int[] toIntArray() {
            throw new UnsupportedOperationException();
        }

        public long[] toLongArray() {
            throw new UnsupportedOperationException();
        }

        public float[] toFloatArray() {
            throw new UnsupportedOperationException();
        }

        public double[] toDoubleArray() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Result {
        private final InternalRow minValues;
        private final InternalRow maxValues;
        private final InternalArray nullCounts;

        public Result(InternalRow minValues, InternalRow maxValues, InternalArray nullCounts) {
            this.minValues = minValues;
            this.maxValues = maxValues;
            this.nullCounts = nullCounts;
        }

        public InternalRow minValues() {
            return this.minValues;
        }

        public InternalRow maxValues() {
            return this.maxValues;
        }

        public InternalArray nullCounts() {
            return this.nullCounts;
        }
    }
}

