/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.sort;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.codegen.NormalizedKeyComputer;
import org.apache.paimon.codegen.RecordComparator;
import org.apache.paimon.data.AbstractPagedInputView;
import org.apache.paimon.data.AbstractPagedOutputView;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.SimpleCollectingOutputView;
import org.apache.paimon.data.serializer.AbstractRowDataSerializer;
import org.apache.paimon.data.serializer.BinaryRowSerializer;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.memory.MemorySegmentSource;
import org.apache.paimon.sort.BinaryIndexedSortable;
import org.apache.paimon.sort.QuickSort;
import org.apache.paimon.sort.SortBuffer;
import org.apache.paimon.utils.MutableObjectIterator;
import org.apache.paimon.utils.Preconditions;

public class BinaryInMemorySortBuffer
extends BinaryIndexedSortable
implements SortBuffer {
    private static final int MIN_REQUIRED_BUFFERS = 3;
    private final AbstractRowDataSerializer<InternalRow> inputSerializer;
    private final ArrayList<MemorySegment> recordBufferSegments;
    private final SimpleCollectingOutputView recordCollector;
    private long currentDataBufferOffset;
    private long sortIndexBytes;
    private boolean isInitialized;

    public static BinaryInMemorySortBuffer createBuffer(NormalizedKeyComputer normalizedKeyComputer, AbstractRowDataSerializer<InternalRow> serializer, RecordComparator comparator, MemorySegmentPool memoryPool) {
        Preconditions.checkArgument((memoryPool.freePages() >= 3 ? 1 : 0) != 0);
        ArrayList<MemorySegment> recordBufferSegments = new ArrayList<MemorySegment>(16);
        return new BinaryInMemorySortBuffer(normalizedKeyComputer, serializer, comparator, recordBufferSegments, new SimpleCollectingOutputView(recordBufferSegments, (MemorySegmentSource)memoryPool, memoryPool.pageSize()), memoryPool);
    }

    private BinaryInMemorySortBuffer(NormalizedKeyComputer normalizedKeyComputer, AbstractRowDataSerializer<InternalRow> inputSerializer, RecordComparator comparator, ArrayList<MemorySegment> recordBufferSegments, SimpleCollectingOutputView recordCollector, MemorySegmentPool pool) {
        super(normalizedKeyComputer, new BinaryRowSerializer(inputSerializer.getArity()), comparator, recordBufferSegments, pool);
        this.inputSerializer = inputSerializer;
        this.recordBufferSegments = recordBufferSegments;
        this.recordCollector = recordCollector;
        this.isInitialized = true;
        this.clear();
    }

    private void returnToSegmentPool() {
        this.memorySegmentPool.returnAll((List)this.sortIndex);
        this.memorySegmentPool.returnAll(this.recordBufferSegments);
        this.sortIndex.clear();
        this.recordBufferSegments.clear();
    }

    public int getBufferSegmentCount() {
        return this.recordBufferSegments.size();
    }

    private void tryInitialize() {
        if (!this.isInitialized) {
            this.currentSortIndexSegment = this.nextMemorySegment();
            this.sortIndex.add(this.currentSortIndexSegment);
            this.recordCollector.reset();
            this.isInitialized = true;
        }
    }

    @Override
    public void clear() {
        if (this.isInitialized) {
            this.numRecords = 0;
            this.currentSortIndexOffset = 0;
            this.currentDataBufferOffset = 0L;
            this.sortIndexBytes = 0L;
            this.returnToSegmentPool();
            this.currentSortIndexSegment = null;
            this.isInitialized = false;
        }
    }

    @Override
    public long getOccupancy() {
        return this.currentDataBufferOffset + this.sortIndexBytes;
    }

    @Override
    public boolean flushMemory() {
        return false;
    }

    boolean isEmpty() {
        return this.numRecords == 0;
    }

    @Override
    public boolean write(InternalRow record) throws IOException {
        int skip;
        this.tryInitialize();
        if (!this.checkNextIndexOffset()) {
            return false;
        }
        try {
            skip = this.inputSerializer.serializeToPages((Object)record, (AbstractPagedOutputView)this.recordCollector);
        }
        catch (EOFException e) {
            return false;
        }
        long newOffset = this.recordCollector.getCurrentOffset();
        long currOffset = this.currentDataBufferOffset + (long)skip;
        this.writeIndexAndNormalizedKey(record, currOffset);
        this.sortIndexBytes += (long)this.indexEntrySize;
        this.currentDataBufferOffset = newOffset;
        return true;
    }

    private BinaryRow getRecordFromBuffer(BinaryRow reuse, long pointer) throws IOException {
        this.recordBuffer.setReadPosition(pointer);
        return this.serializer.mapFromPages(reuse, (AbstractPagedInputView)this.recordBuffer);
    }

    private MutableObjectIterator<BinaryRow> iterator() {
        this.tryInitialize();
        return new MutableObjectIterator<BinaryRow>(){
            private final int size;
            private int current;
            private int currentSegment;
            private int currentOffset;
            private MemorySegment currentIndexSegment;
            {
                this.size = BinaryInMemorySortBuffer.this.size();
                this.current = 0;
                this.currentSegment = 0;
                this.currentOffset = 0;
                this.currentIndexSegment = (MemorySegment)BinaryInMemorySortBuffer.this.sortIndex.get(0);
            }

            @Override
            public BinaryRow next(BinaryRow target) {
                if (this.current < this.size) {
                    ++this.current;
                    if (this.currentOffset > BinaryInMemorySortBuffer.this.lastIndexEntryOffset) {
                        this.currentOffset = 0;
                        this.currentIndexSegment = (MemorySegment)BinaryInMemorySortBuffer.this.sortIndex.get(++this.currentSegment);
                    }
                    long pointer = this.currentIndexSegment.getLong(this.currentOffset);
                    this.currentOffset += BinaryInMemorySortBuffer.this.indexEntrySize;
                    try {
                        return BinaryInMemorySortBuffer.this.getRecordFromBuffer(target, pointer);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                return null;
            }

            @Override
            public BinaryRow next() {
                throw new RuntimeException("Not support!");
            }
        };
    }

    @Override
    public final MutableObjectIterator<BinaryRow> sortedIterator() {
        if (this.numRecords > 0) {
            new QuickSort().sort(this);
        }
        return this.iterator();
    }
}

